/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.item.playerentity;

import com.mojang.blaze3d.platform.NativeImage;
import de.keksuccino.konkrete.input.CharacterFilter;
import de.keksuccino.konkrete.resources.SelfcleaningDynamicTexture;
import de.keksuccino.konkrete.resources.WebTextureResourceLocation;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;

public class SkinWebTextureResourceLocation
extends WebTextureResourceLocation {
    protected boolean loaded = false;
    protected int width = 0;
    protected int height = 0;
    protected ResourceLocation location = null;
    protected String url;

    public SkinWebTextureResourceLocation(String url) {
        super(url);
        this.url = url;
    }

    public void loadTexture() {
        if (!this.loaded) {
            try {
                if (Minecraft.m_91087_().m_91097_() == null) {
                    System.out.println("################################ WARNING ################################");
                    System.out.println("Can't load texture '" + this.url + "'! Minecraft TextureManager instance not ready yet!");
                    return;
                }
                URL u = new URL(this.url);
                HttpURLConnection httpcon = (HttpURLConnection)u.openConnection();
                httpcon.addRequestProperty("User-Agent", "Mozilla/4.0");
                InputStream s = httpcon.getInputStream();
                if (s == null) {
                    return;
                }
                NativeImage i = NativeImage.m_85058_((InputStream)s);
                this.width = i.m_84982_();
                this.height = i.m_85084_();
                if (this.height < 64) {
                    NativeImage skinNew = new NativeImage(64, 64, true);
                    skinNew.m_85054_(i);
                    int xOffsetLeg = 16;
                    int yOffsetLeg = 32;
                    SkinWebTextureResourceLocation.cloneSkinPart(skinNew, 4, 16, 4, 4, xOffsetLeg, yOffsetLeg, true);
                    SkinWebTextureResourceLocation.cloneSkinPart(skinNew, 8, 16, 4, 4, xOffsetLeg, yOffsetLeg, true);
                    SkinWebTextureResourceLocation.cloneSkinPart(skinNew, 0, 20, 4, 12, xOffsetLeg + 8, yOffsetLeg, true);
                    SkinWebTextureResourceLocation.cloneSkinPart(skinNew, 4, 20, 4, 12, xOffsetLeg, yOffsetLeg, true);
                    SkinWebTextureResourceLocation.cloneSkinPart(skinNew, 8, 20, 4, 12, xOffsetLeg - 8, yOffsetLeg, true);
                    SkinWebTextureResourceLocation.cloneSkinPart(skinNew, 12, 20, 4, 12, xOffsetLeg, yOffsetLeg, true);
                    int xOffsetArm = -8;
                    int yOffsetArm = 32;
                    SkinWebTextureResourceLocation.cloneSkinPart(skinNew, 44, 16, 4, 4, xOffsetArm, yOffsetArm, true);
                    SkinWebTextureResourceLocation.cloneSkinPart(skinNew, 48, 16, 4, 4, xOffsetArm, yOffsetArm, true);
                    SkinWebTextureResourceLocation.cloneSkinPart(skinNew, 40, 20, 4, 12, xOffsetArm + 8, yOffsetArm, true);
                    SkinWebTextureResourceLocation.cloneSkinPart(skinNew, 44, 20, 4, 12, xOffsetArm, yOffsetArm, true);
                    SkinWebTextureResourceLocation.cloneSkinPart(skinNew, 48, 20, 4, 12, xOffsetArm - 8, yOffsetArm, true);
                    SkinWebTextureResourceLocation.cloneSkinPart(skinNew, 52, 20, 4, 12, xOffsetArm, yOffsetArm, true);
                    i = skinNew;
                }
                this.location = Minecraft.m_91087_().m_91097_().m_118490_(this.filterUrl(this.url), (DynamicTexture)new SelfcleaningDynamicTexture(i));
                s.close();
                this.loaded = true;
            }
            catch (Exception var5) {
                System.out.println("######################### ERROR #########################");
                System.out.println("Can't load texture '" + this.url + "'! Invalid URL!");
                System.out.println("#########################################################");
                this.loaded = false;
                var5.printStackTrace();
            }
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public ResourceLocation getResourceLocation() {
        return this.location;
    }

    public String getURL() {
        return this.url;
    }

    public boolean isReady() {
        return this.loaded;
    }

    protected String filterUrl(String url) {
        CharacterFilter c = new CharacterFilter();
        c.addAllowedCharacters(new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "."});
        return c.filterForAllowedChars(url.toLowerCase());
    }

    protected static void copyPixelArea(NativeImage in, int xFrom, int yFrom, int xTo, int yTo, int width, int height, boolean mirrorX) {
        int vertOffset = 0;
        int vertical = yTo;
        while (vertical < yTo + height) {
            int horiOffset = 0;
            if (mirrorX) {
                horiOffset = width - 1;
            }
            int horizontal = xTo;
            while (horizontal < xTo + width) {
                int pixel = in.m_84985_(xFrom + horiOffset, yFrom + vertOffset);
                in.m_84988_(horizontal, vertical, pixel);
                ++horizontal;
                if (mirrorX) {
                    --horiOffset;
                    continue;
                }
                ++horiOffset;
            }
            ++vertical;
            ++vertOffset;
        }
    }

    protected static void cloneSkinPart(NativeImage in, int xStart, int yStart, int width, int height, int xOffset, int yOffset, boolean mirrorX) {
        SkinWebTextureResourceLocation.copyPixelArea(in, xStart, yStart, xStart + xOffset, yStart + yOffset, width, height, mirrorX);
    }
}

