/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.prism;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.type.IBlockType;
import xfacthd.framedblocks.api.util.CtmPredicate;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;

public class FramedSlopedPrismBlock
extends FramedBlock {
    public static final CtmPredicate CTM_PREDICATE_INNER = (state, side) -> {
        Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
        Direction orientation = (Direction)state.m_61143_((Property)PropertyHolder.ORIENTATION);
        if (side != null && side.m_122434_() != facing.m_122434_() && side.m_122434_() != orientation.m_122434_()) {
            return true;
        }
        return side == facing.m_122424_() || side == orientation.m_122424_();
    };

    public FramedSlopedPrismBlock(BlockType type) {
        super(type);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)Direction.NORTH)).m_61124_((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BlockStateProperties.f_61372_, PropertyHolder.ORIENTATION, BlockStateProperties.f_61362_, FramedProperties.SOLID, FramedProperties.GLOWING, FramedProperties.Y_SLOPE});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return FramedSlopedPrismBlock.getStateForPlacement(context, this.m_49966_(), this.getBlockType());
    }

    public static BlockState getStateForPlacement(BlockPlaceContext context, BlockState state, IBlockType blockType) {
        Direction orientation;
        Direction face = context.m_43719_();
        state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)face);
        if (Utils.isY(face)) {
            orientation = context.m_8125_();
            if (blockType == BlockType.FRAMED_INNER_SLOPED_PRISM || blockType == BlockType.FRAMED_DOUBLE_SLOPED_PRISM) {
                orientation = orientation.m_122424_();
            }
        } else {
            Vec3 subHit = Utils.fraction(context.m_43720_());
            double xz = (Utils.isX(face) ? subHit.m_7094_() : subHit.m_7096_()) - 0.5;
            double y = subHit.m_7098_() - 0.5;
            orientation = Math.max(Math.abs(xz), Math.abs(y)) == Math.abs(xz) ? (Utils.isX(face) ? (xz < 0.0 ? Direction.SOUTH : Direction.NORTH) : (xz < 0.0 ? Direction.EAST : Direction.WEST)) : (y < 0.0 ? Direction.UP : Direction.DOWN);
        }
        state = (BlockState)state.m_61124_((Property)PropertyHolder.ORIENTATION, (Comparable)orientation);
        if (blockType == BlockType.FRAMED_SLOPED_PRISM) {
            state = FramedSlopedPrismBlock.withWater(state, (LevelReader)context.m_43725_(), context.m_8083_());
        }
        return state;
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        return IFramedBlock.toggleYSlope(state, level, pos, player);
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        if (rot == Rotation.NONE) {
            return state;
        }
        Direction dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
        Direction orientation = (Direction)state.m_61143_((Property)PropertyHolder.ORIENTATION);
        if (Utils.isY(dir)) {
            return (BlockState)state.m_61124_((Property)PropertyHolder.ORIENTATION, (Comparable)rot.m_55954_(orientation));
        }
        if (!Utils.isY(orientation)) {
            state = (BlockState)state.m_61124_((Property)PropertyHolder.ORIENTATION, (Comparable)rot.m_55954_(orientation));
        }
        return (BlockState)state.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)rot.m_55954_(dir));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return Utils.mirrorFaceBlock(state, BlockStateProperties.f_61372_, mirror);
    }

    public static ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        VoxelShape shapeBottom = Shapes.m_83124_((VoxelShape)FramedSlopedPrismBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.5, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedSlopedPrismBlock.m_49796_((double)0.5, (double)0.0, (double)0.0, (double)15.5, (double)4.0, (double)15.5), FramedSlopedPrismBlock.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)8.0, (double)12.0)}).m_83296_();
        VoxelShape shapeTop = Shapes.m_83124_((VoxelShape)FramedSlopedPrismBlock.m_49796_((double)0.0, (double)15.5, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedSlopedPrismBlock.m_49796_((double)0.5, (double)12.0, (double)0.0, (double)15.5, (double)16.0, (double)15.5), FramedSlopedPrismBlock.m_49796_((double)4.0, (double)8.0, (double)0.0, (double)12.0, (double)16.0, (double)12.0)}).m_83296_();
        VoxelShape shapeRight = Shapes.m_83124_((VoxelShape)FramedSlopedPrismBlock.m_49796_((double)0.0, (double)0.0, (double)15.5, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedSlopedPrismBlock.m_49796_((double)0.0, (double)0.5, (double)12.0, (double)15.5, (double)15.5, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.0, (double)4.0, (double)8.0, (double)12.0, (double)12.0, (double)16.0)}).m_83296_();
        VoxelShape shapeLeft = Shapes.m_83124_((VoxelShape)FramedSlopedPrismBlock.m_49796_((double)0.0, (double)0.0, (double)15.5, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedSlopedPrismBlock.m_49796_((double)0.5, (double)0.5, (double)12.0, (double)16.0, (double)15.5, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)4.0, (double)4.0, (double)8.0, (double)16.0, (double)12.0, (double)16.0)}).m_83296_();
        VoxelShape shapeUp = Shapes.m_83124_((VoxelShape)FramedSlopedPrismBlock.m_49796_((double)0.0, (double)0.0, (double)15.5, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedSlopedPrismBlock.m_49796_((double)0.5, (double)0.5, (double)12.0, (double)15.5, (double)16.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)4.0, (double)4.0, (double)8.0, (double)12.0, (double)16.0, (double)16.0)}).m_83296_();
        VoxelShape shapeDown = Shapes.m_83124_((VoxelShape)FramedSlopedPrismBlock.m_49796_((double)0.0, (double)0.0, (double)15.5, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedSlopedPrismBlock.m_49796_((double)0.5, (double)0.0, (double)12.0, (double)15.5, (double)15.5, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)4.0, (double)0.0, (double)8.0, (double)12.0, (double)12.0, (double)16.0)}).m_83296_();
        for (BlockState state : states) {
            VoxelShape shape;
            Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
            Direction orientation = (Direction)state.m_61143_((Property)PropertyHolder.ORIENTATION);
            if (orientation == facing || orientation == facing.m_122424_()) {
                builder.put((Object)state, (Object)Shapes.m_83144_());
                continue;
            }
            if (Utils.isY(facing)) {
                builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, orientation, facing == Direction.UP ? shapeBottom : shapeTop));
                continue;
            }
            if (orientation == Direction.UP) {
                shape = shapeUp;
            } else if (orientation == Direction.DOWN) {
                shape = shapeDown;
            } else if (orientation == facing.m_122427_()) {
                shape = shapeLeft;
            } else if (orientation == facing.m_122428_()) {
                shape = shapeRight;
            } else {
                throw new IllegalArgumentException("Invalid orientation for direction!");
            }
            builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, facing, shape));
        }
        return builder.build();
    }

    public static ImmutableMap<BlockState, VoxelShape> generateInnerShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        VoxelShape shapeBottom = Shapes.m_83124_((VoxelShape)FramedSlopedPrismBlock.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)12.0, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedSlopedPrismBlock.m_49796_((double)15.5, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)0.5, (double)16.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)15.5, (double)15.5, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.5, (double)0.0, (double)0.0, (double)4.0, (double)15.5, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.0, (double)0.0, (double)15.5, (double)16.0, (double)16.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.5, (double)0.0, (double)12.0, (double)15.5, (double)15.5, (double)15.5)});
        VoxelShape shapeTop = Shapes.m_83124_((VoxelShape)FramedSlopedPrismBlock.m_49796_((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedSlopedPrismBlock.m_49796_((double)15.5, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)0.5, (double)16.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)12.0, (double)0.5, (double)0.0, (double)15.5, (double)16.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.5, (double)0.5, (double)0.0, (double)4.0, (double)16.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.0, (double)0.0, (double)15.5, (double)16.0, (double)16.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.5, (double)0.5, (double)12.0, (double)15.5, (double)16.0, (double)15.5)});
        VoxelShape shapeRight = Shapes.m_83124_((VoxelShape)FramedSlopedPrismBlock.m_49796_((double)0.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedSlopedPrismBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.5, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.0, (double)15.5, (double)0.0, (double)16.0, (double)16.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.0, (double)0.5, (double)0.5, (double)16.0, (double)4.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.0, (double)12.0, (double)0.5, (double)16.0, (double)15.5, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)0.5, (double)16.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.5, (double)0.5, (double)0.5, (double)4.0, (double)15.5, (double)16.0)});
        VoxelShape shapeLeft = Shapes.m_83124_((VoxelShape)FramedSlopedPrismBlock.m_49796_((double)0.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedSlopedPrismBlock.m_49796_((double)0.0, (double)15.5, (double)0.0, (double)16.0, (double)16.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.5, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.0, (double)12.0, (double)0.5, (double)16.0, (double)15.5, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.0, (double)0.5, (double)0.5, (double)16.0, (double)4.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)15.5, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)12.0, (double)0.5, (double)0.5, (double)15.5, (double)15.5, (double)16.0)});
        VoxelShape shapeUp = Shapes.m_83124_((VoxelShape)FramedSlopedPrismBlock.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedSlopedPrismBlock.m_49796_((double)15.5, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)0.5, (double)16.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)12.0, (double)0.0, (double)0.5, (double)15.5, (double)16.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.5, (double)0.0, (double)0.5, (double)4.0, (double)16.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.5, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.5, (double)0.5, (double)0.5, (double)15.5, (double)4.0, (double)16.0)});
        VoxelShape shapeDown = Shapes.m_83124_((VoxelShape)FramedSlopedPrismBlock.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedSlopedPrismBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)0.5, (double)16.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)15.5, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.5, (double)0.0, (double)0.5, (double)4.0, (double)16.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)12.0, (double)0.0, (double)0.5, (double)15.5, (double)16.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.0, (double)15.5, (double)0.0, (double)16.0, (double)16.0, (double)16.0), FramedSlopedPrismBlock.m_49796_((double)0.5, (double)12.0, (double)0.5, (double)15.5, (double)15.5, (double)16.0)});
        for (BlockState state : states) {
            VoxelShape shape;
            Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
            Direction orientation = (Direction)state.m_61143_((Property)PropertyHolder.ORIENTATION);
            if (orientation.m_122434_() == facing.m_122434_()) {
                builder.put((Object)state, (Object)Shapes.m_83144_());
                continue;
            }
            if (Utils.isY(facing)) {
                builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, orientation.m_122424_(), facing == Direction.UP ? shapeBottom : shapeTop));
                continue;
            }
            if (orientation == Direction.UP) {
                shape = shapeUp;
            } else if (orientation == Direction.DOWN) {
                shape = shapeDown;
            } else if (orientation == facing.m_122427_()) {
                shape = shapeLeft;
            } else if (orientation == facing.m_122428_()) {
                shape = shapeRight;
            } else {
                throw new IllegalArgumentException("Invalid orientation for direction!");
            }
            builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, facing, shape));
        }
        return builder.build();
    }
}

