/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.pillar;

import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.client.model.pillar.FramedPillarModel;

public class FramedHalfPillarModel
extends FramedBlockModel {
    private final Direction face;

    public FramedHalfPillarModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        this.face = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        QuadModifier mod = FramedPillarModel.createPillarQuad(quad, this.face.m_122434_(), 0.25f, 0.75f, 0.75f);
        if (mod.hasFailed()) {
            return;
        }
        Direction quadDir = quad.m_111306_();
        if (quadDir == this.face) {
            mod.export(quadMap.get(this.face));
        } else if (quadDir == this.face.m_122424_()) {
            mod.apply(Modifiers.setPosition(0.5f)).export(quadMap.get(null));
        } else if (Utils.isY(this.face)) {
            mod.apply(Modifiers.cutSideUpDown(this.face == Direction.UP, 0.5f)).export(quadMap.get(null));
        } else if (Utils.isY(quadDir)) {
            mod.apply(Modifiers.cutTopBottom(this.face.m_122424_(), 0.5f)).export(quadMap.get(null));
        } else {
            mod.apply(Modifiers.cutSideLeftRight(this.face.m_122424_(), 0.5f)).export(quadMap.get(null));
        }
    }
}

