/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.mojang.math.Transformation;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.api.util.client.ModelCache;

public final class FluidModel
implements BakedModel {
    private static final ModelState SIMPLE_STATE = new SimpleModelState(Transformation.m_121093_());
    public static final ResourceLocation BARE_MODEL = Utils.rl("fluid/bare");
    private static final Function<ResourceLocation, TextureAtlasSprite> SPRITE_GETTER = loc -> (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(loc);
    private static final Supplier<ResourceLocation> WATER_STILL = Suppliers.memoize(() -> IClientFluidTypeExtensions.of((Fluid)Fluids.f_76193_).getStillTexture());
    private static final Supplier<ResourceLocation> WATER_FLOWING = Suppliers.memoize(() -> IClientFluidTypeExtensions.of((Fluid)Fluids.f_76193_).getFlowingTexture());
    private final RenderType fluidLayer;
    private final ChunkRenderTypeSet fluidLayerSet;
    private final Map<Direction, List<BakedQuad>> quads;
    private final TextureAtlasSprite particles;

    private FluidModel(RenderType fluidLayer, Map<Direction, List<BakedQuad>> quads, TextureAtlasSprite particles) {
        this.fluidLayer = fluidLayer;
        this.fluidLayerSet = ChunkRenderTypeSet.of((RenderType[])new RenderType[]{fluidLayer});
        this.quads = quads;
        this.particles = particles;
    }

    public List<BakedQuad> m_213637_(@Nullable BlockState state, @Nullable Direction side, RandomSource random) {
        return this.getQuads(state, side, random, ModelData.EMPTY, RenderType.m_110466_());
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData extraData, RenderType layer) {
        if (side == null || layer != this.fluidLayer) {
            return Collections.emptyList();
        }
        return this.quads.get(side);
    }

    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        return this.fluidLayerSet;
    }

    public boolean m_7541_() {
        return false;
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7547_() {
        return false;
    }

    public boolean m_7521_() {
        return false;
    }

    public TextureAtlasSprite m_6160_() {
        return this.particles;
    }

    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }

    public static FluidModel create(Fluid fluid) {
        ModelBakery modelBakery = ModelCache.getModelBakery();
        UnbakedModel bareModel = modelBakery.m_119341_(BARE_MODEL);
        Preconditions.checkNotNull((Object)bareModel, (Object)"Bare fluid model not loaded!");
        IClientFluidTypeExtensions props = IClientFluidTypeExtensions.of((Fluid)fluid);
        BakedModel model = bareModel.m_7611_(modelBakery, FluidModel.matToSprite(props), SIMPLE_STATE, Utils.rl("fluid/" + fluid.getFluidType().toString().replace(":", "_")));
        Preconditions.checkNotNull((Object)model, (Object)"Failed to bake fluid model");
        EnumMap<Direction, List<BakedQuad>> quads = new EnumMap<Direction, List<BakedQuad>>(Direction.class);
        BlockState defState = fluid.m_76145_().m_76188_();
        RandomSource random = RandomSource.m_216327_();
        RenderType layer = ItemBlockRenderTypes.m_109287_((FluidState)fluid.m_76145_());
        for (Direction side : Direction.values()) {
            quads.put(side, model.getQuads(defState, side, random, ModelData.EMPTY, layer));
        }
        return new FluidModel(layer, quads, SPRITE_GETTER.apply(props.getStillTexture()));
    }

    private static Function<Material, TextureAtlasSprite> matToSprite(IClientFluidTypeExtensions props) {
        return mat -> {
            if (mat.m_119203_().equals((Object)WATER_FLOWING.get())) {
                return SPRITE_GETTER.apply(props.getFlowingTexture());
            }
            if (mat.m_119203_().equals((Object)WATER_STILL.get())) {
                return SPRITE_GETTER.apply(props.getStillTexture());
            }
            return mat.m_119204_();
        };
    }
}

