/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import xfacthd.framedblocks.api.FramedBlocksAPI;
import xfacthd.framedblocks.api.block.FramedBlockEntity;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.util.Utils;

public interface SideSkipPredicate {
    public static final SideSkipPredicate FALSE = (level, pos, state, adjState, side) -> false;
    public static final SideSkipPredicate CTM = (level, pos, state, adjState, side) -> {
        if (!((IFramedBlock)state.m_60734_()).getCtmPredicate().test(state, side)) {
            return false;
        }
        Block patt763$temp = adjState.m_60734_();
        if (patt763$temp instanceof IFramedBlock) {
            IFramedBlock block = (IFramedBlock)patt763$temp;
            if (!block.getCtmPredicate().test(adjState, side.m_122424_())) {
                return false;
            }
            BlockEntity patt1015$temp = Utils.getBlockEntitySafe(level, pos.m_121945_(side));
            if (patt1015$temp instanceof FramedBlockEntity) {
                FramedBlockEntity be = (FramedBlockEntity)patt1015$temp;
                adjState = be.getCamo(side.m_122424_()).getState();
            }
        }
        return !adjState.m_60795_() && SideSkipPredicate.compareState(level, pos, adjState, side, side);
    };

    public boolean test(BlockGetter var1, BlockPos var2, BlockState var3, BlockState var4, Direction var5);

    public static boolean compareState(BlockGetter level, BlockPos pos, Direction side) {
        return SideSkipPredicate.compareState(level, pos, side, side, side.m_122424_());
    }

    public static boolean compareState(BlockGetter level, BlockPos pos, Direction side, Direction camoSide, Direction adjCamoSide) {
        BlockEntity blockEntity = Utils.getBlockEntitySafe(level, pos.m_121945_(side));
        if (blockEntity instanceof FramedBlockEntity) {
            FramedBlockEntity be = (FramedBlockEntity)blockEntity;
            BlockState adjState = be.getCamo(adjCamoSide).getState();
            return !adjState.m_60795_() && SideSkipPredicate.compareState(level, pos, adjState, side, camoSide);
        }
        return false;
    }

    public static boolean compareState(BlockGetter level, BlockPos pos, BlockState adjState, Direction side, Direction camoSide) {
        BlockEntity blockEntity = Utils.getBlockEntitySafe(level, pos);
        if (blockEntity instanceof FramedBlockEntity) {
            FramedBlockEntity be = (FramedBlockEntity)blockEntity;
            BlockState state = be.getCamo(camoSide).getState();
            return SideSkipPredicate.compareState(level, pos, state, adjState, side);
        }
        return false;
    }

    public static boolean compareState(BlockGetter level, BlockPos pos, Direction side, BlockState testState, Direction adjCamoSide) {
        FramedBlockEntity be;
        BlockState adjCamoState = Blocks.f_50016_.m_49966_();
        BlockEntity blockEntity = Utils.getBlockEntitySafe(level, pos.m_121945_(side));
        if (blockEntity instanceof FramedBlockEntity) {
            be = (FramedBlockEntity)blockEntity;
            adjCamoState = be.getCamo(adjCamoSide).getState();
        }
        if (!adjCamoState.m_60795_() && (blockEntity = Utils.getBlockEntitySafe(level, pos)) instanceof FramedBlockEntity) {
            be = (FramedBlockEntity)blockEntity;
            BlockState camoState = be.getCamo(testState).getState();
            return SideSkipPredicate.compareState(level, pos, camoState, adjCamoState, side);
        }
        return false;
    }

    public static boolean compareState(BlockGetter level, BlockPos pos, Direction side, BlockState testState, BlockState adjTestState) {
        FramedBlockEntity be;
        BlockState adjCamoState = Blocks.f_50016_.m_49966_();
        BlockEntity blockEntity = Utils.getBlockEntitySafe(level, pos.m_121945_(side));
        if (blockEntity instanceof FramedBlockEntity) {
            be = (FramedBlockEntity)blockEntity;
            adjCamoState = be.getCamo(adjTestState).getState();
        }
        if (!adjCamoState.m_60795_() && (blockEntity = Utils.getBlockEntitySafe(level, pos)) instanceof FramedBlockEntity) {
            be = (FramedBlockEntity)blockEntity;
            BlockState camoState = be.getCamo(testState).getState();
            return SideSkipPredicate.compareState(level, pos, camoState, adjCamoState, side);
        }
        return false;
    }

    public static boolean compareState(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        if (state.m_60795_() || adjState.m_60795_()) {
            return false;
        }
        if (state == adjState) {
            return FramedBlocksAPI.getInstance().canCullBlockNextTo(state, adjState);
        }
        return state.m_60804_(level, pos) && adjState.m_60804_(level, pos.m_121945_(side));
    }
}

