/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.forge;

import com.google.common.base.Suppliers;
import com.mojang.brigadier.CommandDispatcher;
import java.util.Arrays;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.BotaniaForgeCapabilities;
import vazkii.botania.api.block.HornHarvestable;
import vazkii.botania.api.block.Wandable;
import vazkii.botania.api.item.AvatarWieldable;
import vazkii.botania.api.item.BlockProvider;
import vazkii.botania.api.item.CoordBoundItem;
import vazkii.botania.api.item.Relic;
import vazkii.botania.api.mana.ManaCollisionGhost;
import vazkii.botania.api.mana.ManaItem;
import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.api.mana.ManaTrigger;
import vazkii.botania.api.mana.spark.SparkAttachable;
import vazkii.botania.client.fx.BotaniaParticles;
import vazkii.botania.common.BotaniaStats;
import vazkii.botania.common.PlayerAccess;
import vazkii.botania.common.advancements.BotaniaCriteriaTriggers;
import vazkii.botania.common.block.BotaniaBannerPatterns;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.block.BotaniaFluffBlocks;
import vazkii.botania.common.block.ForceRelayBlock;
import vazkii.botania.common.block.ManastormChargeBlock;
import vazkii.botania.common.block.block_entity.AlfheimPortalBlockEntity;
import vazkii.botania.common.block.block_entity.AnimatedTorchBlockEntity;
import vazkii.botania.common.block.block_entity.BlockEntityConstants;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.CraftyCrateBlockEntity;
import vazkii.botania.common.block.block_entity.ExposedSimpleInventoryBlockEntity;
import vazkii.botania.common.block.block_entity.ManaEnchanterBlockEntity;
import vazkii.botania.common.block.block_entity.TerrestrialAgglomerationPlateBlockEntity;
import vazkii.botania.common.block.block_entity.corporea.CorporeaIndexBlockEntity;
import vazkii.botania.common.block.block_entity.mana.PowerGeneratorBlockEntity;
import vazkii.botania.common.block.block_entity.red_string.RedStringContainerBlockEntity;
import vazkii.botania.common.block.flower.functional.DaffomillBlockEntity;
import vazkii.botania.common.block.flower.functional.LooniumBlockEntity;
import vazkii.botania.common.block.flower.functional.TigerseyeBlockEntity;
import vazkii.botania.common.block.flower.functional.VinculotusBlockEntity;
import vazkii.botania.common.block.mana.DrumBlock;
import vazkii.botania.common.block.mana.ManaDetectorBlock;
import vazkii.botania.common.block.mana.ManaVoidBlock;
import vazkii.botania.common.block.red_string.RedStringInterceptorBlock;
import vazkii.botania.common.brew.BotaniaBrews;
import vazkii.botania.common.brew.BotaniaMobEffects;
import vazkii.botania.common.brew.effect.SoulCrossMobEffect;
import vazkii.botania.common.command.SkyblockCommand;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.entity.BotaniaEntities;
import vazkii.botania.common.entity.GaiaGuardianEntity;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.handler.CommonTickHandler;
import vazkii.botania.common.handler.ContributorList;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.handler.ExoflameFurnaceHandler;
import vazkii.botania.common.handler.ManaNetworkHandler;
import vazkii.botania.common.handler.OrechidManager;
import vazkii.botania.common.handler.PaintableData;
import vazkii.botania.common.handler.PixieHandler;
import vazkii.botania.common.handler.SleepingHandler;
import vazkii.botania.common.impl.BotaniaAPIImpl;
import vazkii.botania.common.impl.DefaultHornHarvestable;
import vazkii.botania.common.impl.corporea.DefaultCorporeaMatchers;
import vazkii.botania.common.integration.corporea.CorporeaNodeDetectors;
import vazkii.botania.common.item.AssemblyHaloItem;
import vazkii.botania.common.item.BlackHoleTalismanItem;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.EnderHandItem;
import vazkii.botania.common.item.FlowerPouchItem;
import vazkii.botania.common.item.GrassSeedsItem;
import vazkii.botania.common.item.ManaMirrorItem;
import vazkii.botania.common.item.ManaTabletItem;
import vazkii.botania.common.item.ResoluteIvyItem;
import vazkii.botania.common.item.SpellbindingClothItem;
import vazkii.botania.common.item.WandOfTheForestItem;
import vazkii.botania.common.item.equipment.armor.terrasteel.TerrasteelHelmItem;
import vazkii.botania.common.item.equipment.bauble.BandOfManaItem;
import vazkii.botania.common.item.equipment.bauble.BaubleItem;
import vazkii.botania.common.item.equipment.bauble.BenevolentGoddessCharmItem;
import vazkii.botania.common.item.equipment.bauble.CharmOfTheDivaItem;
import vazkii.botania.common.item.equipment.bauble.CloakOfVirtueItem;
import vazkii.botania.common.item.equipment.bauble.FlugelTiaraItem;
import vazkii.botania.common.item.equipment.bauble.GreaterBandOfManaItem;
import vazkii.botania.common.item.equipment.bauble.RingOfMagnetizationItem;
import vazkii.botania.common.item.equipment.bauble.SojournersSashItem;
import vazkii.botania.common.item.equipment.tool.elementium.ElementiumAxeItem;
import vazkii.botania.common.item.equipment.tool.terrasteel.TerraBladeItem;
import vazkii.botania.common.item.equipment.tool.terrasteel.TerraShattererItem;
import vazkii.botania.common.item.equipment.tool.terrasteel.TerraTruncatorItem;
import vazkii.botania.common.item.material.EnderAirItem;
import vazkii.botania.common.item.relic.DiceOfFateItem;
import vazkii.botania.common.item.relic.EyeOfTheFlugelItem;
import vazkii.botania.common.item.relic.FruitOfGrisaiaItem;
import vazkii.botania.common.item.relic.KeyOfTheKingsLawItem;
import vazkii.botania.common.item.relic.RingOfLokiItem;
import vazkii.botania.common.item.relic.RingOfOdinItem;
import vazkii.botania.common.item.relic.RingOfThorItem;
import vazkii.botania.common.item.rod.BifrostRodItem;
import vazkii.botania.common.item.rod.DepthsRodItem;
import vazkii.botania.common.item.rod.HellsRodItem;
import vazkii.botania.common.item.rod.LandsRodItem;
import vazkii.botania.common.item.rod.PlentifulMantleRodItem;
import vazkii.botania.common.item.rod.ShiftingCrustRodItem;
import vazkii.botania.common.item.rod.SkiesRodItem;
import vazkii.botania.common.item.rod.TerraFirmaRodItem;
import vazkii.botania.common.item.rod.UnstableReservoirRodItem;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.common.loot.BotaniaLootModifiers;
import vazkii.botania.common.loot.LootHandler;
import vazkii.botania.common.world.BotaniaFeatures;
import vazkii.botania.common.world.SkyblockChunkGenerator;
import vazkii.botania.common.world.SkyblockWorldEvents;
import vazkii.botania.forge.CapabilityUtil;
import vazkii.botania.forge.ForgeBotaniaConfig;
import vazkii.botania.forge.integration.InventorySorterIntegration;
import vazkii.botania.forge.integration.corporea.ForgeCapCorporeaNodeDetector;
import vazkii.botania.forge.integration.curios.CurioIntegration;
import vazkii.botania.forge.internal_caps.RedStringContainerCapProvider;
import vazkii.botania.forge.network.ForgePacketHandler;
import vazkii.botania.forge.xplat.ForgeXplatImpl;
import vazkii.botania.xplat.XplatAbstractions;
import vazkii.patchouli.api.PatchouliAPI;

@Mod(value="botania")
public class ForgeCommonInitializer {
    private static final Supplier<Map<Item, Function<ItemStack, AvatarWieldable>>> AVATAR_WIELDABLES = Suppliers.memoize(() -> Map.of(BotaniaItems.dirtRod, s -> new LandsRodItem.AvatarBehavior(), BotaniaItems.diviningRod, s -> new PlentifulMantleRodItem.AvatarBehavior(), BotaniaItems.fireRod, s -> new HellsRodItem.AvatarBehavior(), BotaniaItems.missileRod, s -> new UnstableReservoirRodItem.AvatarBehavior(), BotaniaItems.rainbowRod, s -> new BifrostRodItem.AvatarBehavior(), BotaniaItems.tornadoRod, s -> new SkiesRodItem.AvatarBehavior()));
    private static final Supplier<Map<Item, Function<ItemStack, BlockProvider>>> BLOCK_PROVIDER = Suppliers.memoize(() -> Map.of(BotaniaItems.dirtRod, LandsRodItem.BlockProviderImpl::new, BotaniaItems.skyDirtRod, LandsRodItem.BlockProviderImpl::new, BotaniaItems.blackHoleTalisman, BlackHoleTalismanItem.BlockProviderImpl::new, BotaniaItems.cobbleRod, s -> new DepthsRodItem.BlockProviderImpl(), BotaniaItems.enderHand, EnderHandItem.BlockProviderImpl::new, BotaniaItems.terraformRod, s -> new TerraFirmaRodItem.BlockProviderImpl()));
    private static final Supplier<Map<Item, Function<ItemStack, CoordBoundItem>>> COORD_BOUND_ITEM = Suppliers.memoize(() -> Map.of(BotaniaItems.flugelEye, EyeOfTheFlugelItem.CoordBoundItemImpl::new, BotaniaItems.manaMirror, ManaMirrorItem.CoordBoundItemImpl::new, BotaniaItems.twigWand, WandOfTheForestItem.CoordBoundItemImpl::new, BotaniaItems.dreamwoodWand, WandOfTheForestItem.CoordBoundItemImpl::new));
    private static final Supplier<Map<Item, Function<ItemStack, ManaItem>>> MANA_ITEM = Suppliers.memoize(() -> Map.of(BotaniaItems.manaMirror, ManaMirrorItem.ManaItemImpl::new, BotaniaItems.manaRing, BandOfManaItem.ManaItemImpl::new, BotaniaItems.manaRingGreater, GreaterBandOfManaItem.GreaterManaItemImpl::new, BotaniaItems.manaTablet, ManaTabletItem.ManaItemImpl::new, BotaniaItems.terraPick, TerraShattererItem.ManaItemImpl::new));
    private static final Supplier<Map<Item, Function<ItemStack, Relic>>> RELIC = Suppliers.memoize(() -> Map.of(BotaniaItems.dice, DiceOfFateItem::makeRelic, BotaniaItems.flugelEye, EyeOfTheFlugelItem::makeRelic, BotaniaItems.infiniteFruit, FruitOfGrisaiaItem::makeRelic, BotaniaItems.kingKey, KeyOfTheKingsLawItem::makeRelic, BotaniaItems.lokiRing, RingOfLokiItem::makeRelic, BotaniaItems.odinRing, RingOfOdinItem::makeRelic, BotaniaItems.thorRing, RingOfThorItem::makeRelic));

    public ForgeCommonInitializer() {
        this.coreInit();
        this.registryInit();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
    }

    public void commonSetup(FMLCommonSetupEvent evt) {
        ForgePacketHandler.init();
        this.registerEvents();
        evt.enqueueWork(BotaniaBlocks::addDispenserBehaviours);
        BotaniaBlocks.addAxeStripping();
        PaintableData.init();
        DefaultCorporeaMatchers.init();
        PatchouliAPI.get().registerMultiblock(Registry.f_122824_.m_7981_((Object)BotaniaBlocks.alfPortal), AlfheimPortalBlockEntity.MULTIBLOCK.get());
        PatchouliAPI.get().registerMultiblock(Registry.f_122824_.m_7981_((Object)BotaniaBlocks.terraPlate), TerrestrialAgglomerationPlateBlockEntity.MULTIBLOCK.get());
        PatchouliAPI.get().registerMultiblock(Registry.f_122824_.m_7981_((Object)BotaniaBlocks.enchanter), ManaEnchanterBlockEntity.MULTIBLOCK.get());
        PatchouliAPI.get().registerMultiblock(ResourceLocationHelper.prefix("gaia_ritual"), GaiaGuardianEntity.ARENA_MULTIBLOCK.get());
        OrechidManager.registerListener();
        CraftyCrateBlockEntity.registerListener();
        CorporeaNodeDetectors.register(new ForgeCapCorporeaNodeDetector());
        if (ModList.get().isLoaded("inventorysorter")) {
            InventorySorterIntegration.init();
        }
    }

    private void coreInit() {
        ForgeBotaniaConfig.setup();
        EquipmentHandler.init();
    }

    private void registryInit() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        ForgeCommonInitializer.bind(Registry.f_122898_, BotaniaSounds::init);
        ForgeCommonInitializer.bind(Registry.f_122901_, BotaniaBlocks::registerBlocks);
        ForgeCommonInitializer.bind(Registry.f_122904_, BotaniaBlocks::registerItemBlocks);
        ForgeCommonInitializer.bind(Registry.f_122901_, BotaniaFluffBlocks::registerBlocks);
        ForgeCommonInitializer.bind(Registry.f_122904_, BotaniaFluffBlocks::registerItemBlocks);
        ForgeCommonInitializer.bind(Registry.f_122907_, BotaniaBlockEntities::registerTiles);
        ForgeCommonInitializer.bind(Registry.f_122904_, BotaniaItems::registerItems);
        ForgeCommonInitializer.bind(Registry.f_122901_, BotaniaFlowerBlocks::registerBlocks);
        ForgeCommonInitializer.bind(Registry.f_122904_, BotaniaFlowerBlocks::registerItemBlocks);
        ForgeCommonInitializer.bind(Registry.f_122907_, BotaniaFlowerBlocks::registerTEs);
        ForgeCommonInitializer.bind(Registry.f_122913_, BotaniaItems::registerMenuTypes);
        ForgeCommonInitializer.bind(Registry.f_122915_, BotaniaItems::registerRecipeSerializers);
        ForgeCommonInitializer.bind(Registry.f_235735_, BotaniaBannerPatterns::submitRegistrations);
        ForgeCommonInitializer.bind(Registry.f_122914_, BotaniaRecipeTypes::submitRecipeTypes);
        ForgeCommonInitializer.bind(Registry.f_122915_, BotaniaRecipeTypes::submitRecipeSerializers);
        ForgeCommonInitializer.bind(Registry.f_122903_, BotaniaEntities::registerEntities);
        modBus.addListener(e -> BotaniaEntities.registerAttributes((type, builder) -> e.put(type, builder.m_22265_())));
        modBus.addListener(e -> e.add(EntityType.f_20532_, PixieHandler.PIXIE_SPAWN_CHANCE));
        ForgeCommonInitializer.bind(Registry.f_122916_, PixieHandler::registerAttribute);
        ForgeCommonInitializer.bind(Registry.f_122900_, consumer -> {
            BotaniaMobEffects.registerPotions(consumer);
            BotaniaBrews.registerBrews();
        });
        ForgeCommonInitializer.bind(Registry.f_122838_, BotaniaFeatures::registerFeatures);
        ForgeCommonInitializer.bind(Registry.f_122853_, SkyblockChunkGenerator::submitRegistration);
        BotaniaCriteriaTriggers.init();
        ForgeCommonInitializer.bind(Registry.f_122906_, BotaniaParticles::registerParticles);
        ForgeCommonInitializer.bind(Registry.f_122817_, BotaniaLootModifiers::submitLootConditions);
        ForgeCommonInitializer.bind(Registry.f_122816_, BotaniaLootModifiers::submitLootFunctions);
        modBus.addListener(evt -> {
            if (evt.getRegistryKey().equals((Object)Registry.f_122909_)) {
                BotaniaStats.init();
            }
        });
    }

    private static <T> void bind(ResourceKey<Registry<T>> registry, Consumer<BiConsumer<T, ResourceLocation>> source) {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(event -> {
            if (registry.equals((Object)event.getRegistryKey())) {
                source.accept((t, rl) -> event.register(registry, rl, () -> t));
            }
        });
    }

    private void registerEvents() {
        IEventBus bus = MinecraftForge.EVENT_BUS;
        this.registerBlockLookasides();
        bus.addGenericListener(ItemStack.class, this::attachItemCaps);
        bus.addGenericListener(BlockEntity.class, this::attachBeCaps);
        int blazeTime = 2400 * (XplatAbstractions.INSTANCE.gogLoaded() ? 5 : 10);
        bus.addListener(e -> {
            if (e.getItemStack().m_150930_(BotaniaBlocks.blazeBlock.m_5456_())) {
                e.setBurnTime(blazeTime);
            }
        });
        if (XplatAbstractions.INSTANCE.gogLoaded()) {
            bus.addListener(e -> {
                InteractionResult result = SkyblockWorldEvents.onPlayerInteract(e.getEntity(), e.getLevel(), e.getHand(), e.getHitVec());
                if (result == InteractionResult.SUCCESS) {
                    e.setCanceled(true);
                    e.setCancellationResult(InteractionResult.SUCCESS);
                }
            });
        }
        bus.addListener(e -> ((ShiftingCrustRodItem)BotaniaItems.exchangeRod).onLeftClick(e.getEntity(), e.getLevel(), e.getHand(), e.getPos(), e.getFace()));
        bus.addListener(e -> TerraBladeItem.leftClick(e.getItemStack()));
        bus.addListener(e -> TerraBladeItem.attackEntity(e.getEntity(), e.getEntity().f_19853_, InteractionHand.MAIN_HAND, e.getTarget(), null));
        bus.addListener(e -> this.registerCommands((CommandDispatcher<CommandSourceStack>)e.getDispatcher(), e.getCommandSelection() == Commands.CommandSelection.DEDICATED));
        bus.addListener(e -> {
            Player.BedSleepingProblem problem = SleepingHandler.trySleep(e.getEntity(), e.getPos());
            if (problem != null) {
                e.setResult(problem);
            }
        });
        bus.addListener(e -> DaffomillBlockEntity.onItemTrack((Entity)e.getEntity(), (ServerPlayer)e.getEntity()));
        bus.addListener(e -> LootHandler.lootLoad(e.getName(), b -> e.getTable().addPool(b.m_79082_())));
        bus.addListener(e -> ManaNetworkHandler.instance.onNetworkEvent(e.getReceiver(), e.getType(), e.getAction()));
        bus.addListener(e -> {
            if (!e.getLevel().f_46443_) {
                TigerseyeBlockEntity.pacifyAfterLoad(e.getEntity(), (ServerLevel)e.getLevel());
            }
        });
        bus.addListener(e -> this.serverAboutToStart(e.getServer()));
        bus.addListener(e -> this.serverStopping(e.getServer()));
        bus.addListener(e -> FlugelTiaraItem.playerLoggedOut((ServerPlayer)e.getEntity()));
        bus.addListener(e -> ResoluteIvyItem.onPlayerRespawn(e.getOriginal(), e.getEntity(), !e.isWasDeath()));
        bus.addListener(e -> {
            Level patt13777$temp;
            if (e.phase == TickEvent.Phase.END && (patt13777$temp = e.level) instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)patt13777$temp;
                CommonTickHandler.onTick(level);
                GrassSeedsItem.onTickEnd(level);
                TerraTruncatorItem.onTickEnd(level);
            }
        });
        bus.addListener(e -> {
            RedStringInterceptorBlock.onInteract(e.getEntity(), e.getLevel(), e.getHand(), e.getHitVec());
            RingOfLokiItem.onPlayerInteract(e.getEntity(), e.getLevel(), e.getHand(), e.getHitVec());
        });
        bus.addListener(e -> {
            InteractionResultHolder<ItemStack> result = EnderAirItem.onPlayerInteract(e.getEntity(), e.getLevel(), e.getHand());
            if (result.m_19089_().m_19077_()) {
                e.setCanceled(true);
                e.setCancellationResult(result.m_19089_());
            }
        });
        bus.addListener(e -> {
            if (SpellbindingClothItem.shouldDenyAnvil(e.getLeft(), e.getRight())) {
                e.setCanceled(true);
            }
        });
        bus.addListener(e -> {
            BlockState input;
            Block output;
            if (e.getToolAction() == ToolActions.AXE_STRIP && (output = ForgeXplatImpl.CUSTOM_STRIPPABLES.get((input = e.getState()).m_60734_())) != null) {
                e.setFinalState(output.m_152465_(input));
            }
        });
        bus.addListener(e -> {
            EnderMan em;
            Vec3 newPos;
            LivingEntity patt15245$temp = e.getEntityLiving();
            if (patt15245$temp instanceof EnderMan && (newPos = VinculotusBlockEntity.onEndermanTeleport(em = (EnderMan)patt15245$temp, e.getTargetX(), e.getTargetY(), e.getTargetZ())) != null) {
                e.setTargetX(newPos.m_7096_());
                e.setTargetY(newPos.m_7098_());
                e.setTargetZ(newPos.m_7094_());
            }
        });
        bus.addListener(e -> {
            if (BenevolentGoddessCharmItem.shouldProtectExplosion(e.getLevel(), e.getExplosion().getPosition())) {
                e.getExplosion().m_46080_();
            }
        });
        bus.addListener(e -> {
            if (FlowerPouchItem.onPickupItem(e.getItem(), e.getEntity())) {
                e.setCanceled(true);
            }
        });
        bus.addListener(e -> {
            LivingEntity living = e.getEntity();
            ElementiumAxeItem.onEntityDrops(e.isRecentlyHit(), e.getSource(), living, stack -> {
                ItemEntity ent = new ItemEntity(living.f_19853_, living.m_20185_(), living.m_20186_(), living.m_20189_(), stack);
                ent.m_32060_();
                e.getDrops().add(ent);
            });
            LooniumBlockEntity.dropLooniumItems(living, stack -> {
                e.getDrops().clear();
                ItemEntity ent = new ItemEntity(living.f_19853_, living.m_20185_(), living.m_20186_(), living.m_20189_(), stack);
                ent.m_32060_();
                e.getDrops().add(ent);
            });
        });
        bus.addListener(e -> {
            Entity patt16623$temp = e.getSource().m_7639_();
            if (patt16623$temp instanceof LivingEntity) {
                LivingEntity killer = (LivingEntity)patt16623$temp;
                SoulCrossMobEffect.onEntityKill(e.getEntity(), killer);
            }
        });
        bus.addListener(e -> SojournersSashItem.onPlayerJump(e.getEntity()));
        bus.addListener(e -> {
            Player player;
            LivingEntity patt16933$temp = e.getEntity();
            if (patt16933$temp instanceof Player && RingOfOdinItem.onPlayerAttacked(player = (Player)patt16933$temp, e.getSource())) {
                e.setCanceled(true);
            }
        });
        bus.addListener(e -> RingOfMagnetizationItem.onTossItem(e.getPlayer()));
        bus.addListener(e -> {
            Entity patt17669$temp;
            Player player;
            LivingEntity patt17222$temp = e.getEntity();
            if (patt17222$temp instanceof Player) {
                player = (Player)patt17222$temp;
                Container worn = EquipmentHandler.getAllWorn((LivingEntity)player);
                for (int i = 0; i < worn.m_6643_(); ++i) {
                    ItemStack stack = worn.m_8020_(i);
                    Item patt17433$temp = stack.m_41720_();
                    if (!(patt17433$temp instanceof CloakOfVirtueItem)) continue;
                    CloakOfVirtueItem cloak = (CloakOfVirtueItem)patt17433$temp;
                    e.setAmount(cloak.onPlayerDamage(player, e.getSource(), e.getAmount()));
                }
                PixieHandler.onDamageTaken(player, e.getSource());
            }
            if ((patt17669$temp = e.getSource().m_7640_()) instanceof Player) {
                player = (Player)patt17669$temp;
                CharmOfTheDivaItem.onEntityDamaged(player, (Entity)e.getEntity());
            }
        });
        bus.addListener(e -> {
            LivingEntity patt17852$temp = e.getEntity();
            if (patt17852$temp instanceof Player) {
                Player player = (Player)patt17852$temp;
                FlugelTiaraItem.updatePlayerFlyStatus(player);
                SojournersSashItem.tickBelt(player);
            }
        });
        bus.addListener(e -> {
            LivingEntity patt18053$temp = e.getEntity();
            if (patt18053$temp instanceof Player) {
                Player player = (Player)patt18053$temp;
                e.setDistance(SojournersSashItem.onPlayerFall(player, e.getDistance()));
            }
        });
        bus.addListener(EventPriority.LOW, e -> {
            Entity patt18507$temp;
            Event.Result result = e.getResult();
            if (e.getEntity().f_19853_.f_46443_ || result == Event.Result.DENY || result == Event.Result.DEFAULT && !e.isVanillaCritical() || !TerrasteelHelmItem.hasTerraArmorSet(e.getEntity()) || !((patt18507$temp = e.getTarget()) instanceof LivingEntity)) {
                return;
            }
            LivingEntity target = (LivingEntity)patt18507$temp;
            e.setDamageModifier(e.getDamageModifier() * TerrasteelHelmItem.getCritDamageMult(e.getEntity()));
            ((PlayerAccess)e.getEntity()).botania$setCritTarget(target);
        });
        bus.addListener(e -> AssemblyHaloItem.onItemCrafted(e.getEntity(), e.getInventory()));
    }

    private void attachItemCaps(AttachCapabilitiesEvent<ItemStack> e) {
        Function<ItemStack, Relic> makeRelic;
        Function<ItemStack, ManaItem> makeManaItem;
        Function<ItemStack, CoordBoundItem> makeCoordBoundItem;
        Function<ItemStack, BlockProvider> makeBlockProvider;
        Function<ItemStack, AvatarWieldable> makeAvatarWieldable;
        EquipmentHandler equipmentHandler;
        ItemStack stack = (ItemStack)e.getObject();
        if (stack.m_41720_() instanceof BaubleItem && (equipmentHandler = EquipmentHandler.instance) instanceof CurioIntegration) {
            CurioIntegration ci = (CurioIntegration)equipmentHandler;
            e.addCapability(ResourceLocationHelper.prefix("curio"), ci.initCapability(stack));
        }
        if (stack.m_150930_(BotaniaItems.waterBowl)) {
            e.addCapability(ResourceLocationHelper.prefix("water_bowl"), (ICapabilityProvider)new CapabilityUtil.WaterBowlFluidHandler(stack));
        }
        if ((makeAvatarWieldable = AVATAR_WIELDABLES.get().get(stack.m_41720_())) != null) {
            e.addCapability(ResourceLocationHelper.prefix("avatar_wieldable"), CapabilityUtil.makeProvider(BotaniaForgeCapabilities.AVATAR_WIELDABLE, makeAvatarWieldable.apply(stack)));
        }
        if ((makeBlockProvider = BLOCK_PROVIDER.get().get(stack.m_41720_())) != null) {
            e.addCapability(ResourceLocationHelper.prefix("block_provider"), CapabilityUtil.makeProvider(BotaniaForgeCapabilities.BLOCK_PROVIDER, makeBlockProvider.apply(stack)));
        }
        if ((makeCoordBoundItem = COORD_BOUND_ITEM.get().get(stack.m_41720_())) != null) {
            e.addCapability(ResourceLocationHelper.prefix("coord_bound_item"), CapabilityUtil.makeProvider(BotaniaForgeCapabilities.COORD_BOUND_ITEM, makeCoordBoundItem.apply(stack)));
        }
        if ((makeManaItem = MANA_ITEM.get().get(stack.m_41720_())) != null) {
            e.addCapability(ResourceLocationHelper.prefix("mana_item"), CapabilityUtil.makeProvider(BotaniaForgeCapabilities.MANA_ITEM, makeManaItem.apply(stack)));
        }
        if ((makeRelic = RELIC.get().get(stack.m_41720_())) != null) {
            e.addCapability(ResourceLocationHelper.prefix("relic"), CapabilityUtil.makeProvider(BotaniaForgeCapabilities.RELIC, makeRelic.apply(stack)));
        }
    }

    private void registerBlockLookasides() {
        CapabilityUtil.registerBlockLookaside(BotaniaForgeCapabilities.HORN_HARVEST, (w, p, s) -> (world, pos, stack, hornType, living) -> hornType == HornHarvestable.EnumHornType.CANOPY, Blocks.f_50191_, Blocks.f_152538_, Blocks.f_152539_, Blocks.f_50704_, Blocks.f_50653_, Blocks.f_50702_, Blocks.f_50703_);
        CapabilityUtil.registerBlockLookaside(BotaniaForgeCapabilities.HORN_HARVEST, (w, p, s) -> DefaultHornHarvestable.INSTANCE, (Block[])Arrays.stream(DyeColor.values()).map(BotaniaBlocks::getMushroom).toArray(Block[]::new));
        CapabilityUtil.registerBlockLookaside(BotaniaForgeCapabilities.HORN_HARVEST, (w, p, s) -> DefaultHornHarvestable.INSTANCE, (Block[])Arrays.stream(DyeColor.values()).map(BotaniaBlocks::getShinyFlower).toArray(Block[]::new));
        CapabilityUtil.registerBlockLookaside(BotaniaForgeCapabilities.MANA_GHOST, (w, p, s) -> (ManaCollisionGhost)s.m_60734_(), BotaniaBlocks.manaDetector, BotaniaBlocks.abstrusePlatform, BotaniaBlocks.infrangiblePlatform, BotaniaBlocks.spectralPlatform, BotaniaBlocks.prism, BotaniaBlocks.tinyPlanet);
        CapabilityUtil.registerBlockLookaside(BotaniaForgeCapabilities.MANA_RECEIVER, ManaVoidBlock.ManaReceiverImpl::new, BotaniaBlocks.manaVoid);
        CapabilityUtil.registerBlockLookaside(BotaniaForgeCapabilities.MANA_TRIGGER, DrumBlock.ManaTriggerImpl::new, BotaniaBlocks.canopyDrum, BotaniaBlocks.wildDrum, BotaniaBlocks.gatheringDrum);
        CapabilityUtil.registerBlockLookaside(BotaniaForgeCapabilities.MANA_TRIGGER, ManastormChargeBlock.ManaTriggerImpl::new, BotaniaBlocks.manaBomb);
        CapabilityUtil.registerBlockLookaside(BotaniaForgeCapabilities.MANA_TRIGGER, ManaDetectorBlock.ManaTriggerImpl::new, BotaniaBlocks.manaDetector);
        CapabilityUtil.registerBlockLookaside(BotaniaForgeCapabilities.WANDABLE, (world, pos, state) -> (player, stack, side) -> ((ForceRelayBlock)state.m_60734_()).onUsedByWand(player, stack, world, pos), BotaniaBlocks.pistonRelay);
    }

    private void attachBeCaps(AttachCapabilitiesEvent<BlockEntity> e) {
        BlockEntity be = (BlockEntity)e.getObject();
        if (be instanceof AbstractFurnaceBlockEntity) {
            AbstractFurnaceBlockEntity furnace = (AbstractFurnaceBlockEntity)be;
            e.addCapability(ResourceLocationHelper.prefix("exoflame_heatable"), CapabilityUtil.makeProvider(BotaniaForgeCapabilities.EXOFLAME_HEATABLE, new ExoflameFurnaceHandler.FurnaceExoflameHeatable(furnace)));
        }
        if (be instanceof ExposedSimpleInventoryBlockEntity) {
            ExposedSimpleInventoryBlockEntity inv = (ExposedSimpleInventoryBlockEntity)be;
            e.addCapability(ResourceLocationHelper.prefix("inv"), CapabilityUtil.makeProvider(ForgeCapabilities.ITEM_HANDLER, new SidedInvWrapper((WorldlyContainer)inv, null)));
        }
        if (be instanceof PowerGeneratorBlockEntity) {
            final PowerGeneratorBlockEntity gen = (PowerGeneratorBlockEntity)be;
            IEnergyStorage energyStorage = new IEnergyStorage(){

                public int getEnergyStored() {
                    return gen.getEnergy();
                }

                public int getMaxEnergyStored() {
                    return PowerGeneratorBlockEntity.MAX_ENERGY;
                }

                public boolean canExtract() {
                    return false;
                }

                public int extractEnergy(int maxExtract, boolean simulate) {
                    return 0;
                }

                public int receiveEnergy(int maxReceive, boolean simulate) {
                    return 0;
                }

                public boolean canReceive() {
                    return false;
                }
            };
            e.addCapability(ResourceLocationHelper.prefix("fe"), CapabilityUtil.makeProvider(ForgeCapabilities.ENERGY, energyStorage));
        }
        if (be.m_58903_() == BotaniaBlockEntities.ANIMATED_TORCH) {
            e.addCapability(ResourceLocationHelper.prefix("hourglass_trigger"), CapabilityUtil.makeProvider(BotaniaForgeCapabilities.HOURGLASS_TRIGGER, hourglass -> ((AnimatedTorchBlockEntity)be).toggle()));
        }
        if (BlockEntityConstants.SELF_WANDADBLE_BES.contains(be.m_58903_())) {
            e.addCapability(ResourceLocationHelper.prefix("wandable"), CapabilityUtil.makeProvider(BotaniaForgeCapabilities.WANDABLE, (Wandable)be));
        }
        if (be instanceof RedStringContainerBlockEntity) {
            RedStringContainerBlockEntity container = (RedStringContainerBlockEntity)be;
            e.addCapability(ResourceLocationHelper.prefix("red_string"), (ICapabilityProvider)new RedStringContainerCapProvider(container));
        }
        if (BlockEntityConstants.SELF_MANA_TRIGGER_BES.contains(be.m_58903_())) {
            e.addCapability(ResourceLocationHelper.prefix("mana_trigger"), CapabilityUtil.makeProvider(BotaniaForgeCapabilities.MANA_TRIGGER, (ManaTrigger)be));
        }
        if (BlockEntityConstants.SELF_MANA_RECEIVER_BES.contains(be.m_58903_())) {
            e.addCapability(ResourceLocationHelper.prefix("mana_receiver"), CapabilityUtil.makeProvider(BotaniaForgeCapabilities.MANA_RECEIVER, (ManaReceiver)be));
        }
        if (BlockEntityConstants.SELF_SPARK_ATTACHABLE_BES.contains(be.m_58903_())) {
            e.addCapability(ResourceLocationHelper.prefix("spark_attachable"), CapabilityUtil.makeProvider(BotaniaForgeCapabilities.SPARK_ATTACHABLE, (SparkAttachable)be));
        }
    }

    private void serverAboutToStart(MinecraftServer server) {
        if (BotaniaAPI.instance().getClass() != BotaniaAPIImpl.class) {
            String clname = BotaniaAPI.instance().getClass().getName();
            throw new IllegalAccessError("The Botania API has been overriden. This will cause crashes and compatibility issues, and that's why it's marked as \"Do not Override\". Whoever had the brilliant idea of overriding it needs to go back to elementary school and learn to read. (Actual classname: " + clname + ")");
        }
        if (server.m_6982_()) {
            ContributorList.firstStart();
        }
    }

    private void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher, boolean dedicated) {
        if (XplatAbstractions.INSTANCE.gogLoaded()) {
            SkyblockCommand.register(dispatcher);
        }
    }

    private void serverStopping(MinecraftServer server) {
        ManaNetworkHandler.instance.clear();
        CorporeaIndexBlockEntity.clearIndexCache();
    }
}

