/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.models.model.DelegatedModel;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.data.models.model.ModelTemplate;
import net.minecraft.data.models.model.ModelTemplates;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.WallBlock;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.BotaniaDoubleFlowerBlock;
import vazkii.botania.common.block.BotaniaFlowerBlock;
import vazkii.botania.common.block.BotaniaFluffBlocks;
import vazkii.botania.common.block.LuminizerBlock;
import vazkii.botania.common.block.decor.BotaniaMushroomBlock;
import vazkii.botania.common.block.decor.FloatingFlowerBlock;
import vazkii.botania.common.block.decor.FlowerMotifBlock;
import vazkii.botania.common.block.decor.PetalBlock;
import vazkii.botania.common.block.mana.ManaPoolBlock;
import vazkii.botania.common.block.mana.ManaSpreaderBlock;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.lens.LensItem;
import vazkii.botania.common.item.material.MysticalPetalItem;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.data.util.ModelWithOverrides;
import vazkii.botania.data.util.OverrideHolder;
import vazkii.botania.data.util.SimpleModelSupplierWithOverrides;
import vazkii.botania.mixin.TextureSlotAccessor;
import vazkii.botania.xplat.XplatAbstractions;

public class ItemModelProvider
implements DataProvider {
    private static final TextureSlot LAYER1 = TextureSlotAccessor.make("layer1");
    private static final TextureSlot LAYER2 = TextureSlotAccessor.make("layer2");
    private static final TextureSlot LAYER3 = TextureSlotAccessor.make("layer3");
    private static final ModelTemplate GENERATED_1 = new ModelTemplate(Optional.of(new ResourceLocation("item/generated")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125863_, LAYER1});
    private static final ModelTemplate GENERATED_2 = new ModelTemplate(Optional.of(new ResourceLocation("item/generated")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125863_, LAYER1, LAYER2});
    private static final ModelTemplate HANDHELD_1 = new ModelTemplate(Optional.of(new ResourceLocation("item/handheld")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125863_, LAYER1});
    private static final ModelTemplate HANDHELD_3 = new ModelTemplate(Optional.of(new ResourceLocation("item/handheld")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125863_, LAYER1, LAYER2, LAYER3});
    private static final ModelTemplate WALL_INVENTORY = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/wall_inventory")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125872_, TextureSlot.f_125871_, TextureSlot.f_125884_});
    private static final ModelTemplate WALL_INVENTORY_CHECKERED = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/wall_inventory_checkered")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125876_, TextureSlot.f_125875_});
    private static final TextureSlot OUTSIDE = TextureSlotAccessor.make("outside");
    private static final TextureSlot CORE = TextureSlotAccessor.make("core");
    private static final ModelTemplate SPREADER = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/spreader_item")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125875_, TextureSlot.f_125874_, TextureSlot.f_176491_, OUTSIDE, CORE});
    private static final ModelWithOverrides GENERATED_OVERRIDES = new ModelWithOverrides(new ResourceLocation("item/generated"), TextureSlot.f_125863_);
    private static final ModelWithOverrides GENERATED_OVERRIDES_1 = new ModelWithOverrides(new ResourceLocation("item/generated"), TextureSlot.f_125863_, LAYER1);
    private static final ModelWithOverrides HANDHELD_OVERRIDES = new ModelWithOverrides(new ResourceLocation("item/handheld"), TextureSlot.f_125863_);
    private static final ModelWithOverrides HANDHELD_OVERRIDES_2 = new ModelWithOverrides(new ResourceLocation("item/handheld"), TextureSlot.f_125863_, LAYER1, LAYER2);
    private final DataGenerator generator;
    private static final String BUILTIN_ENTITY_DISPLAY_STR = "{\n\t\"gui\": {\n\t\t\"rotation\": [30, 45, 0],\n\t\t\"translation\": [0, 0, 0],\n\t\t\"scale\": [0.625, 0.625, 0.625]\n\t},\n\t\"ground\": {\n\t\t\"rotation\": [0, 0, 0],\n\t\t\"translation\": [0, 3, 0],\n\t\t\"scale\": [0.25, 0.25, 0.25]\n\t},\n\t\"head\": {\n\t\t\"rotation\": [0, 180, 0],\n\t\t\"translation\": [0, 0, 0],\n\t\t\"scale\": [1, 1, 1]\n\t},\n\t\"fixed\": {\n\t\t\"rotation\": [0, 180, 0],\n\t\t\"translation\": [0, 0, 0],\n\t\t\"scale\": [0.5, 0.5, 0.5]\n\t},\n\t\"thirdperson_righthand\": {\n\t\t\"rotation\": [75, 315, 0],\n\t\t\"translation\": [0, 2.5, 0],\n\t\t\"scale\": [0.375, 0.375, 0.375]\n\t},\n\t\"firstperson_righthand\": {\n\t\t\"rotation\": [0, 315, 0],\n\t\t\"translation\": [0, 0, 0],\n\t\t\"scale\": [0.4, 0.4, 0.4]\n\t}\n}";
    private static final JsonElement BUILTIN_ENTITY_DISPLAY = (JsonElement)new Gson().fromJson("{\n\t\"gui\": {\n\t\t\"rotation\": [30, 45, 0],\n\t\t\"translation\": [0, 0, 0],\n\t\t\"scale\": [0.625, 0.625, 0.625]\n\t},\n\t\"ground\": {\n\t\t\"rotation\": [0, 0, 0],\n\t\t\"translation\": [0, 3, 0],\n\t\t\"scale\": [0.25, 0.25, 0.25]\n\t},\n\t\"head\": {\n\t\t\"rotation\": [0, 180, 0],\n\t\t\"translation\": [0, 0, 0],\n\t\t\"scale\": [1, 1, 1]\n\t},\n\t\"fixed\": {\n\t\t\"rotation\": [0, 180, 0],\n\t\t\"translation\": [0, 0, 0],\n\t\t\"scale\": [0.5, 0.5, 0.5]\n\t},\n\t\"thirdperson_righthand\": {\n\t\t\"rotation\": [75, 315, 0],\n\t\t\"translation\": [0, 2.5, 0],\n\t\t\"scale\": [0.375, 0.375, 0.375]\n\t},\n\t\"firstperson_righthand\": {\n\t\t\"rotation\": [0, 315, 0],\n\t\t\"translation\": [0, 0, 0],\n\t\t\"scale\": [0.4, 0.4, 0.4]\n\t}\n}", JsonElement.class);

    public ItemModelProvider(DataGenerator generator) {
        this.generator = generator;
    }

    public void m_213708_(CachedOutput cache) {
        Set<Item> items = Registry.f_122827_.m_123024_().filter(i -> "botania".equals(Registry.f_122827_.m_7981_(i).m_135827_())).collect(Collectors.toSet());
        HashMap map = new HashMap();
        this.registerItemBlocks(ItemModelProvider.takeAll(items, i -> i instanceof BlockItem).stream().map(i -> (BlockItem)i).collect(Collectors.toSet()), map::put);
        ItemModelProvider.registerItemOverrides(items, map::put);
        ItemModelProvider.registerItems(items, map::put);
        for (Map.Entry e : map.entrySet()) {
            ResourceLocation id = (ResourceLocation)e.getKey();
            Path out = this.generator.m_123916_().resolve("assets/" + id.m_135827_() + "/models/" + id.m_135815_() + ".json");
            try {
                DataProvider.m_236072_((CachedOutput)cache, (JsonElement)((JsonElement)((Supplier)e.getValue()).get()), (Path)out);
            }
            catch (IOException ex) {
                BotaniaAPI.LOGGER.error("Failed to generate {}", (Object)out, (Object)ex);
            }
        }
    }

    private static void registerItems(Set<Item> items, BiConsumer<ResourceLocation, Supplier<JsonElement>> consumer) {
        items.remove(BotaniaItems.manaGun);
        ItemModelProvider.takeAll(items, i -> i instanceof LensItem).forEach(i -> {
            ResourceLocation lens = i == BotaniaItems.lensTime || i == BotaniaItems.lensWarp || i == BotaniaItems.lensFire || i == BotaniaItems.lensTripwire ? ResourceLocationHelper.prefix("item/lens_small") : ResourceLocationHelper.prefix("item/lens");
            GENERATED_1.m_125612_(ModelLocationUtils.m_125571_((Item)i), TextureMapping.m_125820_((ResourceLocation)lens).m_125758_(LAYER1, TextureMapping.m_125778_((Item)i)), consumer);
        });
        GENERATED_1.m_125612_(ModelLocationUtils.m_125571_((Item)BotaniaItems.bloodPendant), TextureMapping.m_125820_((ResourceLocation)TextureMapping.m_125778_((Item)BotaniaItems.bloodPendant)).m_125758_(LAYER1, TextureMapping.m_125745_((Item)BotaniaItems.bloodPendant, (String)"_overlay")), consumer);
        items.remove(BotaniaItems.bloodPendant);
        HANDHELD_1.m_125612_(ModelLocationUtils.m_125571_((Item)BotaniaItems.enderDagger), TextureMapping.m_125820_((ResourceLocation)TextureMapping.m_125778_((Item)BotaniaItems.enderDagger)).m_125758_(LAYER1, TextureMapping.m_125745_((Item)BotaniaItems.enderDagger, (String)"_overlay")), consumer);
        items.remove(BotaniaItems.enderDagger);
        GENERATED_1.m_125612_(ModelLocationUtils.m_125571_((Item)BotaniaItems.incenseStick), TextureMapping.m_125820_((ResourceLocation)TextureMapping.m_125778_((Item)BotaniaItems.incenseStick)).m_125758_(LAYER1, TextureMapping.m_125745_((Item)BotaniaItems.incenseStick, (String)"_overlay")), consumer);
        items.remove(BotaniaItems.incenseStick);
        GENERATED_1.m_125612_(ModelLocationUtils.m_125571_((Item)BotaniaItems.manaMirror), TextureMapping.m_125820_((ResourceLocation)TextureMapping.m_125778_((Item)BotaniaItems.manaMirror)).m_125758_(LAYER1, TextureMapping.m_125745_((Item)BotaniaItems.manaMirror, (String)"_overlay")), consumer);
        items.remove(BotaniaItems.manaMirror);
        GENERATED_1.m_125612_(ModelLocationUtils.m_125571_((Item)BotaniaItems.manaTablet), TextureMapping.m_125820_((ResourceLocation)TextureMapping.m_125778_((Item)BotaniaItems.manaTablet)).m_125758_(LAYER1, TextureMapping.m_125745_((Item)BotaniaItems.manaTablet, (String)"_overlay")), consumer);
        items.remove(BotaniaItems.manaTablet);
        GENERATED_2.m_125612_(ModelLocationUtils.m_125571_((Item)BotaniaItems.thirdEye), new TextureMapping().m_125758_(TextureSlot.f_125863_, TextureMapping.m_125745_((Item)BotaniaItems.thirdEye, (String)"_0")).m_125758_(LAYER1, TextureMapping.m_125745_((Item)BotaniaItems.thirdEye, (String)"_1")).m_125758_(LAYER2, TextureMapping.m_125745_((Item)BotaniaItems.thirdEye, (String)"_2")), consumer);
        items.remove(BotaniaItems.thirdEye);
        ItemModelProvider.takeAll(items, BotaniaItems.cobbleRod, BotaniaItems.dirtRod, BotaniaItems.diviningRod, BotaniaItems.elementiumAxe, BotaniaItems.elementiumPick, BotaniaItems.elementiumShovel, BotaniaItems.elementiumHoe, BotaniaItems.elementiumSword, BotaniaItems.exchangeRod, BotaniaItems.fireRod, BotaniaItems.glassPick, BotaniaItems.gravityRod, BotaniaItems.manasteelAxe, BotaniaItems.manasteelPick, BotaniaItems.manasteelShears, BotaniaItems.manasteelShovel, BotaniaItems.manasteelHoe, BotaniaItems.missileRod, BotaniaItems.obedienceStick, BotaniaItems.rainbowRod, BotaniaItems.smeltRod, BotaniaItems.starSword, BotaniaItems.terraSword, BotaniaItems.terraformRod, BotaniaItems.thunderSword, BotaniaItems.waterRod, BotaniaItems.kingKey, BotaniaItems.skyDirtRod).forEach(i -> ModelTemplates.f_125659_.m_125612_(ModelLocationUtils.m_125571_((Item)i), TextureMapping.m_125766_((Item)i), consumer));
        ItemModelProvider.takeAll(items, i -> true).forEach(i -> ModelTemplates.f_125658_.m_125612_(ModelLocationUtils.m_125571_((Item)i), TextureMapping.m_125766_((Item)i), consumer));
    }

    private static void singleGeneratedOverride(Item item, ResourceLocation overrideModel, ResourceLocation predicate, double value, BiConsumer<ResourceLocation, Supplier<JsonElement>> consumer) {
        ModelTemplates.f_125658_.m_125612_(overrideModel, TextureMapping.m_125820_((ResourceLocation)overrideModel), consumer);
        GENERATED_OVERRIDES.create(ModelLocationUtils.m_125571_((Item)item), TextureMapping.m_125766_((Item)item), new OverrideHolder().add(overrideModel, Pair.of((Object)predicate, (Object)value)), consumer);
    }

    private static void singleGeneratedSuffixOverride(Item item, String suffix, ResourceLocation predicate, double value, BiConsumer<ResourceLocation, Supplier<JsonElement>> consumer) {
        ItemModelProvider.singleGeneratedOverride(item, ModelLocationUtils.m_125573_((Item)item, (String)suffix), predicate, value, consumer);
    }

    private static void singleHandheldOverride(Item item, ResourceLocation overrideModel, ResourceLocation predicate, double value, BiConsumer<ResourceLocation, Supplier<JsonElement>> consumer) {
        ModelTemplates.f_125659_.m_125612_(overrideModel, TextureMapping.m_125820_((ResourceLocation)overrideModel), consumer);
        HANDHELD_OVERRIDES.create(ModelLocationUtils.m_125571_((Item)item), TextureMapping.m_125766_((Item)item), new OverrideHolder().add(overrideModel, Pair.of((Object)predicate, (Object)value)), consumer);
    }

    private static void singleHandheldSuffixOverride(Item item, String suffix, ResourceLocation predicate, double value, BiConsumer<ResourceLocation, Supplier<JsonElement>> consumer) {
        ItemModelProvider.singleHandheldOverride(item, ModelLocationUtils.m_125573_((Item)item, (String)suffix), predicate, value, consumer);
    }

    private static void registerItemOverrides(Set<Item> items, BiConsumer<ResourceLocation, Supplier<JsonElement>> consumer) {
        items.remove(BotaniaItems.livingwoodBow);
        items.remove(BotaniaItems.crystalBow);
        ItemModelProvider.singleGeneratedSuffixOverride(BotaniaItems.baubleBox, "_open", ResourceLocationHelper.prefix("open"), 1.0, consumer);
        items.remove(BotaniaItems.baubleBox);
        ItemModelProvider.singleGeneratedSuffixOverride(BotaniaItems.blackHoleTalisman, "_active", ResourceLocationHelper.prefix("active"), 1.0, consumer);
        items.remove(BotaniaItems.blackHoleTalisman);
        OverrideHolder flaskOverrides = new OverrideHolder();
        for (int i = 1; i <= 5; ++i) {
            ResourceLocation overrideModel = ModelLocationUtils.m_125573_((Item)BotaniaItems.brewFlask, (String)("_" + i));
            GENERATED_1.m_125612_(overrideModel, TextureMapping.m_125766_((Item)BotaniaItems.flask).m_125758_(LAYER1, overrideModel), consumer);
            flaskOverrides.add(overrideModel, Pair.of((Object)ResourceLocationHelper.prefix("swigs_taken"), (Object)i));
        }
        GENERATED_OVERRIDES_1.create(ModelLocationUtils.m_125571_((Item)BotaniaItems.brewFlask), TextureMapping.m_125766_((Item)BotaniaItems.flask).m_125758_(LAYER1, TextureMapping.m_125745_((Item)BotaniaItems.brewFlask, (String)"_0")), flaskOverrides, consumer);
        items.remove(BotaniaItems.brewFlask);
        OverrideHolder vialOverrides = new OverrideHolder();
        for (int i = 1; i <= 3; ++i) {
            Item[] overrideModel = ModelLocationUtils.m_125573_((Item)BotaniaItems.brewVial, (String)("_" + i));
            GENERATED_1.m_125612_((ResourceLocation)overrideModel, TextureMapping.m_125766_((Item)BotaniaItems.vial).m_125758_(LAYER1, (ResourceLocation)overrideModel), consumer);
            vialOverrides.add((ResourceLocation)overrideModel, Pair.of((Object)ResourceLocationHelper.prefix("swigs_taken"), (Object)i));
        }
        GENERATED_OVERRIDES_1.create(ModelLocationUtils.m_125571_((Item)BotaniaItems.brewVial), TextureMapping.m_125766_((Item)BotaniaItems.vial).m_125758_(LAYER1, TextureMapping.m_125745_((Item)BotaniaItems.brewVial, (String)"_0")), vialOverrides, consumer);
        items.remove(BotaniaItems.brewVial);
        ItemModelProvider.singleHandheldOverride(BotaniaItems.elementiumShears, ResourceLocationHelper.prefix("item/dammitreddit"), ResourceLocationHelper.prefix("reddit"), 1.0, consumer);
        items.remove(BotaniaItems.elementiumShears);
        ResourceLocation vuvuzela = ResourceLocationHelper.prefix("item/vuvuzela");
        ModelTemplates.f_125659_.m_125612_(vuvuzela, TextureMapping.m_125820_((ResourceLocation)vuvuzela), consumer);
        for (Item i : new Item[]{BotaniaItems.grassHorn, BotaniaItems.leavesHorn, BotaniaItems.snowHorn}) {
            GENERATED_OVERRIDES.create(ModelLocationUtils.m_125571_((Item)i), TextureMapping.m_125766_((Item)i), new OverrideHolder().add(vuvuzela, Pair.of((Object)ResourceLocationHelper.prefix("vuvuzela"), (Object)1.0)), consumer);
        }
        items.remove(BotaniaItems.grassHorn);
        items.remove(BotaniaItems.leavesHorn);
        items.remove(BotaniaItems.snowHorn);
        ItemModelProvider.singleGeneratedOverride(BotaniaItems.infiniteFruit, ResourceLocationHelper.prefix("item/dasboot"), ResourceLocationHelper.prefix("boot"), 1.0, consumer);
        items.remove(BotaniaItems.infiniteFruit);
        ItemModelProvider.singleGeneratedSuffixOverride(BotaniaItems.lexicon, "_elven", ResourceLocationHelper.prefix("elven"), 1.0, consumer);
        items.remove(BotaniaItems.lexicon);
        ItemModelProvider.singleGeneratedSuffixOverride(BotaniaItems.magnetRing, "_active", ResourceLocationHelper.prefix("active"), 1.0, consumer);
        items.remove(BotaniaItems.magnetRing);
        ItemModelProvider.singleGeneratedSuffixOverride(BotaniaItems.magnetRingGreater, "_active", ResourceLocationHelper.prefix("active"), 1.0, consumer);
        items.remove(BotaniaItems.magnetRingGreater);
        OverrideHolder bottleOverrides = new OverrideHolder();
        for (int i = 1; i <= 5; ++i) {
            ResourceLocation overrideModel = ModelLocationUtils.m_125573_((Item)BotaniaItems.manaBottle, (String)("_" + i));
            ModelTemplates.f_125658_.m_125612_(overrideModel, TextureMapping.m_125820_((ResourceLocation)overrideModel), consumer);
            bottleOverrides.add(overrideModel, Pair.of((Object)ResourceLocationHelper.prefix("swigs_taken"), (Object)i));
        }
        GENERATED_OVERRIDES.create(ModelLocationUtils.m_125571_((Item)BotaniaItems.manaBottle), TextureMapping.m_125766_((Item)BotaniaItems.manaBottle), bottleOverrides, consumer);
        items.remove(BotaniaItems.manaBottle);
        ItemModelProvider.singleGeneratedOverride(BotaniaItems.manaCookie, ResourceLocationHelper.prefix("item/totalbiscuit"), ResourceLocationHelper.prefix("totalbiscuit"), 1.0, consumer);
        items.remove(BotaniaItems.manaCookie);
        ItemModelProvider.singleHandheldOverride(BotaniaItems.manasteelSword, ResourceLocationHelper.prefix("item/elucidator"), ResourceLocationHelper.prefix("elucidator"), 1.0, consumer);
        items.remove(BotaniaItems.manasteelSword);
        ItemModelProvider.singleGeneratedSuffixOverride(BotaniaItems.manaweaveHelm, "_holiday", ResourceLocationHelper.prefix("holiday"), 1.0, consumer);
        items.remove(BotaniaItems.manaweaveHelm);
        ItemModelProvider.singleGeneratedSuffixOverride(BotaniaItems.manaweaveChest, "_holiday", ResourceLocationHelper.prefix("holiday"), 1.0, consumer);
        items.remove(BotaniaItems.manaweaveChest);
        ItemModelProvider.singleGeneratedSuffixOverride(BotaniaItems.manaweaveLegs, "_holiday", ResourceLocationHelper.prefix("holiday"), 1.0, consumer);
        items.remove(BotaniaItems.manaweaveLegs);
        ItemModelProvider.singleGeneratedSuffixOverride(BotaniaItems.manaweaveBoots, "_holiday", ResourceLocationHelper.prefix("holiday"), 1.0, consumer);
        items.remove(BotaniaItems.manaweaveBoots);
        ItemModelProvider.singleGeneratedSuffixOverride(BotaniaItems.slimeBottle, "_active", ResourceLocationHelper.prefix("active"), 1.0, consumer);
        items.remove(BotaniaItems.slimeBottle);
        ItemModelProvider.singleGeneratedSuffixOverride(BotaniaItems.spawnerMover, "_full", ResourceLocationHelper.prefix("full"), 1.0, consumer);
        items.remove(BotaniaItems.spawnerMover);
        ItemModelProvider.singleGeneratedSuffixOverride(BotaniaItems.temperanceStone, "_active", ResourceLocationHelper.prefix("active"), 1.0, consumer);
        items.remove(BotaniaItems.temperanceStone);
        ItemModelProvider.singleHandheldSuffixOverride(BotaniaItems.terraAxe, "_active", ResourceLocationHelper.prefix("active"), 1.0, consumer);
        items.remove(BotaniaItems.terraAxe);
        ResourceLocation enabledModel = ModelLocationUtils.m_125573_((Item)BotaniaItems.terraPick, (String)"_active");
        ModelTemplates.f_125659_.m_125612_(enabledModel, TextureMapping.m_125820_((ResourceLocation)enabledModel), consumer);
        ResourceLocation tippedModel = ModelLocationUtils.m_125573_((Item)BotaniaItems.terraPick, (String)"_tipped");
        ModelTemplates.f_125659_.m_125612_(tippedModel, TextureMapping.m_125820_((ResourceLocation)tippedModel), consumer);
        ResourceLocation tippedEnabledModel = ModelLocationUtils.m_125573_((Item)BotaniaItems.terraPick, (String)"_tipped_active");
        ModelTemplates.f_125659_.m_125612_(tippedEnabledModel, TextureMapping.m_125820_((ResourceLocation)tippedEnabledModel), consumer);
        HANDHELD_OVERRIDES.create(ModelLocationUtils.m_125571_((Item)BotaniaItems.terraPick), TextureMapping.m_125766_((Item)BotaniaItems.terraPick), new OverrideHolder().add(enabledModel, Pair.of((Object)ResourceLocationHelper.prefix("active"), (Object)1.0)).add(tippedModel, Pair.of((Object)ResourceLocationHelper.prefix("tipped"), (Object)1.0)).add(tippedEnabledModel, Pair.of((Object)ResourceLocationHelper.prefix("tipped"), (Object)1.0), Pair.of((Object)ResourceLocationHelper.prefix("active"), (Object)1.0)), consumer);
        items.remove(BotaniaItems.terraPick);
        ItemModelProvider.singleHandheldSuffixOverride(BotaniaItems.tornadoRod, "_active", ResourceLocationHelper.prefix("active"), 1.0, consumer);
        items.remove(BotaniaItems.tornadoRod);
        TextureMapping twigWandTextures = TextureMapping.m_125766_((Item)BotaniaItems.twigWand).m_125758_(LAYER1, TextureMapping.m_125745_((Item)BotaniaItems.twigWand, (String)"_top")).m_125758_(LAYER2, TextureMapping.m_125745_((Item)BotaniaItems.twigWand, (String)"_bottom"));
        ResourceLocation twigWandBind = ModelLocationUtils.m_125573_((Item)BotaniaItems.twigWand, (String)"_bind");
        HANDHELD_3.m_125612_(twigWandBind, twigWandTextures.m_125785_(LAYER3, TextureMapping.m_125745_((Item)BotaniaItems.twigWand, (String)"_bind")), consumer);
        HANDHELD_OVERRIDES_2.create(ModelLocationUtils.m_125571_((Item)BotaniaItems.twigWand), twigWandTextures, new OverrideHolder().add(twigWandBind, Pair.of((Object)ResourceLocationHelper.prefix("bindmode"), (Object)1.0)), consumer);
        items.remove(BotaniaItems.twigWand);
        TextureMapping dreamwoodWandTextures = TextureMapping.m_125766_((Item)BotaniaItems.dreamwoodWand).m_125758_(LAYER1, TextureMapping.m_125745_((Item)BotaniaItems.dreamwoodWand, (String)"_top")).m_125758_(LAYER2, TextureMapping.m_125745_((Item)BotaniaItems.dreamwoodWand, (String)"_bottom"));
        ResourceLocation dreamwoodWandBind = ModelLocationUtils.m_125573_((Item)BotaniaItems.dreamwoodWand, (String)"_bind");
        HANDHELD_3.m_125612_(dreamwoodWandBind, dreamwoodWandTextures.m_125785_(LAYER3, TextureMapping.m_125745_((Item)BotaniaItems.dreamwoodWand, (String)"_bind")), consumer);
        HANDHELD_OVERRIDES_2.create(ModelLocationUtils.m_125571_((Item)BotaniaItems.dreamwoodWand), dreamwoodWandTextures, new OverrideHolder().add(dreamwoodWandBind, Pair.of((Object)ResourceLocationHelper.prefix("bindmode"), (Object)1.0)), consumer);
        items.remove(BotaniaItems.dreamwoodWand);
    }

    private void registerItemBlocks(Set<BlockItem> itemBlocks, BiConsumer<ResourceLocation, Supplier<JsonElement>> consumer) {
        itemBlocks.remove(BotaniaBlocks.corporeaCrystalCube.m_5456_());
        itemBlocks.removeIf(i -> {
            ResourceLocation id = Registry.f_122824_.m_7981_((Object)i.m_40614_());
            return id.m_135827_().equals("botania") && i.m_40614_() instanceof FloatingFlowerBlock;
        });
        GENERATED_1.m_125612_(ModelLocationUtils.m_125571_((Item)BotaniaBlocks.animatedTorch.m_5456_()), TextureMapping.m_125738_((Block)Blocks.f_50174_).m_125758_(LAYER1, ResourceLocationHelper.prefix("block/animated_torch_glimmer")), consumer);
        itemBlocks.remove(BotaniaBlocks.animatedTorch.m_5456_());
        ModelTemplates.f_125664_.m_125612_(ModelLocationUtils.m_125571_((Item)BotaniaBlocks.gaiaHead.m_5456_()), new TextureMapping(), consumer);
        itemBlocks.remove(BotaniaBlocks.gaiaHead.m_5456_());
        ItemModelProvider.takeAll(itemBlocks, i -> i.m_40614_() instanceof BotaniaDoubleFlowerBlock).forEach(i -> ModelTemplates.f_125658_.m_125612_(ModelLocationUtils.m_125571_((Item)i), TextureMapping.m_125820_((ResourceLocation)TextureMapping.m_125753_((Block)i.m_40614_(), (String)"_top")), consumer));
        ItemModelProvider.takeAll(itemBlocks, i -> i.m_40614_() instanceof PetalBlock).forEach(i -> consumer.accept(ModelLocationUtils.m_125571_((Item)i), (Supplier<JsonElement>)new DelegatedModel(ResourceLocationHelper.prefix("block/petal_block"))));
        ItemModelProvider.takeAll(itemBlocks, BotaniaBlocks.livingwoodFramed.m_5456_(), BotaniaBlocks.dreamwoodFramed.m_5456_()).forEach(i -> {
            String name = i == BotaniaBlocks.livingwoodFramed.m_5456_() ? "livingwood" : "dreamwood";
            consumer.accept(ModelLocationUtils.m_125571_((Item)i), (Supplier<JsonElement>)new DelegatedModel(ResourceLocationHelper.prefix("block/framed_" + name + "_horizontal_z")));
        });
        consumer.accept(ModelLocationUtils.m_125571_((Item)BotaniaBlocks.livingwoodFramed.m_5456_()), (Supplier<JsonElement>)new DelegatedModel(ResourceLocationHelper.prefix("block/framed_livingwood_horizontal_z")));
        consumer.accept(ModelLocationUtils.m_125571_((Item)BotaniaBlocks.dreamwoodFramed.m_5456_()), (Supplier<JsonElement>)new DelegatedModel(ResourceLocationHelper.prefix("block/framed_dreamwood_horizontal_z")));
        itemBlocks.remove(BotaniaBlocks.livingwoodFramed.m_5456_());
        itemBlocks.remove(BotaniaBlocks.dreamwoodFramed.m_5456_());
        ItemModelProvider.takeAll(itemBlocks, i -> i.m_40614_() instanceof IronBarsBlock).forEach(i -> {
            String name = Registry.f_122827_.m_7981_(i).m_135815_();
            String baseName = name.substring(0, name.length() - "_pane".length());
            ModelTemplates.f_125658_.m_125612_(ModelLocationUtils.m_125571_((Item)i), TextureMapping.m_125820_((ResourceLocation)ResourceLocationHelper.prefix("block/" + baseName)), consumer);
        });
        Predicate<BlockItem> defaultGenerated = i -> {
            Block b = i.m_40614_();
            return XplatAbstractions.INSTANCE.isSpecialFlowerBlock(b) || b instanceof BotaniaMushroomBlock || b instanceof LuminizerBlock || b instanceof BotaniaFlowerBlock || b == BotaniaBlocks.ghostRail;
        };
        ItemModelProvider.takeAll(itemBlocks, defaultGenerated).forEach(i -> ModelTemplates.f_125658_.m_125612_(ModelLocationUtils.m_125571_((Item)i), TextureMapping.m_125738_((Block)i.m_40614_()), consumer));
        ItemModelProvider.takeAll(itemBlocks, b -> b.m_40614_() instanceof FlowerMotifBlock).forEach(i -> {
            String name = Registry.f_122827_.m_7981_(i).m_135815_();
            ResourceLocation texName = ResourceLocationHelper.prefix("block/" + name.replace("_motif", ""));
            ModelTemplates.f_125658_.m_125612_(ModelLocationUtils.m_125571_((Item)i), TextureMapping.m_125820_((ResourceLocation)texName), consumer);
        });
        ItemModelProvider.takeAll(itemBlocks, i -> i.m_40614_() instanceof ManaPoolBlock).forEach(i -> {
            ResourceLocation fullModel = ModelLocationUtils.m_125578_((Block)i.m_40614_(), (String)"_full");
            OverrideHolder overrides = new OverrideHolder().add(fullModel, Pair.of((Object)ResourceLocationHelper.prefix("full"), (Object)1.0));
            consumer.accept(ModelLocationUtils.m_125571_((Item)i), (Supplier<JsonElement>)((Object)new SimpleModelSupplierWithOverrides(ModelLocationUtils.m_125576_((Block)i.m_40614_()), overrides)));
        });
        ItemModelProvider.takeAll(itemBlocks, (BlockItem[])Stream.of(BotaniaFluffBlocks.livingwoodWall, BotaniaFluffBlocks.livingwoodStrippedWall, BotaniaFluffBlocks.dreamwoodWall, BotaniaFluffBlocks.dreamwoodStrippedWall).map(b -> (BlockItem)b.m_5456_()).toArray(BlockItem[]::new)).forEach(i -> {
            String name = Registry.f_122827_.m_7981_(i).m_135815_();
            String baseName = name.substring(0, name.length() - "_wall".length()) + "_log";
            ModelTemplates.f_125714_.m_125612_(ModelLocationUtils.m_125571_((Item)i), new TextureMapping().m_125758_(TextureSlot.f_125884_, ResourceLocationHelper.prefix("block/" + baseName)), consumer);
        });
        ItemModelProvider.takeAll(itemBlocks, i -> i.m_40614_() instanceof WallBlock).forEach(i -> {
            String name = Registry.f_122827_.m_7981_(i).m_135815_();
            String baseName = name.substring(0, name.length() - "_wall".length());
            ModelTemplates.f_125714_.m_125612_(ModelLocationUtils.m_125571_((Item)i), new TextureMapping().m_125758_(TextureSlot.f_125884_, ResourceLocationHelper.prefix("block/" + baseName)), consumer);
        });
        ItemModelProvider.takeAll(itemBlocks, i -> i.m_40614_() instanceof ManaSpreaderBlock).forEach(i -> {
            String name = Registry.f_122827_.m_7981_(i).m_135815_();
            Object outside = i.m_40614_() == BotaniaBlocks.elvenSpreader ? "dreamwood_log_3" : (i.m_40614_() == BotaniaBlocks.gaiaSpreader ? name + "_outside" : "livingwood_log");
            Object inside = i.m_40614_() == BotaniaBlocks.elvenSpreader ? "stripped_dreamwood_log_3" : (i.m_40614_() == BotaniaBlocks.gaiaSpreader ? name + "_inside" : "stripped_livingwood_log");
            SPREADER.m_125612_(ModelLocationUtils.m_125571_((Item)i), new TextureMapping().m_125758_(TextureSlot.f_125875_, TextureMapping.m_125753_((Block)i.m_40614_(), (String)"_side")).m_125758_(OUTSIDE, ResourceLocationHelper.prefix("block/" + (String)outside)).m_125758_(TextureSlot.f_125874_, TextureMapping.m_125753_((Block)i.m_40614_(), (String)"_back")).m_125758_(TextureSlot.f_176491_, ResourceLocationHelper.prefix("block/" + (String)inside)).m_125758_(CORE, TextureMapping.m_125753_((Block)i.m_40614_(), (String)"_core")), consumer);
        });
        ItemModelProvider.takeAll(itemBlocks, BotaniaBlocks.avatar.m_5456_(), BotaniaBlocks.bellows.m_5456_(), BotaniaBlocks.brewery.m_5456_(), BotaniaBlocks.corporeaIndex.m_5456_(), BotaniaBlocks.gaiaPylon.m_5456_(), BotaniaBlocks.hourglass.m_5456_(), BotaniaBlocks.manaPylon.m_5456_(), BotaniaBlocks.naturaPylon.m_5456_(), BotaniaBlocks.teruTeruBozu.m_5456_()).forEach(i -> this.builtinEntity((Item)i, consumer));
        ItemModelProvider.takeAll(itemBlocks, i -> i instanceof MysticalPetalItem).forEach(i -> ModelTemplates.f_125658_.m_125612_(ModelLocationUtils.m_125571_((Item)i), TextureMapping.m_125820_((ResourceLocation)TextureMapping.m_125778_((Item)i)), consumer));
        ModelTemplates.f_125710_.m_125612_(ModelLocationUtils.m_125571_((Item)BotaniaFluffBlocks.dreamwoodFence.m_5456_()), TextureMapping.m_125768_((Block)BotaniaBlocks.dreamwoodPlanks), consumer);
        itemBlocks.remove(BotaniaFluffBlocks.dreamwoodFence.m_5456_());
        ModelTemplates.f_125710_.m_125612_(ModelLocationUtils.m_125571_((Item)BotaniaFluffBlocks.livingwoodFence.m_5456_()), TextureMapping.m_125768_((Block)BotaniaBlocks.livingwoodPlanks), consumer);
        itemBlocks.remove(BotaniaFluffBlocks.livingwoodFence.m_5456_());
        consumer.accept(ModelLocationUtils.m_125571_((Item)BotaniaBlocks.elfGlass.m_5456_()), (Supplier<JsonElement>)new DelegatedModel(ResourceLocationHelper.prefix("block/elf_glass_0")));
        itemBlocks.remove(BotaniaBlocks.elfGlass.m_5456_());
        WALL_INVENTORY.m_125612_(ModelLocationUtils.m_125571_((Item)BotaniaFluffBlocks.biomeBrickPlainsWall.m_5456_()), new TextureMapping().m_125758_(TextureSlot.f_125872_, TextureMapping.m_125753_((Block)BotaniaFluffBlocks.biomeBrickPlains, (String)"_top")).m_125758_(TextureSlot.f_125871_, TextureMapping.m_125753_((Block)BotaniaFluffBlocks.biomeBrickPlains, (String)"_top")).m_125758_(TextureSlot.f_125884_, TextureMapping.m_125740_((Block)BotaniaFluffBlocks.biomeBrickPlains)), consumer);
        itemBlocks.remove(BotaniaFluffBlocks.biomeBrickPlainsWall.m_5456_());
        WALL_INVENTORY_CHECKERED.m_125612_(ModelLocationUtils.m_125571_((Item)BotaniaFluffBlocks.biomeBrickMesaWall.m_5456_()), new TextureMapping().m_125758_(TextureSlot.f_125875_, TextureMapping.m_125740_((Block)BotaniaFluffBlocks.biomeBrickMesa)).m_125758_(TextureSlot.f_125876_, TextureMapping.m_125753_((Block)BotaniaFluffBlocks.biomeBrickMesa, (String)"_mirrored")), consumer);
        itemBlocks.remove(BotaniaFluffBlocks.biomeBrickMesaWall.m_5456_());
        itemBlocks.forEach(i -> consumer.accept(ModelLocationUtils.m_125571_((Item)i), (Supplier<JsonElement>)new DelegatedModel(ModelLocationUtils.m_125576_((Block)i.m_40614_()))));
    }

    protected void builtinEntity(Item i, BiConsumer<ResourceLocation, Supplier<JsonElement>> consumer) {
        consumer.accept(ModelLocationUtils.m_125571_((Item)i), () -> {
            JsonObject json = new JsonObject();
            json.addProperty("parent", "minecraft:builtin/entity");
            json.add("display", BUILTIN_ENTITY_DISPLAY);
            return json;
        });
    }

    @SafeVarargs
    public static <T> Collection<T> takeAll(Set<? extends T> src, T ... items) {
        List<T> ret = Arrays.asList(items);
        for (T item : items) {
            if (src.contains(item)) continue;
            BotaniaAPI.LOGGER.warn("Item {} not found in set", item);
        }
        if (!src.removeAll(ret)) {
            BotaniaAPI.LOGGER.warn("takeAll array didn't yield anything ({})", (Object)Arrays.toString(items));
        }
        return ret;
    }

    public static <T> Collection<T> takeAll(Set<T> src, Predicate<T> pred) {
        ArrayList<T> ret = new ArrayList<T>();
        Iterator<T> iter = src.iterator();
        while (iter.hasNext()) {
            T item = iter.next();
            if (!pred.test(item)) continue;
            iter.remove();
            ret.add(item);
        }
        if (ret.isEmpty()) {
            BotaniaAPI.LOGGER.warn("takeAll predicate yielded nothing", new Throwable());
        }
        return ret;
    }

    @NotNull
    public String m_6055_() {
        return "Botania item models";
    }
}

