/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.loot;

import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import vazkii.botania.common.lib.ResourceLocationHelper;

public final class LootHandler {
    public static void lootLoad(ResourceLocation id, Consumer<LootPool.Builder> addPool) {
        String prefix = "minecraft:chests/";
        String name = id.toString();
        if (name.startsWith(prefix)) {
            String file;
            switch (file = name.substring(name.indexOf(prefix) + prefix.length())) {
                case "abandoned_mineshaft": 
                case "desert_pyramid": 
                case "jungle_temple": 
                case "simple_dungeon": 
                case "spawn_bonus_chest": 
                case "stronghold_corridor": {
                    addPool.accept(LootHandler.getInjectPool(file));
                    break;
                }
                case "village/village_temple": 
                case "village/village_toolsmith": 
                case "village/village_weaponsmith": {
                    addPool.accept(LootHandler.getInjectPool("village_chest"));
                    break;
                }
            }
        }
    }

    private static LootPool.Builder getInjectPool(String entryName) {
        return LootPool.m_79043_().m_79076_(LootHandler.getInjectEntry(entryName, 1)).m_165135_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f));
    }

    private static LootPoolEntryContainer.Builder<?> getInjectEntry(String name, int weight) {
        ResourceLocation table = ResourceLocationHelper.prefix("inject/" + name);
        return LootTableReference.m_79776_((ResourceLocation)table).m_79707_(weight);
    }
}

