/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.helper.MathHelper;
import vazkii.botania.common.item.equipment.bauble.BaubleItem;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.mixin.ItemEntityAccessor;
import vazkii.botania.xplat.BotaniaConfig;
import vazkii.botania.xplat.XplatAbstractions;

public class RingOfMagnetizationItem
extends BaubleItem {
    private static final String TAG_COOLDOWN = "cooldown";
    private final int range;

    public RingOfMagnetizationItem(Item.Properties props) {
        this(props, 6);
    }

    public RingOfMagnetizationItem(Item.Properties props, int range) {
        super(props);
        this.range = range;
    }

    public static void onTossItem(Player player) {
        ItemStack ring = EquipmentHandler.findOrEmpty(s -> s.m_41720_() instanceof RingOfMagnetizationItem, (LivingEntity)player);
        if (!ring.m_41619_()) {
            RingOfMagnetizationItem.setCooldown(ring, 100);
        }
    }

    @Override
    public Multimap<Attribute, AttributeModifier> getEquippedAttributeModifiers(ItemStack stack) {
        if (XplatAbstractions.INSTANCE.isModLoaded("malum")) {
            HashMultimap attributes = HashMultimap.create();
            attributes.put((Object)((Attribute)Registry.f_122866_.m_7745_(new ResourceLocation("malum", "spirit_reach"))), (Object)new AttributeModifier(RingOfMagnetizationItem.getBaubleUUID(stack), "Magnet Ring reach boost", 0.5, AttributeModifier.Operation.MULTIPLY_BASE));
            return attributes;
        }
        return super.getEquippedAttributeModifiers(stack);
    }

    @Override
    public void onWornTick(ItemStack stack, LivingEntity living) {
        super.onWornTick(stack, living);
        if (living.m_5833_()) {
            return;
        }
        int cooldown = RingOfMagnetizationItem.getCooldown(stack);
        if (BotaniaAPI.instance().hasSolegnoliaAround((Entity)living)) {
            if (cooldown < 0) {
                RingOfMagnetizationItem.setCooldown(stack, 2);
            }
            return;
        }
        if (cooldown <= 0) {
            if (living.m_6144_() == BotaniaConfig.common().invertMagnetRing()) {
                double x = living.m_20185_();
                double y = living.m_20186_() + 0.75;
                double z = living.m_20189_();
                int range = ((RingOfMagnetizationItem)stack.m_41720_()).range;
                List items = living.f_19853_.m_45976_(ItemEntity.class, new AABB(x - (double)range, y - (double)range, z - (double)range, x + (double)range, y + (double)range, z + (double)range));
                int pulled = 0;
                for (ItemEntity item : items) {
                    if (!((RingOfMagnetizationItem)stack.m_41720_()).canPullItem(item)) continue;
                    if (pulled <= 200) {
                        MathHelper.setEntityMotionFromVector((Entity)item, new Vec3(x, y, z), 0.45f);
                        if (living.f_19853_.f_46443_) {
                            boolean red = living.f_19853_.f_46441_.m_188499_();
                            float r = red ? 1.0f : 0.0f;
                            float b = red ? 0.0f : 1.0f;
                            SparkleParticleData data = SparkleParticleData.sparkle(1.0f, r, 0.0f, b, 3);
                            living.f_19853_.m_7106_((ParticleOptions)data, item.m_20185_(), item.m_20186_(), item.m_20189_(), 0.0, 0.0, 0.0);
                        }
                        ++pulled;
                        continue;
                    }
                    break;
                }
            }
        } else {
            RingOfMagnetizationItem.setCooldown(stack, cooldown - 1);
        }
    }

    private boolean canPullItem(ItemEntity item) {
        int pickupDelay = ((ItemEntityAccessor)item).getPickupDelay();
        if (!item.m_6084_() || pickupDelay >= 40 || BotaniaAPI.instance().hasSolegnoliaAround((Entity)item) || XplatAbstractions.INSTANCE.preventsRemoteMovement(item)) {
            return false;
        }
        ItemStack stack = item.m_32055_();
        if (stack.m_41619_() || XplatAbstractions.INSTANCE.findManaItem(stack) != null || XplatAbstractions.INSTANCE.findRelic(stack) != null || stack.m_204117_(BotaniaTags.Items.MAGNET_RING_BLACKLIST)) {
            return false;
        }
        BlockPos pos = item.m_20183_();
        if (item.f_19853_.m_8055_(pos).m_204336_(BotaniaTags.Blocks.MAGNET_RING_BLACKLIST)) {
            return false;
        }
        return !item.f_19853_.m_8055_(pos.m_7495_()).m_204336_(BotaniaTags.Blocks.MAGNET_RING_BLACKLIST);
    }

    public static int getCooldown(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_COOLDOWN, 0);
    }

    public static void setCooldown(ItemStack stack, int cooldown) {
        ItemNBTHelper.setInt(stack, TAG_COOLDOWN, cooldown);
    }
}

