/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.NoteBlock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.block_entity.CacophoniumBlockEntity;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.mixin.MobAccessor;

public class CacophoniumItem
extends Item {
    private static final String TAG_SOUND = "sound";
    private static final String TAG_SOUND_NAME = "soundName";

    public CacophoniumItem(Item.Properties props) {
        super(props);
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity entity, InteractionHand hand) {
        if (entity instanceof Mob) {
            Slime slime;
            Mob living = (Mob)entity;
            SoundEvent sound = null;
            sound = living instanceof Creeper ? SoundEvents.f_11837_ : (living instanceof Slime ? ((slime = (Slime)living).m_33633_() ? SoundEvents.f_12470_ : SoundEvents.f_12388_) : ((MobAccessor)living).botania_getAmbientSound());
            if (sound != null) {
                if (!player.f_19853_.f_46443_) {
                    ItemNBTHelper.setString(stack, TAG_SOUND, Registry.f_122821_.m_7981_((Object)sound).toString());
                    ItemNBTHelper.setString(stack, TAG_SOUND_NAME, entity.m_6095_().m_20675_());
                    player.m_21008_(hand, stack);
                }
                return InteractionResult.m_19078_((boolean)player.f_19853_.f_46443_);
            }
        }
        return InteractionResult.PASS;
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext ctx) {
        BlockPos pos;
        Level world;
        Block block;
        ItemStack stack = ctx.m_43722_();
        if (CacophoniumItem.getSound(stack) != null && (block = (world = ctx.m_43725_()).m_8055_(pos = ctx.m_8083_()).m_60734_()) instanceof NoteBlock) {
            if (!world.m_5776_()) {
                world.m_46597_(pos, BotaniaBlocks.cacophonium.m_49966_());
                ((CacophoniumBlockEntity)world.m_7702_((BlockPos)pos)).stack = stack.m_41777_();
                stack.m_41774_(1);
            }
            return InteractionResult.m_19078_((boolean)world.m_5776_());
        }
        return InteractionResult.PASS;
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> list, TooltipFlag flags) {
        if (CacophoniumItem.isDOIT(stack)) {
            list.add((Component)Component.m_237115_((String)"botaniamisc.justDoIt").m_130940_(ChatFormatting.GRAY));
        } else if (CacophoniumItem.getSound(stack) != null) {
            list.add((Component)Component.m_237115_((String)ItemNBTHelper.getString(stack, TAG_SOUND_NAME, "")).m_130940_(ChatFormatting.GRAY));
        }
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (CacophoniumItem.getSound(stack) != null) {
            return ItemUtils.m_150959_((Level)world, (Player)player, (InteractionHand)hand);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public void m_5929_(Level world, @NotNull LivingEntity living, @NotNull ItemStack stack, int count) {
        if (!world.f_46443_ && count % (CacophoniumItem.isDOIT(stack) ? 20 : 6) == 0) {
            CacophoniumItem.playSound(living.f_19853_, stack, living.m_20185_(), living.m_20186_(), living.m_20189_(), living.m_5720_(), 0.9f);
        }
    }

    public static void playSound(Level world, ItemStack stack, double x, double y, double z, SoundSource category, float volume) {
        if (stack.m_41619_()) {
            return;
        }
        SoundEvent sound = CacophoniumItem.getSound(stack);
        if (sound != null) {
            world.m_6263_(null, x, y, z, sound, category, volume, sound == BotaniaSounds.doit ? 1.0f : (world.f_46441_.m_188501_() - world.f_46441_.m_188501_()) * 0.2f + 1.0f);
        }
    }

    @Nullable
    @VisibleForTesting
    public static SoundEvent getSound(ItemStack stack) {
        if (CacophoniumItem.isDOIT(stack)) {
            return BotaniaSounds.doit;
        }
        try {
            return Registry.f_122821_.m_6612_(new ResourceLocation(ItemNBTHelper.getString(stack, TAG_SOUND, ""))).orElse(null);
        }
        catch (ResourceLocationException ex) {
            return null;
        }
    }

    private static boolean isDOIT(ItemStack stack) {
        return !stack.m_41619_() && stack.m_41786_().getString().equalsIgnoreCase("shia labeouf");
    }
}

