/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.block.WandHUD;
import vazkii.botania.api.mana.ManaItem;
import vazkii.botania.api.mana.ManaPool;
import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.api.mana.spark.ManaSpark;
import vazkii.botania.api.mana.spark.SparkAttachable;
import vazkii.botania.api.mana.spark.SparkHelper;
import vazkii.botania.api.mana.spark.SparkUpgradeType;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.entity.BotaniaEntities;
import vazkii.botania.common.entity.SparkBaseEntity;
import vazkii.botania.common.helper.ColorHelper;
import vazkii.botania.common.helper.VecHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.SparkAugmentItem;
import vazkii.botania.common.item.WandOfTheForestItem;
import vazkii.botania.network.EffectType;
import vazkii.botania.network.clientbound.BotaniaEffectPacket;
import vazkii.botania.xplat.XplatAbstractions;

public class ManaSparkEntity
extends SparkBaseEntity
implements ManaSpark {
    private static final int TRANSFER_RATE = 1000;
    private static final String TAG_UPGRADE = "upgrade";
    private static final EntityDataAccessor<Integer> UPGRADE = SynchedEntityData.m_135353_(ManaSparkEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final Set<ManaSpark> transfers = Collections.newSetFromMap(new WeakHashMap());
    private int removeTransferants = 2;

    public ManaSparkEntity(EntityType<ManaSparkEntity> type, Level world) {
        super(type, world);
    }

    public ManaSparkEntity(Level world) {
        this(BotaniaEntities.SPARK, world);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(UPGRADE, (Object)0);
    }

    @NotNull
    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)this.getSparkItem());
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_) {
            return;
        }
        SparkAttachable tile = this.getAttachedTile();
        if (tile == null) {
            this.dropAndKill();
            return;
        }
        ManaReceiver receiver = this.getAttachedManaReceiver();
        SparkUpgradeType upgrade = this.getUpgrade();
        Collection<ManaSpark> transfers = this.getTransfers();
        switch (upgrade) {
            case DISPERSIVE: {
                Player player;
                AABB aabb = VecHelper.boxForRange(this.m_20182_().m_193103_(Direction.Axis.Y, this.m_20186_() + (double)this.m_20206_() / 2.0), 12.0);
                List players = this.f_19853_.m_6443_(Player.class, aabb, EntitySelector.f_20402_);
                HashMap receivingPlayers = new HashMap();
                ItemStack input = new ItemStack((ItemLike)this.getSparkItem());
                Iterator iterator = players.iterator();
                while (iterator.hasNext()) {
                    player = (Player)iterator.next();
                    ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                    stacks.addAll((Collection<ItemStack>)player.m_150109_().f_35974_);
                    stacks.addAll((Collection<ItemStack>)player.m_150109_().f_35975_);
                    Container inv = BotaniaAPI.instance().getAccessoriesInventory(player);
                    for (int i = 0; i < inv.m_6643_(); ++i) {
                        stacks.add(inv.m_8020_(i));
                    }
                    for (ItemStack stack : stacks) {
                        int recv;
                        HashMap<ManaItem, Integer> receivingStacks;
                        ManaItem manaItem = XplatAbstractions.INSTANCE.findManaItem(stack);
                        if (stack.m_41619_() || manaItem == null || !manaItem.canReceiveManaFromItem(input)) continue;
                        boolean add = false;
                        if (!receivingPlayers.containsKey(player)) {
                            add = true;
                            receivingStacks = new HashMap<ManaItem, Integer>();
                        } else {
                            receivingStacks = (HashMap<ManaItem, Integer>)receivingPlayers.get(player);
                        }
                        if ((recv = Math.min(receiver.getCurrentMana(), Math.min(1000, manaItem.getMaxMana() - manaItem.getMana()))) <= 0) continue;
                        receivingStacks.put(manaItem, recv);
                        if (!add) continue;
                        receivingPlayers.put(player, receivingStacks);
                    }
                }
                if (receivingPlayers.isEmpty()) break;
                ArrayList keys = new ArrayList(receivingPlayers.keySet());
                Collections.shuffle(keys);
                player = (Player)keys.iterator().next();
                Map items = (Map)receivingPlayers.get(player);
                Map.Entry e = items.entrySet().iterator().next();
                ManaItem manaItem = (ManaItem)e.getKey();
                int cost = (Integer)e.getValue();
                int manaToPut = Math.min(receiver.getCurrentMana(), cost);
                manaItem.addMana(manaToPut);
                receiver.receiveMana(-manaToPut);
                this.particlesTowards((Entity)player);
                break;
            }
            case DOMINANT: {
                List<ManaSpark> validSparks = SparkHelper.getSparksAround(this.f_19853_, this.m_20185_(), this.m_20186_() + (double)(this.m_20206_() / 2.0f), this.m_20189_(), this.getNetwork());
                validSparks.removeIf(s -> {
                    SparkUpgradeType otherUpgrade = s.getUpgrade();
                    return s == this || otherUpgrade != SparkUpgradeType.NONE || !(s.getAttachedManaReceiver() instanceof ManaPool);
                });
                if (validSparks.isEmpty()) break;
                validSparks.get(this.f_19853_.f_46441_.m_188503_(validSparks.size())).registerTransfer(this);
                break;
            }
            case RECESSIVE: {
                List<ManaSpark> otherSparks = SparkHelper.getSparksAround(this.f_19853_, this.m_20185_(), this.m_20186_() + (double)(this.m_20206_() / 2.0f), this.m_20189_(), this.getNetwork());
                for (ManaSpark otherSpark : otherSparks) {
                    SparkUpgradeType otherUpgrade = otherSpark.getUpgrade();
                    if (otherSpark == this || otherUpgrade == SparkUpgradeType.DOMINANT || otherUpgrade == SparkUpgradeType.RECESSIVE || otherUpgrade == SparkUpgradeType.ISOLATED) continue;
                    transfers.add(otherSpark);
                }
                break;
            }
        }
        if (!transfers.isEmpty()) {
            int manaTotal = Math.min(1000 * transfers.size(), receiver.getCurrentMana());
            int count = transfers.size();
            int manaSpent = 0;
            if (manaTotal > 0) {
                for (ManaSpark spark : transfers) {
                    --count;
                    SparkAttachable attached = spark.getAttachedTile();
                    ManaReceiver attachedReceiver = spark.getAttachedManaReceiver();
                    if (attached == null || attachedReceiver == null || attachedReceiver.isFull() || spark.areIncomingTransfersDone()) continue;
                    int spend = Math.min(attached.getAvailableSpaceForMana(), (manaTotal - manaSpent) / (count + 1));
                    attachedReceiver.receiveMana(spend);
                    manaSpent += spend;
                    this.particlesTowards(spark.entity());
                }
                receiver.receiveMana(-manaSpent);
            }
        }
        if (this.removeTransferants > 0) {
            --this.removeTransferants;
        }
        this.filterTransfers();
    }

    private void particlesTowards(Entity e) {
        XplatAbstractions.INSTANCE.sendToTracking(this, new BotaniaEffectPacket(EffectType.SPARK_MANA_FLOW, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_19879_(), e.m_19879_(), ColorHelper.getColorValue(this.getNetwork())));
    }

    public static void particleBeam(Player player, Entity e1, Entity e2) {
        if (e1 != null && e2 != null && !e1.f_19853_.f_46443_) {
            XplatAbstractions.INSTANCE.sendToPlayer(player, new BotaniaEffectPacket(EffectType.SPARK_NET_INDICATOR, e1.m_20185_(), e1.m_20186_(), e1.m_20189_(), e1.m_19879_(), e2.m_19879_()));
        }
    }

    protected Item getSparkItem() {
        return BotaniaItems.spark;
    }

    private void dropAndKill() {
        SparkUpgradeType upgrade = this.getUpgrade();
        this.m_5552_(new ItemStack((ItemLike)this.getSparkItem()), 0.0f);
        if (upgrade != SparkUpgradeType.NONE) {
            this.m_5552_(SparkAugmentItem.getByType(upgrade), 0.0f);
        }
        this.m_146870_();
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (this.m_6084_() && !stack.m_41619_()) {
            DyeItem dye;
            DyeColor color;
            SparkUpgradeType upgrade = this.getUpgrade();
            if (stack.m_41720_() instanceof WandOfTheForestItem) {
                if (!this.f_19853_.f_46443_) {
                    if (player.m_6144_()) {
                        if (upgrade != SparkUpgradeType.NONE) {
                            this.m_5552_(SparkAugmentItem.getByType(upgrade), 0.0f);
                            this.setUpgrade(SparkUpgradeType.NONE);
                            this.transfers.clear();
                            this.removeTransferants = 2;
                        } else {
                            this.dropAndKill();
                        }
                    } else {
                        SparkHelper.getSparksAround(this.f_19853_, this.m_20185_(), this.m_20186_() + (double)(this.m_20206_() / 2.0f), this.m_20189_(), this.getNetwork()).forEach(s -> ManaSparkEntity.particleBeam(player, this, s.entity()));
                    }
                }
                return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
            }
            Item item = stack.m_41720_();
            if (item instanceof SparkAugmentItem) {
                SparkAugmentItem newUpgrade = (SparkAugmentItem)item;
                if (upgrade == SparkUpgradeType.NONE) {
                    if (!this.f_19853_.f_46443_) {
                        this.setUpgrade(newUpgrade.type);
                        stack.m_41774_(1);
                    }
                    return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
                }
            }
            if (stack.m_150930_(BotaniaItems.phantomInk)) {
                if (!this.f_19853_.f_46443_) {
                    this.m_6842_(true);
                }
                return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
            }
            item = stack.m_41720_();
            if (item instanceof DyeItem && (color = (dye = (DyeItem)item).m_41089_()) != this.getNetwork()) {
                if (!this.f_19853_.f_46443_) {
                    this.setNetwork(color);
                    stack.m_41774_(1);
                }
                return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
            }
        }
        return InteractionResult.PASS;
    }

    @Override
    protected void m_7378_(@NotNull CompoundTag cmp) {
        super.m_7378_(cmp);
        this.setUpgrade(SparkUpgradeType.values()[cmp.m_128451_(TAG_UPGRADE)]);
    }

    @Override
    protected void m_7380_(@NotNull CompoundTag cmp) {
        super.m_7380_(cmp);
        cmp.m_128405_(TAG_UPGRADE, this.getUpgrade().ordinal());
    }

    @Override
    public SparkAttachable getAttachedTile() {
        return XplatAbstractions.INSTANCE.findSparkAttachable(this.f_19853_, this.getAttachPos(), this.f_19853_.m_8055_(this.getAttachPos()), this.f_19853_.m_7702_(this.getAttachPos()), Direction.UP);
    }

    private void filterTransfers() {
        Iterator<ManaSpark> iter = this.transfers.iterator();
        while (iter.hasNext()) {
            ManaSpark spark = iter.next();
            SparkUpgradeType upgr = this.getUpgrade();
            SparkUpgradeType supgr = spark.getUpgrade();
            ManaReceiver arecv = spark.getAttachedManaReceiver();
            if (spark != this && ((Entity)spark).m_6084_() && !spark.areIncomingTransfersDone() && this.getNetwork() == spark.getNetwork() && arecv != null && !arecv.isFull() && (upgr == SparkUpgradeType.NONE && supgr == SparkUpgradeType.DOMINANT || upgr == SparkUpgradeType.RECESSIVE && (supgr == SparkUpgradeType.NONE || supgr == SparkUpgradeType.DISPERSIVE) || !(arecv instanceof ManaPool))) continue;
            iter.remove();
        }
    }

    @Override
    public Collection<ManaSpark> getTransfers() {
        this.filterTransfers();
        return this.transfers;
    }

    private boolean hasTransfer(ManaSpark entity) {
        return this.transfers.contains(entity);
    }

    @Override
    public void registerTransfer(ManaSpark entity) {
        if (this.hasTransfer(entity)) {
            return;
        }
        this.transfers.add(entity);
    }

    @Override
    public SparkUpgradeType getUpgrade() {
        return SparkUpgradeType.values()[(Integer)this.f_19804_.m_135370_(UPGRADE)];
    }

    @Override
    public void setUpgrade(SparkUpgradeType upgrade) {
        this.f_19804_.m_135381_(UPGRADE, (Object)upgrade.ordinal());
    }

    @Override
    public boolean areIncomingTransfersDone() {
        if (this.getAttachedManaReceiver() instanceof ManaPool) {
            return this.removeTransferants > 0;
        }
        SparkAttachable attachable = this.getAttachedTile();
        return attachable != null && attachable.areIncomingTranfersDone();
    }

    public record WandHud(ManaSparkEntity entity) implements WandHUD
    {
        @Override
        public void renderHUD(PoseStack ms, Minecraft mc) {
            ItemStack sparkStack = new ItemStack((ItemLike)this.entity.getSparkItem());
            ItemStack augmentStack = SparkAugmentItem.getByType(this.entity.getUpgrade());
            DyeColor networkColor = this.entity.getNetwork();
            MutableComponent networkColorName = Component.m_237115_((String)("color.minecraft." + networkColor.m_41065_())).m_130940_(ChatFormatting.ITALIC);
            int textColor = ColorHelper.getColorLegibleOnGrayBackground(networkColor);
            int width = 4 + Collections.max(Arrays.asList(mc.f_91062_.m_92852_((FormattedText)networkColorName), RenderHelper.itemWithNameWidth(mc, sparkStack), RenderHelper.itemWithNameWidth(mc, augmentStack)));
            int height = augmentStack.m_41619_() ? 30 : 50;
            int networkColorTextStart = mc.f_91062_.m_92852_((FormattedText)networkColorName) / 2;
            int centerX = mc.m_91268_().m_85445_() / 2;
            int centerY = mc.m_91268_().m_85446_() / 2;
            RenderHelper.renderHUDBox(ms, centerX - width / 2, centerY + 8, centerX + width / 2, centerY + 8 + height);
            RenderHelper.renderItemWithNameCentered(ms, mc, sparkStack, centerY + 10, textColor);
            RenderHelper.renderItemWithNameCentered(ms, mc, augmentStack, centerY + 28, textColor);
            mc.f_91062_.m_92763_(ms, (Component)networkColorName, (float)(centerX - networkColorTextStart), (float)(centerY + (augmentStack.m_41619_() ? 28 : 46)), textColor);
        }
    }
}

