/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.decor;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.block.FloatingFlower;
import vazkii.botania.api.block.FloatingFlowerProvider;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.block.BotaniaWaterloggedBlock;
import vazkii.botania.common.block.block_entity.FloatingFlowerBlockEntity;
import vazkii.botania.common.item.FloatingFlowerVariant;
import vazkii.botania.common.item.material.MysticalPetalItem;
import vazkii.botania.xplat.BotaniaConfig;
import vazkii.botania.xplat.XplatAbstractions;

public class FloatingFlowerBlock
extends BotaniaWaterloggedBlock
implements EntityBlock {
    private static final VoxelShape SHAPE = FloatingFlowerBlock.m_49796_((double)1.6, (double)1.6, (double)1.6, (double)14.4, (double)14.4, (double)14.4);
    public final DyeColor color;

    public FloatingFlowerBlock(DyeColor color, BlockBehaviour.Properties props) {
        super(props);
        this.color = color;
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    @NotNull
    public RenderShape m_7514_(BlockState state) {
        if (!XplatAbstractions.INSTANCE.isPhysicalClient()) {
            return RenderShape.ENTITYBLOCK_ANIMATED;
        }
        return BotaniaConfig.client().staticFloaters() ? RenderShape.MODEL : RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource rand) {
        int hex = MysticalPetalItem.getPetalLikeColor(this.color);
        int r = (hex & 0xFF0000) >> 16;
        int g = (hex & 0xFF00) >> 8;
        int b = hex & 0xFF;
        if (rand.m_188500_() < BotaniaConfig.client().flowerParticleFrequency()) {
            SparkleParticleData data = SparkleParticleData.sparkle(rand.m_188501_(), (float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, 5);
            world.m_7106_((ParticleOptions)data, (double)pos.m_123341_() + 0.3 + (double)rand.m_188501_() * 0.5, (double)pos.m_123342_() + 0.5 + (double)rand.m_188501_() * 0.5, (double)pos.m_123343_() + 0.3 + (double)rand.m_188501_() * 0.5, 0.0, 0.0, 0.0);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        FloatingFlowerProvider provider;
        ItemStack stack = player.m_21120_(hand);
        BlockEntity te = world.m_7702_(pos);
        if (!stack.m_41619_() && te instanceof FloatingFlowerProvider && (provider = (FloatingFlowerProvider)te).getFloatingData() != null) {
            FloatingFlower flower = provider.getFloatingData();
            FloatingFlower.IslandType type = null;
            if (stack.m_150930_(Items.f_42452_)) {
                type = FloatingFlower.IslandType.SNOW;
            } else {
                FloatingFlowerVariant floatingFlower;
                FloatingFlower.IslandType newType;
                Item item = stack.m_41720_();
                if (item instanceof FloatingFlowerVariant && (newType = (floatingFlower = (FloatingFlowerVariant)item).getIslandType(stack)) != null) {
                    type = newType;
                }
            }
            if (type != null && type != flower.getIslandType()) {
                if (!world.f_46443_) {
                    flower.setIslandType(type);
                    VanillaPacketDispatcher.dispatchTEToNearbyPlayers(te);
                }
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
                return InteractionResult.m_19078_((boolean)world.m_5776_());
            }
        }
        return InteractionResult.PASS;
    }

    @NotNull
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new FloatingFlowerBlockEntity(pos, state);
    }
}

