/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.block_entity.mana;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block.WandHUD;
import vazkii.botania.api.block.Wandable;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntity;
import vazkii.botania.common.block.block_entity.mana.ManaSpreaderBlockEntity;

public class SpreaderTurntableBlockEntity
extends BotaniaBlockEntity
implements Wandable {
    private static final String TAG_SPEED = "speed";
    private static final String TAG_BACKWARDS = "backwards";
    private int speed = 1;
    private boolean backwards = false;

    public SpreaderTurntableBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaBlockEntities.TURNTABLE, pos, state);
    }

    public static void commonTick(Level level, BlockPos worldPosition, BlockState state, SpreaderTurntableBlockEntity self) {
        BlockEntity tile;
        if (!level.m_46753_(worldPosition) && (tile = level.m_7702_(worldPosition.m_7494_())) instanceof ManaSpreaderBlockEntity) {
            ManaSpreaderBlockEntity spreader = (ManaSpreaderBlockEntity)tile;
            spreader.rotationX = spreader.rotationX + (float)(self.speed * (self.backwards ? -1 : 1));
            if (spreader.rotationX >= 360.0f) {
                spreader.rotationX -= 360.0f;
            }
            if (!level.f_46443_) {
                spreader.checkForReceiver();
            }
        }
    }

    @Override
    public void writePacketNBT(CompoundTag cmp) {
        cmp.m_128405_(TAG_SPEED, this.speed);
        cmp.m_128379_(TAG_BACKWARDS, this.backwards);
    }

    @Override
    public void readPacketNBT(CompoundTag cmp) {
        this.speed = cmp.m_128451_(TAG_SPEED);
        this.backwards = cmp.m_128471_(TAG_BACKWARDS);
    }

    @Override
    public boolean onUsedByWand(@Nullable Player player, ItemStack wand, Direction side) {
        if (player != null && player.m_6144_() || player == null && side == Direction.DOWN) {
            this.backwards = !this.backwards;
        } else {
            this.speed = this.speed == 6 ? 1 : this.speed + 1;
        }
        VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
        return true;
    }

    public static class WandHud
    implements WandHUD {
        private final SpreaderTurntableBlockEntity turntable;

        public WandHud(SpreaderTurntableBlockEntity turntable) {
            this.turntable = turntable;
        }

        @Override
        public void renderHUD(PoseStack ms, Minecraft mc) {
            char motion = this.turntable.backwards ? (char)'<' : '>';
            String speed = "" + ChatFormatting.BOLD;
            for (int i = 0; i < this.turntable.speed; ++i) {
                speed = speed + motion;
            }
            int strWidth = mc.f_91062_.m_92895_(speed);
            int x = (mc.m_91268_().m_85445_() - strWidth) / 2;
            int y = mc.m_91268_().m_85446_() / 2 + 8;
            RenderHelper.renderHUDBox(ms, x - 2, y, x + strWidth + 2, y + 12);
            mc.f_91062_.m_92750_(ms, speed, (float)x, (float)(y + 2), ChatFormatting.WHITE.m_126665_().intValue());
        }
    }
}

