/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.gui.bag;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.client.gui.SlotLocked;
import vazkii.botania.common.block.BotaniaDoubleFlowerBlock;
import vazkii.botania.common.block.BotaniaFlowerBlock;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.FlowerPouchItem;

public class FlowerPouchContainer
extends AbstractContainerMenu {
    private final ItemStack bag;
    public final Container flowerBagInv;

    public static FlowerPouchContainer fromNetwork(int windowId, Inventory inv, FriendlyByteBuf buf) {
        InteractionHand hand = buf.readBoolean() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        return new FlowerPouchContainer(windowId, inv, inv.f_35978_.m_21120_(hand));
    }

    public FlowerPouchContainer(int windowId, Inventory playerInv, ItemStack bag) {
        super(BotaniaItems.FLOWER_BAG_CONTAINER, windowId);
        int col;
        int row;
        this.bag = bag;
        this.flowerBagInv = !playerInv.f_35978_.f_19853_.f_46443_ ? FlowerPouchItem.getInventory(bag) : new SimpleContainer(FlowerPouchItem.SIZE);
        for (row = 0; row < 4; ++row) {
            for (col = 0; col < 8; ++col) {
                final int slot = col + row * 8;
                this.m_38897_(new Slot(this.flowerBagInv, slot, 17 + col * 18, 26 + row * 18){

                    public boolean m_5857_(@NotNull ItemStack stack) {
                        return stack.m_150930_(FlowerPouchItem.getFlowerForSlot(slot));
                    }
                });
            }
        }
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInv, col + row * 9 + 9, 8 + col * 18, 120 + row * 18));
            }
        }
        for (int i = 0; i < 9; ++i) {
            if (playerInv.m_8020_(i) == bag) {
                this.m_38897_(new SlotLocked((Container)playerInv, i, 8 + i * 18, 178));
                continue;
            }
            this.m_38897_(new Slot((Container)playerInv, i, 8 + i * 18, 178));
        }
    }

    public boolean m_6875_(@NotNull Player player) {
        ItemStack main = player.m_21205_();
        ItemStack off = player.m_21206_();
        return !main.m_41619_() && main == this.bag || !off.m_41619_() && off == this.bag;
    }

    @NotNull
    public ItemStack m_7648_(Player player, int slotIndex) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(slotIndex);
        if (slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (slotIndex < 32) {
                if (!this.m_38903_(itemstack1, 32, 68, true)) {
                    return ItemStack.f_41583_;
                }
            } else {
                Slot destination;
                Block b = Block.m_49814_((Item)itemstack.m_41720_());
                int slotId = -1;
                if (b instanceof BotaniaDoubleFlowerBlock) {
                    BotaniaDoubleFlowerBlock flower = (BotaniaDoubleFlowerBlock)b;
                    slotId = 16 + flower.color.m_41060_();
                } else if (b instanceof BotaniaFlowerBlock) {
                    BotaniaFlowerBlock flower = (BotaniaFlowerBlock)b;
                    slotId = flower.color.m_41060_();
                }
                if (slotId >= 0 && slotId < 32 && (destination = (Slot)this.f_38839_.get(slotId)).m_5857_(itemstack) && !this.m_38903_(itemstack1, slotId, slotId + 1, true)) {
                    return ItemStack.f_41583_;
                }
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, itemstack1);
        }
        return itemstack;
    }
}

