/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.network;

import com.github.klikli_dev.occultism.api.common.blockentity.IStorageController;
import com.github.klikli_dev.occultism.api.common.container.IStorageControllerContainer;
import com.github.klikli_dev.occultism.network.MessageBase;
import com.github.klikli_dev.occultism.network.MessageUpdateMouseHeldItem;
import com.github.klikli_dev.occultism.network.OccultismPackets;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.network.NetworkEvent;

public class MessageInsertMouseHeldItem
extends MessageBase {
    private int mouseButton;

    public MessageInsertMouseHeldItem(FriendlyByteBuf buf) {
        this.decode(buf);
    }

    public MessageInsertMouseHeldItem(int mouseButton) {
        this.mouseButton = mouseButton;
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayer player, NetworkEvent.Context context) {
        if (player.f_36096_ instanceof IStorageControllerContainer) {
            IStorageController storageController = ((IStorageControllerContainer)player.f_36096_).getStorageController();
            ItemStack result = ItemStack.f_41583_;
            ItemStack carriedByMouse = player.f_36096_.m_142621_();
            if (this.mouseButton == 0) {
                int remainder = storageController.insertStack(carriedByMouse, false);
                if (remainder != 0) {
                    result = ItemHandlerHelper.copyStackWithSize((ItemStack)carriedByMouse, (int)remainder);
                }
            } else if (this.mouseButton == 1) {
                ItemStack toInsert = carriedByMouse.m_41777_();
                toInsert.m_41764_(1);
                carriedByMouse.m_41774_(1);
                int remainder = storageController.insertStack(toInsert, false) + carriedByMouse.m_41613_();
                if (remainder != 0) {
                    result = ItemHandlerHelper.copyStackWithSize((ItemStack)carriedByMouse, (int)remainder);
                }
            }
            player.f_36096_.m_142503_(result);
            OccultismPackets.sendTo(player, new MessageUpdateMouseHeldItem(result));
            OccultismPackets.sendTo(player, storageController.getMessageUpdateStacks());
            player.f_36096_.m_38946_();
        }
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.mouseButton);
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.mouseButton = buf.readInt();
    }
}

