/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.integration.jei;

import com.github.klikli_dev.occultism.common.container.storage.StableWormholeContainer;
import com.github.klikli_dev.occultism.common.container.storage.StorageControllerContainer;
import com.github.klikli_dev.occultism.common.container.storage.StorageRemoteContainer;
import com.github.klikli_dev.occultism.integration.jei.JeiRecipeTypes;
import com.github.klikli_dev.occultism.integration.jei.JeiSettings;
import com.github.klikli_dev.occultism.integration.jei.StorageControllerRecipeTransferHandler;
import com.github.klikli_dev.occultism.integration.jei.recipes.CrushingRecipeCategory;
import com.github.klikli_dev.occultism.integration.jei.recipes.MinerRecipeCategory;
import com.github.klikli_dev.occultism.integration.jei.recipes.RitualRecipeCategory;
import com.github.klikli_dev.occultism.integration.jei.recipes.SpiritFireRecipeCategory;
import com.github.klikli_dev.occultism.registry.OccultismBlocks;
import com.github.klikli_dev.occultism.registry.OccultismItems;
import com.github.klikli_dev.occultism.registry.OccultismRecipes;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IStackHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

@mezz.jei.api.JeiPlugin
public class JeiPlugin
implements IModPlugin {
    protected static IJeiRuntime runtime;

    public static IJeiRuntime getJeiRuntime() {
        return runtime;
    }

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("occultism", "jei");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new SpiritFireRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new CrushingRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new MinerRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new RitualRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        RecipeManager recipeManager = level.m_7465_();
        List spiritFireRecipes = recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)OccultismRecipes.SPIRIT_FIRE_TYPE.get());
        registration.addRecipes(JeiRecipeTypes.SPIRIT_FIRE, spiritFireRecipes);
        List crushingRecipes = recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)OccultismRecipes.CRUSHING_TYPE.get());
        registration.addRecipes(JeiRecipeTypes.CRUSHING, crushingRecipes);
        List minerRecipes = recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)OccultismRecipes.MINER_TYPE.get());
        registration.addRecipes(JeiRecipeTypes.MINER, minerRecipes);
        List ritualRecipes = recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)OccultismRecipes.RITUAL_TYPE.get());
        registration.addRecipes(JeiRecipeTypes.RITUAL, ritualRecipes);
        this.registerIngredientInfo(registration, (ItemLike)OccultismItems.TALLOW.get());
        this.registerIngredientInfo(registration, (ItemLike)OccultismBlocks.OTHERSTONE.get());
        this.registerIngredientInfo(registration, (ItemLike)OccultismBlocks.OTHERWORLD_LOG.get());
        this.registerIngredientInfo(registration, (ItemLike)OccultismBlocks.OTHERWORLD_LEAVES.get());
        this.registerIngredientInfo(registration, (ItemLike)OccultismBlocks.OTHERWORLD_SAPLING.get());
        this.registerIngredientInfo(registration, (ItemLike)OccultismBlocks.OTHERWORLD_SAPLING_NATURAL.get());
        this.registerIngredientInfo(registration, (ItemLike)OccultismBlocks.IESNIUM_ORE.get());
        this.registerIngredientInfo(registration, (ItemLike)OccultismBlocks.SPIRIT_FIRE.get());
        this.registerIngredientInfo(registration, (ItemLike)OccultismItems.DATURA.get());
        this.registerIngredientInfo(registration, (ItemLike)OccultismItems.SPAWN_EGG_GOAT_FAMILIAR.get());
        this.registerIngredientInfo(registration, (ItemLike)OccultismItems.SPAWN_EGG_SHUB_NIGGURATH_FAMILIAR.get());
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        IStackHelper stackHelper = registration.getJeiHelpers().getStackHelper();
        IRecipeTransferHandlerHelper handlerHelper = registration.getTransferHelper();
        registration.addUniversalRecipeTransferHandler(new StorageControllerRecipeTransferHandler<StorageControllerContainer>(StorageControllerContainer.class, handlerHelper));
        registration.addUniversalRecipeTransferHandler(new StorageControllerRecipeTransferHandler<StorageRemoteContainer>(StorageRemoteContainer.class, handlerHelper));
        registration.addUniversalRecipeTransferHandler(new StorageControllerRecipeTransferHandler<StableWormholeContainer>(StableWormholeContainer.class, handlerHelper));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)OccultismBlocks.SPIRIT_FIRE.get()), new RecipeType[]{JeiRecipeTypes.SPIRIT_FIRE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)OccultismBlocks.DIMENSIONAL_MINESHAFT.get()), new RecipeType[]{JeiRecipeTypes.MINER});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)OccultismBlocks.GOLDEN_SACRIFICIAL_BOWL.get()), new RecipeType[]{JeiRecipeTypes.RITUAL});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation("occultism", "ritual_dummy/summon_marid_crusher"))), new RecipeType[]{JeiRecipeTypes.CRUSHING});
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        runtime = jeiRuntime;
        JeiSettings.setJeiLoaded(true);
    }

    public void registerIngredientInfo(IRecipeRegistration registration, ItemLike ingredient) {
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ingredient.m_5456_()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)("jei.occultism.ingredient." + ForgeRegistries.ITEMS.getKey((Object)ingredient.m_5456_()).m_135815_().replace("/", ".") + ".description"))});
    }
}

