/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.datagen;

import com.github.klikli_dev.occultism.Occultism;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.function.Consumer;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;

public class MinerRecipeProvider
implements DataProvider {
    protected final DataGenerator.PathProvider recipePathProvider;

    public MinerRecipeProvider(DataGenerator generator) {
        this.recipePathProvider = generator.m_236036_(DataGenerator.Target.DATA_PACK, "recipes/miner");
    }

    private static void saveRecipe(CachedOutput pOutput, JsonObject pRecipeJson, Path pPath) {
        try {
            DataProvider.m_236072_((CachedOutput)pOutput, (JsonElement)pRecipeJson, (Path)pPath);
        }
        catch (IOException ioexception) {
            Occultism.LOGGER.error("Couldn't save recipe {}", (Object)pPath, (Object)ioexception);
        }
    }

    public void m_213708_(CachedOutput pOutput) throws IOException {
        HashSet set = Sets.newHashSet();
        this.buildRecipes(recipe -> {
            if (!set.add((ResourceLocation)recipe.getFirst())) {
                throw new IllegalStateException("Duplicate recipe " + recipe.getFirst());
            }
            MinerRecipeProvider.saveRecipe(pOutput, (JsonObject)recipe.getSecond(), this.recipePathProvider.m_236048_((ResourceLocation)recipe.getFirst()));
        });
    }

    protected ResourceLocation modLoc(String path) {
        return new ResourceLocation("occultism", path);
    }

    protected ResourceLocation loc(String namespace, String path) {
        return new ResourceLocation(namespace, path);
    }

    protected void buildRecipes(Consumer<Pair<ResourceLocation, JsonObject>> recipes) {
        this.buildForbiddenArcanusRecipes(recipes);
    }

    protected void buildForbiddenArcanusRecipes(Consumer<Pair<ResourceLocation, JsonObject>> recipes) {
        recipes.accept(this.buildMinerRecipe(this.modLoc("deeps/deepslate_arcane_crystal"), this.modLoc("miners/deeps"), this.loc("forge", "ores/arcane_crystal"), 200));
        recipes.accept(this.buildMinerRecipe(this.modLoc("master/stella_arcanum"), this.modLoc("miners/master"), this.loc("forge", "ores/stella_arcanum"), 100));
        recipes.accept(this.buildMinerRecipe(this.modLoc("ores/arcane_crystal"), this.modLoc("miners/ores"), this.loc("forge", "ores/arcane_crystal"), 200));
        recipes.accept(this.buildMinerRecipe(this.modLoc("ores/xpetrified"), this.modLoc("miners/ores"), this.loc("forge", "ores/xpetrified_ore"), 200));
    }

    protected Pair<ResourceLocation, JsonObject> buildMinerRecipe(ResourceLocation name, ResourceLocation minerTag, ResourceLocation outputTag, int weight) {
        JsonObject recipe = this.buildMinerRecipeJson(minerTag.toString(), outputTag.toString(), weight);
        return new Pair((Object)name, (Object)recipe);
    }

    public JsonObject buildMinerRecipeJson(String minerTag, String outputTag, int weight) {
        JsonObject recipe = new JsonObject();
        recipe.addProperty("type", "occultism:miner");
        JsonArray conditions = this.buildMinerRecipeConditionJson(outputTag);
        recipe.add("conditions", (JsonElement)conditions);
        JsonObject ingredient = new JsonObject();
        ingredient.addProperty("tag", minerTag);
        recipe.add("ingredient", (JsonElement)ingredient);
        JsonObject result = new JsonObject();
        result.addProperty("tag", outputTag);
        recipe.add("result", (JsonElement)result);
        recipe.addProperty("weight", (Number)weight);
        return recipe;
    }

    public JsonArray buildMinerRecipeConditionJson(String outputTag) {
        JsonArray conditions = new JsonArray();
        JsonObject condition = new JsonObject();
        condition.addProperty("type", "forge:not");
        JsonObject value = new JsonObject();
        value.addProperty("type", "forge:tag_empty");
        value.addProperty("tag", outputTag);
        condition.add("value", (JsonElement)value);
        conditions.add((JsonElement)condition);
        return conditions;
    }

    public String m_6055_() {
        return "Miner Recipes";
    }
}

