/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.entity.familiar;

import com.github.klikli_dev.occultism.Occultism;
import com.github.klikli_dev.occultism.common.advancement.FamiliarTrigger;
import com.github.klikli_dev.occultism.common.entity.familiar.DevilFamiliarEntity;
import com.github.klikli_dev.occultism.common.entity.familiar.FamiliarEntity;
import com.github.klikli_dev.occultism.common.entity.familiar.GoatFamiliarEntity;
import com.github.klikli_dev.occultism.common.entity.familiar.ResizableFamiliarEntity;
import com.github.klikli_dev.occultism.registry.OccultismAdvancements;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Field;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ItemBasedSteering;
import net.minecraft.world.entity.ItemSteerable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

public class ChimeraFamiliarEntity
extends ResizableFamiliarEntity
implements ItemSteerable {
    public static final byte NO_ATTACKER = 0;
    public static final byte LION_ATTACKER = 1;
    public static final byte GOAT_ATTACKER = 2;
    public static final byte SNAKE_ATTACKER = 3;
    private static final UUID SPEED_BONUS = UUID.fromString("f1db15e0-174b-4534-96a3-d941cec44e55");
    private static final UUID DAMAGE_BONUS = UUID.fromString("fdaa6165-abdf-4b85-aed6-199086f6a5ee");
    private static final byte RIDING_SIZE = 80;
    private static final double SHRINK_CHANCE = 0.005;
    private static final int JUMP_COOLDOWN = 40;
    private static final int ATTACK_TIME = 10;
    private static final EntityDataAccessor<Byte> ATTACKER = SynchedEntityData.m_135353_(ChimeraFamiliarEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static Field isRiderJumping;
    private final ItemBasedSteering boost = new DummyBoostHelper();
    private int jumpTimer;
    private int goatNoseTimer = this.m_217043_().m_188503_(100);
    private int attackTimer;

    public ChimeraFamiliarEntity(EntityType<? extends ChimeraFamiliarEntity> type, Level level) {
        super((EntityType<? extends ResizableFamiliarEntity>)type, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return FamiliarEntity.m_21552_().m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22276_, 20.0);
    }

    private boolean isRiderJumping(Player rider) {
        try {
            if (isRiderJumping == null) {
                isRiderJumping = ObfuscationReflectionHelper.findField(LivingEntity.class, (String)"f_20899_");
            }
            return isRiderJumping.getBoolean(rider);
        }
        catch (IllegalAccessException | IllegalArgumentException | ObfuscationReflectionHelper.UnableToFindFieldException e) {
            Occultism.LOGGER.debug("Unable to get jump field for Chimera familiar");
            return false;
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new FamiliarEntity.SitGoal(this, this));
        this.f_21345_.m_25352_(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(5, (Goal)new FamiliarEntity.FollowOwnerGoal(this, 1.0, 3.0f, 1.0f));
        this.f_21345_.m_25352_(6, (Goal)new AttackGoal(this, 10.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new FollowMobGoal((Mob)this, 1.0, 3.0f, 7.0f));
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_ && this.m_217043_().m_188500_() < 0.005) {
            this.setSize((byte)(this.getSize() - 1));
        }
        if (this.jumpTimer > 0) {
            --this.jumpTimer;
        }
        --this.attackTimer;
        if (this.attackTimer == 0) {
            this.setAttacker((byte)0);
        }
        if (this.f_19853_.f_46443_) {
            ++this.goatNoseTimer;
            if (this.attackTimer > 0 && this.getAttacker() == 1) {
                Vec3 direction = Vec3.m_82503_((Vec2)this.m_20155_()).m_82490_((double)this.m_6134_());
                for (int i = 0; i < 5; ++i) {
                    Vec3 pos = this.m_20182_().m_82520_(direction.f_82479_ + (double)(this.m_217043_().m_188501_() - 0.5f) * 0.7, 1.0 + (double)(this.m_217043_().m_188501_() - 0.5f) * 0.7, direction.f_82481_ + (double)(this.m_217043_().m_188501_() - 0.5f) * 0.7);
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123744_, pos.f_82479_, pos.f_82480_, pos.f_82481_, direction.f_82479_ * 0.1, 0.0, direction.f_82481_ * 0.1);
                }
            }
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        this.setGoat(true);
        this.setSize((byte)0);
        this.setFlaps(this.m_217043_().m_188499_());
        this.setRing(this.m_217043_().m_188499_());
        this.setBeard(this.m_217043_().m_188499_());
        this.setHat(this.m_217043_().m_188500_() < 0.1);
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public boolean m_6109_() {
        return true;
    }

    @Override
    public Iterable<MobEffectInstance> getFamiliarEffects() {
        return ImmutableList.of();
    }

    @Override
    public void setSize(byte size) {
        super.setSize(size);
        this.calcSizeModifiers();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACKER, (Object)0);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (!compound.m_128441_("variants")) {
            this.setFlaps(compound.m_128471_("hasFlaps"));
            this.setRing(compound.m_128471_("hasRing"));
            if (compound.m_128441_("hasBeard")) {
                this.setBeard(compound.m_128471_("hasBeard"));
            }
            this.setHat(compound.m_128471_("hasHat"));
            this.setGoat(compound.m_128471_("hasGoat"));
        }
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("hasFlaps", this.hasFlaps());
        compound.m_128379_("hasRing", this.hasRing());
        compound.m_128379_("hasBeard", this.hasBeard());
        compound.m_128379_("hasHat", this.hasHat());
        compound.m_128379_("hasGoat", this.hasGoat());
    }

    @Override
    public void m_7350_(EntityDataAccessor<?> pKey) {
        super.m_7350_(pKey);
        if (ATTACKER.equals(pKey)) {
            this.attackTimer = 10;
        }
    }

    private double getAttackBonus() {
        return Mth.m_14139_((double)((double)this.getSize() / 100.0), (double)0.0, (double)3.0);
    }

    private double getSpeedBonus() {
        return Mth.m_14139_((double)((double)this.getSize() / 100.0), (double)0.0, (double)0.08);
    }

    public boolean hasFlaps() {
        return this.hasVariant(0);
    }

    public boolean hasRing() {
        return this.hasVariant(1);
    }

    public boolean hasBeard() {
        return this.hasVariant(2);
    }

    public boolean hasHat() {
        return this.hasVariant(3);
    }

    public boolean hasGoat() {
        return this.hasVariant(4);
    }

    public byte getAttacker() {
        return (Byte)this.f_19804_.m_135370_(ATTACKER);
    }

    private void setAttacker(byte b) {
        this.f_19804_.m_135381_(ATTACKER, (Object)b);
    }

    private void setFlaps(boolean b) {
        this.setVariant(0, b);
    }

    private void setRing(boolean b) {
        this.setVariant(1, b);
    }

    private void setBeard(boolean b) {
        this.setVariant(2, b);
    }

    private void setHat(boolean b) {
        this.setVariant(3, b);
    }

    private void setGoat(boolean b) {
        this.setVariant(4, b);
    }

    private void calcSizeModifiers() {
        if (this.getSize() <= 80) {
            this.m_20153_();
        }
        this.m_21051_(Attributes.f_22281_).m_22120_(DAMAGE_BONUS);
        this.m_21051_(Attributes.f_22279_).m_22120_(SPEED_BONUS);
        this.m_21051_(Attributes.f_22281_).m_22118_(new AttributeModifier(DAMAGE_BONUS, "Chimera attack bonus", this.getAttackBonus(), AttributeModifier.Operation.ADDITION));
        this.m_21051_(Attributes.f_22279_).m_22118_(new AttributeModifier(SPEED_BONUS, "Chimera speed bonus", this.getSpeedBonus(), AttributeModifier.Operation.ADDITION));
    }

    public float getNoseGoatRot(float partialTicks) {
        if (this.goatNoseTimer % 200 >= 40) {
            return 0.0f;
        }
        float progress = ((float)(this.goatNoseTimer % 200) + partialTicks) / 40.0f;
        return Mth.m_14031_((float)(progress * (float)Math.PI * 4.0f)) * 0.1f;
    }

    public float getAttackProgress(float partialTicks) {
        if (this.attackTimer <= 0) {
            return 0.0f;
        }
        return ((float)(10 - this.attackTimer) + partialTicks) / 10.0f;
    }

    @Override
    protected InteractionResult m_6071_(Player playerIn, InteractionHand hand) {
        ItemStack stack = playerIn.m_21120_(hand);
        FoodProperties food = stack.m_41720_().m_41473_();
        if (this.hasGoat() && stack.m_41720_() == Items.f_42436_ && playerIn == this.getFamiliarOwner()) {
            if (!this.f_19853_.f_46443_) {
                stack.m_41774_(1);
                this.setGoat(false);
                GoatFamiliarEntity goat = new GoatFamiliarEntity(this.f_19853_, this.hasRing(), this.hasBeard(), this.getSize(), this.getFamiliarOwner());
                goat.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                this.f_19853_.m_7967_((Entity)goat);
                OccultismAdvancements.FAMILIAR.trigger((LivingEntity)playerIn, FamiliarTrigger.Type.GOAT_DETACH);
            }
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        if (this.getSize() < 100 && food != null && food.m_38746_()) {
            stack.m_41774_(1);
            this.setSize((byte)(this.getSize() + food.m_38744_()));
            this.m_5634_(4.0f);
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        if (!(this.isSitting() || this.m_20160_() || playerIn.m_36341_() || this.getFamiliarOwner() != playerIn || this.getSize() <= 80)) {
            if (!this.f_19853_.f_46443_) {
                playerIn.m_20329_((Entity)this);
                OccultismAdvancements.FAMILIAR.trigger((LivingEntity)playerIn, FamiliarTrigger.Type.CHIMERA_RIDE);
            }
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return super.m_6071_(playerIn, hand);
    }

    @Override
    public void setFamiliarOwner(LivingEntity owner) {
        if (this.hasHat()) {
            OccultismAdvancements.FAMILIAR.trigger(owner, FamiliarTrigger.Type.RARE_VARIANT);
        }
        super.setFamiliarOwner(owner);
    }

    public boolean m_6746_() {
        return false;
    }

    public void m_7760_(Vec3 pTravelVec) {
        if (this.m_20160_() && this.m_6688_() instanceof Player) {
            Player rider = (Player)this.m_6688_();
            float forward = rider.f_20902_;
            float strafe = rider.f_20900_ * 0.5f;
            if (this.isRiderJumping(rider) && this.f_19861_ && this.jumpTimer <= 0) {
                this.jumpTimer = 40;
                Vec3 forwardDirection = Vec3.m_82498_((float)0.0f, (float)this.f_19859_).m_82490_(0.7);
                this.m_20256_(this.m_20184_().m_82520_(forwardDirection.f_82479_, 0.0, forwardDirection.f_82481_));
                this.m_6135_();
            }
            if (forward < 0.0f) {
                forward *= 0.25f;
            }
            super.m_7023_(new Vec3((double)strafe, 0.0, (double)forward));
        } else {
            super.m_7023_(pTravelVec);
        }
    }

    public float m_6748_() {
        return (float)this.m_21133_(Attributes.f_22279_) * 0.8f;
    }

    protected int m_5639_(float pDistance, float pDamageMultiplier) {
        return super.m_5639_(pDistance - 3.0f, pDamageMultiplier);
    }

    protected float m_6118_() {
        return super.m_6118_() * 1.35f;
    }

    public void m_7023_(Vec3 pTravelVector) {
        this.m_20854_((Mob)this, this.boost, pTravelVector);
    }

    private byte[] possibleAttackers() {
        byte[] byArray;
        if (this.hasGoat()) {
            byte[] byArray2 = new byte[3];
            byArray2[0] = 1;
            byArray2[1] = 2;
            byArray = byArray2;
            byArray2[2] = 3;
        } else {
            byte[] byArray3 = new byte[2];
            byArray3[0] = 1;
            byArray = byArray3;
            byArray3[1] = 3;
        }
        return byArray;
    }

    protected float m_6059_() {
        return this.f_19788_ + 1.6f;
    }

    public double m_6048_() {
        return super.m_6048_() * 0.6;
    }

    @Nullable
    public Entity m_6688_() {
        return this.m_20197_().isEmpty() ? null : (Entity)this.m_20197_().get(0);
    }

    private static class DummyBoostHelper
    extends ItemBasedSteering {
        public DummyBoostHelper() {
            super(null, null, null);
        }

        public void m_20844_() {
        }

        public boolean m_217032_(RandomSource pRand) {
            return false;
        }

        public void m_20847_(CompoundTag pNbt) {
        }

        public void m_20852_(CompoundTag pNbt) {
        }

        public void m_20849_(boolean pSaddled) {
        }

        public boolean m_20851_() {
            return false;
        }
    }

    private static class AttackGoal
    extends DevilFamiliarEntity.AttackGoal {
        ChimeraFamiliarEntity chimera;

        public AttackGoal(ChimeraFamiliarEntity chimera, float range) {
            super(chimera, range);
            this.chimera = chimera;
        }

        @Override
        protected void attack(List<LivingEntity> enemies) {
            byte attacker = this.randomAttacker();
            this.chimera.setAttacker(attacker);
            for (LivingEntity e : enemies) {
                e.m_6469_(DamageSource.m_19344_((Player)((Player)this.chimera.getFamiliarOwner())), (float)this.chimera.m_21133_(Attributes.f_22281_));
                switch (attacker) {
                    case 1: {
                        e.m_20254_(4);
                        break;
                    }
                    case 2: {
                        Vec3 direction = e.m_20182_().m_82505_(this.chimera.m_20182_());
                        e.m_147240_(2.0, direction.f_82479_, direction.f_82481_);
                        break;
                    }
                    case 3: {
                        e.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 200));
                    }
                }
            }
        }

        private byte randomAttacker() {
            byte[] attackers = this.chimera.possibleAttackers();
            return attackers[this.chimera.m_217043_().m_188503_(attackers.length)];
        }
    }
}

