/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.container;

import com.github.klikli_dev.occultism.common.blockentity.DimensionalMineshaftBlockEntity;
import com.github.klikli_dev.occultism.exceptions.ItemHandlerMissingException;
import com.github.klikli_dev.occultism.registry.OccultismContainers;
import com.github.klikli_dev.occultism.registry.OccultismRecipes;
import com.github.klikli_dev.occultism.util.RecipeUtil;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;

public class DimensionalMineshaftContainer
extends AbstractContainerMenu {
    public ItemStackHandler inputHandler;
    public ItemStackHandler outputHandler;
    public DimensionalMineshaftBlockEntity otherworldMiner;
    public Inventory playerInventory;

    public DimensionalMineshaftContainer(int id, Inventory playerInventory, DimensionalMineshaftBlockEntity otherworldMiner) {
        super((MenuType)OccultismContainers.OTHERWORLD_MINER.get(), id);
        this.playerInventory = playerInventory;
        this.otherworldMiner = otherworldMiner;
        this.inputHandler = (ItemStackHandler)otherworldMiner.inputHandler.orElseThrow(ItemHandlerMissingException::new);
        this.outputHandler = (ItemStackHandler)otherworldMiner.outputHandler.orElseThrow(ItemHandlerMissingException::new);
        this.setupMinerInventory();
        this.setupPlayerInventorySlots(playerInventory.f_35978_);
        this.setupPlayerHotbar(playerInventory.f_35978_);
    }

    public boolean m_6875_(Player player) {
        return player.m_20275_((double)this.otherworldMiner.m_58899_().m_123341_() + 0.5, (double)this.otherworldMiner.m_58899_().m_123342_() + 0.5, (double)this.otherworldMiner.m_58899_().m_123343_() + 0.5) <= 64.0;
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index < this.outputHandler.getSlots() ? !this.m_38903_(itemstack1, this.outputHandler.getSlots() + 1, this.f_38839_.size(), true) : (index == this.outputHandler.getSlots() ? !this.m_38903_(itemstack1, this.outputHandler.getSlots() + 1, this.f_38839_.size(), true) : !this.m_38903_(itemstack1, 0, this.outputHandler.getSlots() + 1, false))) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    protected void setupPlayerInventorySlots(Player player) {
        int playerInventoryTop = 84;
        int playerInventoryLeft = 8;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)player.m_150109_(), j + i * 9 + 9, playerInventoryLeft + j * 18, playerInventoryTop + i * 18));
            }
        }
    }

    protected void setupPlayerHotbar(Player player) {
        int hotbarTop = 142;
        int hotbarLeft = 8;
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)player.m_150109_(), i, hotbarLeft + i * 18, hotbarTop));
        }
    }

    protected void setupMinerInventory() {
        int outputGridTop = 17;
        int outputGridLeft = 98;
        int index = 0;
        IItemHandler outputHandler = (IItemHandler)this.otherworldMiner.outputHandler.orElseThrow(ItemHandlerMissingException::new);
        IItemHandler inputHandler = (IItemHandler)this.otherworldMiner.inputHandler.orElseThrow(ItemHandlerMissingException::new);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.m_38897_((Slot)new OutputSlot(outputHandler, index++, outputGridLeft + j * 18, outputGridTop + i * 18));
            }
        }
        this.m_38897_((Slot)new InputSlot(inputHandler, 0, 26, 35));
    }

    public class OutputSlot
    extends SlotItemHandler {
        public OutputSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public boolean m_5857_(ItemStack stack) {
            return false;
        }
    }

    public class InputSlot
    extends SlotItemHandler {
        public InputSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public boolean m_5857_(ItemStack stack) {
            RecipeManager recipeManager = DimensionalMineshaftContainer.this.otherworldMiner.m_58904_().m_7465_();
            return RecipeUtil.isValidIngredient(recipeManager, (RecipeType)OccultismRecipes.MINER_TYPE.get(), stack);
        }
    }
}

