/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.thermal;

import com.google.gson.JsonElement;
import dev.latvian.mods.kubejs.bindings.BlockWrapper;
import dev.latvian.mods.kubejs.fluid.EmptyFluidStackJS;
import dev.latvian.mods.kubejs.fluid.FluidStackJS;
import dev.latvian.mods.kubejs.recipe.IngredientMatch;
import dev.latvian.mods.kubejs.recipe.ItemInputTransformer;
import dev.latvian.mods.kubejs.recipe.ItemOutputTransformer;
import dev.latvian.mods.kubejs.recipe.RecipeArguments;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.thermal.ThermalRecipeJS;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class HiveExtractorMappingRecipeJS
extends ThermalRecipeJS {
    public FluidStackJS outputFluid = EmptyFluidStackJS.INSTANCE;
    public Block hive = Blocks.f_50016_;
    public ItemStack item = ItemStack.f_41583_;

    public void create(RecipeArguments args) {
        this.outputFluid = FluidStackJS.of((Object)args.get(0));
        this.item = this.parseItemOutput(args.get(1));
        this.hive = BlockWrapper.getBlock((ResourceLocation)new ResourceLocation(args.get(1).toString()));
    }

    public HiveExtractorMappingRecipeJS hive(Block block) {
        this.hive = block;
        this.serializeInputs = true;
        this.save();
        return this;
    }

    public void deserialize() {
        this.hive = BlockWrapper.getBlock((ResourceLocation)new ResourceLocation(this.json.get("trunk").getAsString()));
        if (this.json.has("item")) {
            this.item = this.parseItemOutput(this.json.get("item"));
        }
        if (this.json.has("result")) {
            this.outputFluid = FluidStackJS.fromJson((JsonElement)this.json.get("result"));
        } else if (this.json.has("fluid")) {
            this.outputFluid = FluidStackJS.fromJson((JsonElement)this.json.get("fluid"));
        }
    }

    public void serialize() {
        if (this.serializeInputs) {
            this.json.addProperty("hive", this.hive.kjs$getId());
        }
        if (this.serializeOutputs) {
            this.json.add("result", (JsonElement)this.outputFluid.toJson());
            this.json.add("item", this.itemToJson(this.item));
        }
    }

    public boolean hasInput(IngredientMatch match) {
        return false;
    }

    public boolean replaceInput(IngredientMatch match, Ingredient with, ItemInputTransformer transformer) {
        return false;
    }

    public boolean hasOutput(IngredientMatch match) {
        return match.contains(this.item);
    }

    public boolean replaceOutput(IngredientMatch match, ItemStack with, ItemOutputTransformer transformer) {
        if (match.contains(this.item)) {
            this.item = transformer.transform((RecipeJS)this, match, this.item, with);
            return true;
        }
        return false;
    }
}

