/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.thermal;

import cofh.lib.fluid.FluidIngredient;
import cofh.lib.util.recipes.RecipeJsonUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import dev.latvian.mods.kubejs.fluid.FluidStackJS;
import dev.latvian.mods.kubejs.recipe.IngredientMatch;
import dev.latvian.mods.kubejs.recipe.ItemInputTransformer;
import dev.latvian.mods.kubejs.recipe.ItemOutputTransformer;
import dev.latvian.mods.kubejs.recipe.RecipeArguments;
import dev.latvian.mods.kubejs.recipe.RecipeExceptionJS;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.thermal.ThermalRecipeJS;
import dev.latvian.mods.kubejs.util.ListJS;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.fluids.FluidStack;

public class BasicThermalRecipeJS
extends ThermalRecipeJS {
    public final List<Ingredient> inputItems = new ArrayList<Ingredient>(1);
    public final List<FluidIngredient> inputFluids = new ArrayList<FluidIngredient>(0);
    public final List<ItemStack> outputItems = new ArrayList<ItemStack>(1);
    public final List<Float> outputItemChances = new ArrayList<Float>(1);
    public final List<FluidStack> outputFluids = new ArrayList<FluidStack>(0);
    public String inKey = "";
    public String outKey = "";

    public void create(RecipeArguments args) {
        this.inKey = "ingredients";
        this.outKey = "results";
        for (Object o : ListJS.orSelf((Object)args.get(0))) {
            if (o instanceof FluidStackJS) {
                this.outputFluids.add(this.fluidOutputFrom((FluidStackJS)o));
                continue;
            }
            this.outputItems.add(this.parseItemOutput(o));
        }
        for (Object o : ListJS.orSelf((Object)args.get(1))) {
            if (o instanceof FluidStackJS) {
                this.inputFluids.add(this.fluidInputFrom((FluidStackJS)o));
                continue;
            }
            this.inputItems.add(this.parseItemInput(o));
        }
        if (this.outputItems.isEmpty() && this.outputFluids.isEmpty()) {
            throw new RecipeExceptionJS("Thermal recipe can't have no result!");
        }
        if (this.inputItems.isEmpty() && this.inputFluids.isEmpty()) {
            throw new RecipeExceptionJS("Thermal recipe can't have no ingredients!");
        }
    }

    public BasicThermalRecipeJS experience(float e) {
        this.json.addProperty("experience", (Number)Float.valueOf(e));
        this.save();
        return this;
    }

    public BasicThermalRecipeJS minTicks(int i) {
        this.json.addProperty("min_ticks", (Number)i);
        this.save();
        return this;
    }

    public void deserialize() {
        this.inKey = "";
        this.outKey = "";
        if (this.json.has("ingredient")) {
            this.inKey = "ingredient";
            RecipeJsonUtils.parseInputs(this.inputItems, this.inputFluids, (JsonElement)this.json.get("ingredient"));
        } else if (this.json.has("ingredients")) {
            this.inKey = "ingredients";
            RecipeJsonUtils.parseInputs(this.inputItems, this.inputFluids, (JsonElement)this.json.get("ingredients"));
        } else if (this.json.has("input")) {
            this.inKey = "input";
            RecipeJsonUtils.parseInputs(this.inputItems, this.inputFluids, (JsonElement)this.json.get("input"));
        } else if (this.json.has("inputs")) {
            this.inKey = "inputs";
            RecipeJsonUtils.parseInputs(this.inputItems, this.inputFluids, (JsonElement)this.json.get("inputs"));
        }
        if (this.json.has("result")) {
            this.outKey = "result";
            RecipeJsonUtils.parseOutputs(this.outputItems, this.outputItemChances, this.outputFluids, (JsonElement)this.json.get("result"));
        } else if (this.json.has("results")) {
            this.outKey = "results";
            RecipeJsonUtils.parseOutputs(this.outputItems, this.outputItemChances, this.outputFluids, (JsonElement)this.json.get("results"));
        } else if (this.json.has("output")) {
            this.outKey = "output";
            RecipeJsonUtils.parseOutputs(this.outputItems, this.outputItemChances, this.outputFluids, (JsonElement)this.json.get("output"));
        } else if (this.json.has("outputs")) {
            this.outKey = "outputs";
            RecipeJsonUtils.parseOutputs(this.outputItems, this.outputItemChances, this.outputFluids, (JsonElement)this.json.get("outputs"));
        }
    }

    public void serialize() {
        if (this.serializeOutputs && !this.outKey.isEmpty()) {
            JsonArray out = new JsonArray();
            for (ItemStack itemStack : this.outputItems) {
                out.add(this.itemToJson(itemStack));
            }
            for (FluidStack fluidStack : this.outputFluids) {
                out.add(this.fluidToJson(fluidStack));
            }
            this.json.add(this.outKey, (JsonElement)out);
        }
        if (this.serializeInputs && !this.inKey.isEmpty()) {
            JsonArray in = new JsonArray();
            for (Ingredient ingredient : this.inputItems) {
                in.add(ingredient.m_43942_());
            }
            for (FluidIngredient fluidIngredient : this.inputFluids) {
                in.add(fluidIngredient.toJson());
            }
            this.json.add(this.inKey, (JsonElement)in);
        }
    }

    public boolean hasInput(IngredientMatch match) {
        for (Ingredient in : this.inputItems) {
            if (!match.contains(in)) continue;
            return true;
        }
        return false;
    }

    public boolean replaceInput(IngredientMatch match, Ingredient with, ItemInputTransformer transformer) {
        boolean changed = false;
        for (int i = 0; i < this.inputItems.size(); ++i) {
            Ingredient in = this.inputItems.get(i);
            if (!match.contains(in)) continue;
            this.inputItems.set(i, transformer.transform((RecipeJS)this, match, in, with));
            changed = true;
        }
        return changed;
    }

    public boolean hasOutput(IngredientMatch match) {
        for (ItemStack out : this.outputItems) {
            if (!match.contains(out)) continue;
            return true;
        }
        return false;
    }

    public boolean replaceOutput(IngredientMatch match, ItemStack with, ItemOutputTransformer transformer) {
        boolean changed = false;
        for (int i = 0; i < this.outputItems.size(); ++i) {
            ItemStack out = this.outputItems.get(i);
            if (!match.contains(out)) continue;
            this.outputItems.set(i, transformer.transform((RecipeJS)this, match, out, with));
            changed = true;
        }
        return changed;
    }
}

