/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.util;

import chanceCubes.config.CCubesSettings;
import chanceCubes.mcwrapper.BlockWrapper;
import chanceCubes.util.RewardsUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class RewardBlockCache {
    protected final List<StoredBlockData> storedBlocks = new ArrayList<StoredBlockData>();
    protected final Map<BlockPos, CompoundTag> storedTE = new HashMap<BlockPos, CompoundTag>();
    private final BlockPos origin;
    private final BlockPos playerLoc;
    private final Level level;
    private boolean force = true;

    public RewardBlockCache(Level level, BlockPos pos, BlockPos playerLoc) {
        this.level = level;
        this.origin = pos;
        this.playerLoc = playerLoc;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public void cacheBlock(BlockPos offset, BlockState newState) {
        this.cacheBlock(offset, newState, 3);
    }

    public void cacheBlock(BlockPos offset, BlockState newState, int update) {
        BlockPos adjPos = this.origin.m_121955_((Vec3i)offset);
        BlockState oldState = this.level.m_8055_(adjPos);
        CompoundTag oldNBT = null;
        BlockEntity te = this.level.m_7702_(adjPos);
        if (te != null) {
            oldNBT = te.serializeNBT();
            if (te instanceof Container) {
                ((Container)te).m_6211_();
            }
        }
        if (RewardsUtil.placeBlock(newState, this.level, adjPos, update, this.force) && this.storedBlocks.stream().noneMatch(t -> t.pos.equals((Object)offset))) {
            this.storedBlocks.add(new StoredBlockData(offset, oldState, newState));
            if (oldNBT != null) {
                this.storedTE.put(offset, oldNBT);
            }
        }
    }

    public void restoreBlocks(Entity player) {
        List blockedRestoreBlocks = (List)CCubesSettings.blockRestoreBlacklist.get();
        for (StoredBlockData storedBlock : this.storedBlocks) {
            BlockPos worldPos = this.origin.m_121955_((Vec3i)storedBlock.pos);
            ResourceLocation res = BlockWrapper.getBlockId(this.level.m_8055_(worldPos).m_60734_());
            if (res != null && blockedRestoreBlocks.contains(res.toString())) continue;
            RewardsUtil.placeBlock(storedBlock.oldState, this.level, worldPos, true);
            BlockEntity tile = this.level.m_7702_(worldPos);
            if (!this.storedTE.containsKey(storedBlock.pos) || tile == null) continue;
            tile.deserializeNBT(this.storedTE.get(storedBlock.pos));
        }
        if (player != null) {
            player.m_6027_((double)this.playerLoc.m_123341_() + 0.5, (double)(this.playerLoc.m_123342_() + 1), (double)this.playerLoc.m_123343_() + 0.5);
        }
    }

    private static class StoredBlockData {
        public final BlockPos pos;
        public final BlockState oldState;
        public final BlockState placedState;

        public StoredBlockData(BlockPos pos, BlockState oldState, BlockState placedState) {
            this.pos = pos;
            this.oldState = oldState;
            this.placedState = placedState;
        }
    }
}

