/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.defaultRewards;

import chanceCubes.CCubesCore;
import chanceCubes.mcwrapper.ComponentWrapper;
import chanceCubes.parsers.RewardParser;
import chanceCubes.rewards.defaultRewards.BaseCustomReward;
import chanceCubes.rewards.variableTypes.IntVar;
import chanceCubes.util.CustomEntry;
import chanceCubes.util.GuiTextLocation;
import chanceCubes.util.HTTPUtil;
import chanceCubes.util.RewardsUtil;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class StreamerReward {
    private Socket socket;
    private BufferedWriter writter;
    private final String channel;
    private boolean connectedToChat = false;
    private final List<String> voted = new ArrayList<String>();
    private final List<Option> options = new ArrayList<Option>();
    private int timeLeft;

    public StreamerReward(String channel, JsonArray jsonOptions) {
        this.channel = "#" + channel;
        for (JsonElement option : jsonOptions) {
            String display = option.getAsJsonObject().get("display").getAsString();
            JsonObject reward = option.getAsJsonObject().getAsJsonObject("reward");
            Iterator iterator = reward.getAsJsonObject().entrySet().iterator();
            if (!iterator.hasNext()) continue;
            Map.Entry entry = (Map.Entry)iterator.next();
            BaseCustomReward theReward = ((String)entry.getKey()).equals("chat_invades") ? new ChatInvadeReward(channel) : (BaseCustomReward)RewardParser.parseReward(entry).getKey();
            this.options.add(new Option(display, theReward, 0));
        }
    }

    public boolean trigger(final ServerLevel world, BlockPos pos, final Player player) {
        try {
            if (!this.connectedToChat) {
                this.initTwitchChatconnection();
            }
        }
        catch (Exception e) {
            RewardsUtil.sendMessageToPlayer(player, "An issue has occurred with this reward! Code: 0x545749544348");
            e.printStackTrace();
            return false;
        }
        this.timeLeft = 45;
        this.voted.clear();
        for (Option opt : this.options) {
            opt.votes = 0;
        }
        Scheduler.scheduleTask(new Task("Streamer_Reward", -1, 20){
            int step;
            {
                super(name, delay, updateTick);
                this.step = 0;
            }

            @Override
            public void callback() {
            }

            @Override
            public void update() {
                ++this.step;
                switch (this.step) {
                    case 1: {
                        MutableComponent message = ComponentWrapper.string("Hey Twitch Chat!");
                        message.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.DARK_PURPLE)));
                        RewardsUtil.setPlayerTitle(player, GuiTextLocation.TITLE, (Component)message, 10, 60, 10);
                        break;
                    }
                    case 6: {
                        MutableComponent message = ComponentWrapper.string("Let's Play A Game!");
                        message.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.DARK_PURPLE)));
                        RewardsUtil.setPlayerTitle(player, GuiTextLocation.TITLE, (Component)message, 10, 60, 10);
                        break;
                    }
                    case 11: {
                        MutableComponent message = ComponentWrapper.string("Decide My Fate!");
                        message.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.DARK_PURPLE)));
                        RewardsUtil.setPlayerTitle(player, GuiTextLocation.TITLE, (Component)message, 10, 60, 10);
                    }
                }
                if (this.step > 15) {
                    StreamerReward.this.updateTitle(player);
                    --StreamerReward.this.timeLeft;
                }
                if (StreamerReward.this.timeLeft == 0) {
                    Scheduler.removeTask(this);
                    Option winner = StreamerReward.this.options.get(0);
                    for (Option opt : StreamerReward.this.options) {
                        if (opt.votes <= winner.votes) continue;
                        winner = opt;
                    }
                    RewardsUtil.sendMessageToPlayer(player, winner.display + " Has won!");
                    winner.reward.trigger(world, player.m_20097_(), player, new JsonObject());
                    StreamerReward.this.disconnect();
                }
            }
        });
        return true;
    }

    private void initTwitchChatconnection() throws IOException {
        this.socket = new Socket("irc.chat.twitch.tv", 6667);
        this.writter = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream()));
        this.connectedToChat = true;
        Thread thread = new Thread(() -> {
            block3: {
                try {
                    String line;
                    InputStreamReader inputStreamReader = new InputStreamReader(this.socket.getInputStream());
                    BufferedReader breader = new BufferedReader(inputStreamReader);
                    while ((line = breader.readLine()) != null && this.connectedToChat) {
                        int choice;
                        String message;
                        int firstSpace = line.indexOf(" ");
                        int secondSpace = line.indexOf(" ", firstSpace + 1);
                        if (secondSpace < 0) continue;
                        String from = line.substring(0, firstSpace);
                        String code = line.substring(firstSpace + 1, secondSpace);
                        String rest = line.substring(secondSpace + 1);
                        if (!"PRIVMSG".equals(code) || this.voted.contains(from) || !IntVar.isInteger(message = rest.substring(rest.indexOf(" ") + 2)) || (choice = Integer.parseInt(message) - 1) < 0 || choice >= 5) continue;
                        ++this.options.get((int)choice).votes;
                        this.voted.add(from);
                    }
                }
                catch (Exception e) {
                    if (e instanceof SocketException) break block3;
                    e.printStackTrace();
                }
            }
            this.disconnect();
        });
        this.sendString("PASS PASSWORD");
        this.sendString("NICK justinfan2349");
        this.sendString("JOIN " + this.channel);
        thread.start();
        try {
            HTTPUtil.makeAPIReq("POST", "chancecubes/triggerstreamerreward", new CustomEntry<String, String>("channel", this.channel));
        }
        catch (Exception e) {
            CCubesCore.logger.log(org.apache.logging.log4j.Level.ERROR, "FAILED TO TRIGGER THE CHAT BOT!");
            e.printStackTrace();
        }
    }

    private void disconnect() {
        this.connectedToChat = false;
        try {
            this.socket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void updateTitle(Player player) {
        StringBuilder sb = new StringBuilder();
        for (Option option : this.options) {
            sb.append(option.votes).append(" - ");
        }
        sb.delete(sb.length() - 2, sb.length());
        MutableComponent message = ComponentWrapper.string(sb.toString());
        message.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.DARK_PURPLE)));
        RewardsUtil.setPlayerTitle(player, GuiTextLocation.TITLE, (Component)message, 0, 40, 0);
        message = ComponentWrapper.string("Time Left: " + this.timeLeft);
        message.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.DARK_PURPLE)));
        RewardsUtil.setPlayerTitle(player, GuiTextLocation.SUBTITLE, (Component)message, 0, 40, 0);
    }

    private void sendString(String str) {
        try {
            if (this.writter == null || !this.connectedToChat) {
                this.initTwitchChatconnection();
            }
            this.writter.write(str + "\r\n");
            this.writter.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class ChatInvadeReward
    extends BaseCustomReward {
        private final String channel;

        public ChatInvadeReward(String channel) {
            super("chatInvades", 0);
            this.channel = channel;
        }

        @Override
        public void trigger(ServerLevel level, BlockPos pos, Player player, JsonObject settings) {
            try {
                JsonObject json = HTTPUtil.getWebFile("GET", "http://tmi.twitch.tv/group/user/" + this.channel + "/chatters", new CustomEntry[0]).getAsJsonObject();
                for (Map.Entry entry : json.get("chatters").getAsJsonObject().entrySet()) {
                    if (!((JsonElement)entry.getValue()).isJsonArray()) continue;
                    for (JsonElement user : ((JsonElement)entry.getValue()).getAsJsonArray()) {
                        Zombie zombie;
                        if (!user.isJsonPrimitive() || (zombie = (Zombie)EntityType.f_20501_.m_20615_((Level)level)) == null) continue;
                        zombie.m_6027_(player.m_20185_(), player.m_20186_(), player.m_20189_());
                        zombie.m_6593_((Component)ComponentWrapper.string(user.getAsString()));
                        zombie.m_20340_(true);
                        level.m_7967_((Entity)zombie);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static class Option {
        public final String display;
        public final BaseCustomReward reward;
        public int votes;

        public Option(String display, BaseCustomReward reward, int votes) {
            this.display = display;
            this.reward = reward;
            this.votes = votes;
        }
    }
}

