/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.commands;

import chanceCubes.CCubesCore;
import chanceCubes.client.ClientHelper;
import chanceCubes.client.listeners.RenderEvent;
import chanceCubes.commands.InfoAction;
import chanceCubes.commands.RewardArgument;
import chanceCubes.config.CCubesSettings;
import chanceCubes.config.ConfigLoader;
import chanceCubes.config.CustomRewardsLoader;
import chanceCubes.mcwrapper.ItemWrapper;
import chanceCubes.registry.global.GlobalCCRewardRegistry;
import chanceCubes.registry.player.PlayerRewardInfo;
import chanceCubes.rewards.DefaultGiantRewards;
import chanceCubes.rewards.DefaultRewards;
import chanceCubes.rewards.IChanceCubeReward;
import chanceCubes.sounds.CCubesSounds;
import chanceCubes.util.GiantCubeUtil;
import chanceCubes.util.NonreplaceableBlockOverride;
import chanceCubes.util.RewardsUtil;
import chanceCubes.util.SchematicUtil;
import com.google.gson.JsonObject;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.server.ServerLifecycleHooks;
import net.minecraftforge.server.command.EnumArgument;

public class CCubesServerCommands {
    public CCubesServerCommands(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"chancecubes").then(Commands.m_82127_((String)"reload").executes(this::executeReload))).then(Commands.m_82127_((String)"version").executes(this::executeVersion))).then(Commands.m_82127_((String)"handNBT").executes(this::executeHandNBT))).then(Commands.m_82127_((String)"handID").executes(this::executeHandID))).then(Commands.m_82127_((String)"disableReward").then(Commands.m_82129_((String)"rewardName", (ArgumentType)new RewardArgument()).executes(ctx -> this.executeDisableReward((CommandContext<CommandSourceStack>)ctx, RewardArgument.getReward((CommandContext<CommandSourceStack>)ctx, "rewardName")))))).then(Commands.m_82127_((String)"enableReward").then(Commands.m_82129_((String)"rewardName", (ArgumentType)RewardArgument.rewardArgument()).executes(ctx -> this.executeEnableReward((CommandContext<CommandSourceStack>)ctx, RewardArgument.getReward((CommandContext<CommandSourceStack>)ctx, "rewardName")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"schematic").requires(cs -> cs.m_6761_(2))).requires(cs -> cs.m_81372_().m_5776_())).then(Commands.m_82127_((String)"create").executes(this::executeSchematicCreate))).then(Commands.m_82127_((String)"cancel").executes(this::executeSchematicCancel)))).then(Commands.m_82127_((String)"rewardsInfo").then(Commands.m_82129_((String)"action", (ArgumentType)EnumArgument.enumArgument(InfoAction.class)).executes(ctx -> this.executeRewardInfo((CommandContext<CommandSourceStack>)ctx, (InfoAction)((Object)((Object)ctx.getArgument("action", InfoAction.class)))))))).then(Commands.m_82127_((String)"test").executes(this::executeTest))).then(Commands.m_82127_((String)"testRewards").executes(this::executeTestRewards))).then(Commands.m_82127_((String)"testCustomRewards").executes(this::executeTestCustomRewards))).then(Commands.m_82127_((String)"spawnGiantCube").then(Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).executes(ctx -> this.executeSpawnGiantCube((CommandContext<CommandSourceStack>)ctx, BlockPosArgument.m_118242_((CommandContext)ctx, (String)"pos")))))).then(Commands.m_82127_((String)"spawnReward").then(Commands.m_82129_((String)"rewardName", (ArgumentType)new RewardArgument()).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91470_()).executes(ctx -> this.executeSpawnReward((CommandContext<CommandSourceStack>)ctx, RewardArgument.getReward((CommandContext<CommandSourceStack>)ctx, "rewardName"), EntityArgument.m_91477_((CommandContext)ctx, (String)"target")))))));
    }

    public ServerPlayer getPlayer(CommandSourceStack source) {
        try {
            return source.m_81375_();
        }
        catch (CommandSyntaxException e) {
            CCubesCore.logger.error("You should never see this. If you do you broke everything. Report to Turkey");
            return null;
        }
    }

    public int executeReload(CommandContext<CommandSourceStack> ctx) {
        new Thread(() -> {
            GlobalCCRewardRegistry.DEFAULT.ClearRewards();
            GlobalCCRewardRegistry.GIANT.ClearRewards();
            ConfigLoader.reload();
            DefaultRewards.loadDefaultRewards();
            DefaultGiantRewards.loadDefaultRewards();
            CustomRewardsLoader.instance.loadCustomRewards();
            GlobalCCRewardRegistry.loadCustomUserRewards(ServerLifecycleHooks.getCurrentServer());
            NonreplaceableBlockOverride.loadOverrides();
            RewardsUtil.sendMessageToPlayer((Player)this.getPlayer((CommandSourceStack)ctx.getSource()), "Rewards Reloaded");
        }).start();
        return 0;
    }

    public int executeVersion(CommandContext<CommandSourceStack> ctx) {
        String ver = ((ModContainer)ModList.get().getModContainerById("chancecubes").get()).getModInfo().getVersion().toString();
        RewardsUtil.sendMessageToPlayer((Player)this.getPlayer((CommandSourceStack)ctx.getSource()), "Chance Cubes Version " + ver);
        return 0;
    }

    public int executeHandNBT(CommandContext<CommandSourceStack> ctx) {
        ServerPlayer player = this.getPlayer((CommandSourceStack)ctx.getSource());
        CompoundTag nbt = player.m_150109_().m_36056_().m_41784_();
        RewardsUtil.sendMessageToPlayer((Player)player, nbt.toString());
        return 0;
    }

    public int executeHandID(CommandContext<CommandSourceStack> ctx) {
        ServerPlayer player = this.getPlayer((CommandSourceStack)ctx.getSource());
        ItemStack stack = player.m_150109_().m_36056_();
        if (!stack.m_41619_()) {
            ResourceLocation res = ItemWrapper.getItemId(stack);
            RewardsUtil.sendMessageToPlayer((Player)player, res.m_135827_() + ":" + res.m_135815_());
            RewardsUtil.sendMessageToPlayer((Player)player, "meta: " + stack.m_41773_());
        }
        return 0;
    }

    public int executeDisableReward(CommandContext<CommandSourceStack> ctx, String reward) {
        ServerPlayer player = this.getPlayer((CommandSourceStack)ctx.getSource());
        if (GlobalCCRewardRegistry.DEFAULT.disableReward(reward)) {
            RewardsUtil.sendMessageToPlayer((Player)player, reward + " Has been disabled.");
        } else if (GlobalCCRewardRegistry.GIANT.disableReward(reward)) {
            RewardsUtil.sendMessageToPlayer((Player)player, reward + " Has been disabled.");
        } else {
            RewardsUtil.sendMessageToPlayer((Player)player, reward + " is either not currently enabled or is not a valid reward name.");
        }
        return 0;
    }

    public int executeEnableReward(CommandContext<CommandSourceStack> ctx, String reward) {
        ServerPlayer player = this.getPlayer((CommandSourceStack)ctx.getSource());
        if (GlobalCCRewardRegistry.DEFAULT.enableReward(reward)) {
            RewardsUtil.sendMessageToPlayer((Player)player, reward + " Has been enabled.");
        } else if (GlobalCCRewardRegistry.GIANT.enableReward(reward)) {
            RewardsUtil.sendMessageToPlayer((Player)player, reward + " Has been enabled.");
        } else {
            RewardsUtil.sendMessageToPlayer((Player)player, reward + " is either not currently disabled or is not a valid reward name.");
        }
        return 0;
    }

    public int executeSchematicCreate(CommandContext<CommandSourceStack> ctx) {
        if (RenderEvent.isCreatingSchematic()) {
            if (SchematicUtil.selectionPoints[0] != null && SchematicUtil.selectionPoints[1] != null) {
                DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientHelper.openSchematicCreatorGUI((Player)this.getPlayer((CommandSourceStack)ctx.getSource())));
            } else {
                RewardsUtil.sendMessageToPlayer((Player)this.getPlayer((CommandSourceStack)ctx.getSource()), "Please set both points before moving on!");
            }
        } else {
            RenderEvent.setCreatingSchematic(true);
        }
        return 0;
    }

    public int executeSchematicCancel(CommandContext<CommandSourceStack> ctx) {
        RenderEvent.setCreatingSchematic(false);
        SchematicUtil.selectionPoints[0] = null;
        SchematicUtil.selectionPoints[1] = null;
        return 0;
    }

    public int executeRewardInfo(CommandContext<CommandSourceStack> ctx, InfoAction action) {
        ServerPlayer player = this.getPlayer((CommandSourceStack)ctx.getSource());
        List<PlayerRewardInfo> defaultrewards = GlobalCCRewardRegistry.DEFAULT.getPlayerRewardRegistry(player.m_20149_()).getPlayersRewards();
        List<PlayerRewardInfo> giantrewards = GlobalCCRewardRegistry.GIANT.getPlayerRewardRegistry(player.m_20149_()).getPlayersRewards();
        int defaultEnabled = defaultrewards.size();
        int giantEnabled = giantrewards.size();
        ArrayList<String> playerRewards = new ArrayList<String>();
        switch (action) {
            case DEFAULT: {
                RewardsUtil.sendMessageToPlayer((Player)player, "===DEFAULT REWARDS===");
                for (PlayerRewardInfo playerRewardInfo : defaultrewards) {
                    RewardsUtil.sendMessageToPlayer((Player)player, playerRewardInfo.reward.getName());
                }
                break;
            }
            case GIANT: {
                RewardsUtil.sendMessageToPlayer((Player)player, "===GIANT REWARDS===");
                for (PlayerRewardInfo playerRewardInfo : giantrewards) {
                    RewardsUtil.sendMessageToPlayer((Player)player, playerRewardInfo.reward.getName());
                }
                break;
            }
            case DEFAULT_ALL: {
                RewardsUtil.sendMessageToPlayer((Player)player, "===DEFAULT REWARDS===");
                for (String string : GlobalCCRewardRegistry.DEFAULT.getRewardNames()) {
                    RewardsUtil.sendMessageToPlayer((Player)player, string);
                }
                break;
            }
            case GIANT_ALL: {
                RewardsUtil.sendMessageToPlayer((Player)player, "===GIANT REWARDS===");
                for (String string : GlobalCCRewardRegistry.GIANT.getRewardNames()) {
                    RewardsUtil.sendMessageToPlayer((Player)player, string);
                }
                break;
            }
            case DEFAULT_DISABLED: {
                RewardsUtil.sendMessageToPlayer((Player)player, "===DEFAULT REWARDS DISABLED===");
                for (PlayerRewardInfo playerRewardInfo : defaultrewards) {
                    playerRewards.add(playerRewardInfo.reward.getName());
                }
                for (String string : GlobalCCRewardRegistry.DEFAULT.getRewardNames()) {
                    if (playerRewards.contains(string)) continue;
                    RewardsUtil.sendMessageToPlayer((Player)player, string);
                }
                break;
            }
            case GIANT_DISABLED: {
                RewardsUtil.sendMessageToPlayer((Player)player, "===GIANT REWARDS DISABLED===");
                for (PlayerRewardInfo playerRewardInfo : giantrewards) {
                    playerRewards.add(playerRewardInfo.reward.getName());
                }
                for (String string : GlobalCCRewardRegistry.GIANT.getRewardNames()) {
                    if (playerRewards.contains(string)) continue;
                    RewardsUtil.sendMessageToPlayer((Player)player, string);
                }
                break;
            }
        }
        RewardsUtil.sendMessageToPlayer((Player)this.getPlayer((CommandSourceStack)ctx.getSource()), "There are currently " + GlobalCCRewardRegistry.DEFAULT.getNumberOfLoadedRewards() + " regular rewards loaded and you have " + defaultEnabled + " rewards enabled");
        RewardsUtil.sendMessageToPlayer((Player)this.getPlayer((CommandSourceStack)ctx.getSource()), "There are currently " + GlobalCCRewardRegistry.GIANT.getNumberOfLoadedRewards() + " giant rewards loaded and you have " + giantEnabled + " rewards enabled");
        return 0;
    }

    public int executeTestRewards(CommandContext<CommandSourceStack> ctx) {
        CCubesSettings.testRewards = !CCubesSettings.testRewards;
        CCubesSettings.testingRewardIndex = 0;
        if (CCubesSettings.testRewards) {
            RewardsUtil.sendMessageToPlayer((Player)this.getPlayer((CommandSourceStack)ctx.getSource()), "Reward testing is now enabled for all rewards!");
        } else {
            RewardsUtil.sendMessageToPlayer((Player)this.getPlayer((CommandSourceStack)ctx.getSource()), "Reward testing is now disabled and normal randomness is back.");
        }
        return 0;
    }

    public int executeTestCustomRewards(CommandContext<CommandSourceStack> ctx) {
        CCubesSettings.testCustomRewards = !CCubesSettings.testCustomRewards;
        CCubesSettings.testingRewardIndex = 0;
        if (CCubesSettings.testCustomRewards) {
            RewardsUtil.sendMessageToPlayer((Player)this.getPlayer((CommandSourceStack)ctx.getSource()), "Reward testing is now enabled for custom rewards!");
        } else {
            RewardsUtil.sendMessageToPlayer((Player)this.getPlayer((CommandSourceStack)ctx.getSource()), "Reward testing is now disabled and normal randomness is back.");
        }
        return 0;
    }

    public int executeTest(CommandContext<CommandSourceStack> ctx) {
        return 0;
    }

    public int executeSpawnGiantCube(CommandContext<CommandSourceStack> ctx, BlockPos pos) {
        ServerLevel level = ((CommandSourceStack)ctx.getSource()).m_81372_();
        if (RewardsUtil.isBlockUnbreakable((Level)level, pos.m_7918_(0, 0, 0)) && CCubesSettings.nonReplaceableBlocks.contains(level.m_8055_(pos.m_7918_(0, 0, 0)))) {
            return 0;
        }
        GiantCubeUtil.setupStructure(pos.m_7918_(-1, -1, -1), (Level)level, true);
        level.m_5594_(null, pos, (SoundEvent)CCubesSounds.GIANT_CUBE_SPAWN.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        return 0;
    }

    public int executeSpawnReward(CommandContext<CommandSourceStack> ctx, String rewardName, Collection<ServerPlayer> targets) {
        IChanceCubeReward reward = GlobalCCRewardRegistry.DEFAULT.getRewardByName(rewardName);
        if (reward == null) {
            reward = GlobalCCRewardRegistry.GIANT.getRewardByName(rewardName);
        }
        if (reward == null) {
            CCubesCore.logger.error(rewardName + " is not a valid reward in the spawnReward command!");
            return 0;
        }
        CCubesCore.logger.info("spawnReward command is spawning " + rewardName);
        for (ServerPlayer target : targets) {
            reward.trigger(((CommandSourceStack)ctx.getSource()).m_81372_(), target.m_20097_(), (Player)target, new JsonObject());
        }
        return 0;
    }
}

