/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.util.tools;

import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;

public final class RegistryUtils {
    private RegistryUtils() {
    }

    public static <T> int getId(IForgeRegistry<T> registry, T value) {
        return ((ForgeRegistry)registry).getID(value);
    }

    public static <T> T getById(IForgeRegistry<T> registry, int id) {
        return (T)((ForgeRegistry)registry).getValue(id);
    }

    @Nullable
    public static <T> T getFromString(IForgeRegistry<T> registry, String resourceLocation) {
        return (T)registry.getValue(new ResourceLocation(resourceLocation));
    }

    public static <T> ResourceLocation getIdFromRegistry(IForgeRegistry<T> registry, T element) {
        return registry.getKey(element);
    }

    public static ResourceLocation getItemId(Item item) {
        return RegistryUtils.getIdFromRegistry(ForgeRegistries.ITEMS, item);
    }

    public static ResourceLocation getBlockId(Block item) {
        return RegistryUtils.getIdFromRegistry(ForgeRegistries.BLOCKS, item);
    }
}

