/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.util.compression;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public final class DataCompressor<T>
implements ToIntFunction<T> {
    private int cur = 0;
    private Object2IntMap<T> objectMap;
    private List<T> reverseMap;

    public DataCompressor(int expectedSize) {
        this.objectMap = new Object2IntOpenHashMap(expectedSize);
        this.reverseMap = new LinkedList<T>();
    }

    public DataCompressor() {
        this.objectMap = new Object2IntOpenHashMap();
        this.reverseMap = new LinkedList<T>();
    }

    @Override
    public int applyAsInt(T value) {
        if (this.objectMap.containsKey(value)) {
            return this.objectMap.getInt(value);
        }
        this.objectMap.put(value, this.cur);
        this.reverseMap.add(value);
        return this.cur++;
    }

    public List<T> getReverseMap() {
        return this.reverseMap;
    }

    public ListTag write(Function<T, ? extends Tag> serializer) {
        ListTag resList = new ListTag();
        for (T entry : this.reverseMap) {
            resList.add((Object)serializer.apply(entry));
        }
        return resList;
    }
}

