/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tainted.template;

import com.direwolf20.buildinggadgets.common.tainted.building.tilesupport.ITileDataSerializer;
import com.direwolf20.buildinggadgets.common.tainted.building.tilesupport.ITileEntityData;
import com.direwolf20.buildinggadgets.common.tainted.building.tilesupport.NBTTileEntityData;
import com.direwolf20.buildinggadgets.common.tainted.building.tilesupport.TileSupport;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.MaterialList;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.objects.IUniqueObjectSerializer;
import com.direwolf20.buildinggadgets.common.tainted.registry.Registries;
import com.google.common.base.Preconditions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public final class SerialisationSupport {
    private SerialisationSupport() {
    }

    public static ITileDataSerializer dummyDataSerializer() {
        return (ITileDataSerializer)Registries.DUMMY_TILE_DATA_SERIALIZER.get();
    }

    public static NBTTileEntityDataSerializer createNbtSerializer() {
        return new NBTTileEntityDataSerializer();
    }

    public static DummyTileDataSerializer createDummySerializer() {
        return new DummyTileDataSerializer();
    }

    public static IUniqueObjectSerializer uniqueItemSerializer() {
        return (IUniqueObjectSerializer)Registries.UNIQUE_OBJECT_SERIALIZER.get();
    }

    public static final class NBTTileEntityDataSerializer
    implements ITileDataSerializer {
        private NBTTileEntityDataSerializer() {
        }

        @Override
        public CompoundTag serialize(ITileEntityData data, boolean persisted) {
            Preconditions.checkArgument((boolean)(data instanceof NBTTileEntityData));
            NBTTileEntityData nbtData = (NBTTileEntityData)data;
            CompoundTag res = new CompoundTag();
            res.m_128365_("data", (Tag)nbtData.getNBT());
            if (nbtData.getRequiredMaterials() != null) {
                res.m_128365_("materials", (Tag)nbtData.getRequiredMaterials().serialize(persisted));
            }
            return res;
        }

        @Override
        public ITileEntityData deserialize(CompoundTag tagCompound, boolean persisted) {
            CompoundTag data = tagCompound.m_128469_("data");
            MaterialList materialList = null;
            if (tagCompound.m_128425_("materials", 10)) {
                materialList = MaterialList.deserialize(tagCompound.m_128469_("materials"), persisted);
            }
            return new NBTTileEntityData(data, materialList);
        }
    }

    public static final class DummyTileDataSerializer
    implements ITileDataSerializer {
        private DummyTileDataSerializer() {
        }

        @Override
        public CompoundTag serialize(ITileEntityData data, boolean persisted) {
            return new CompoundTag();
        }

        @Override
        public ITileEntityData deserialize(CompoundTag tagCompound, boolean persisted) {
            return TileSupport.dummyTileEntityData();
        }
    }
}

