/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tainted.inventory.materials;

import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.MaterialListEntry;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.OrMaterialListEntry;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.SimpleMaterialListEntry;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.SubMaterialListEntry;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.objects.IUniqueObject;
import com.direwolf20.buildinggadgets.common.util.ref.NBTKeys;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

class AndMaterialListEntry
extends SubMaterialListEntry {
    static final MaterialListEntry.Serializer<SubMaterialListEntry> SERIALIZER = new SubMaterialListEntry.Serializer(NBTKeys.AND_SERIALIZER_ID){

        @Override
        protected SubMaterialListEntry create(ImmutableList<MaterialListEntry<?>> subEntries, ImmutableList<SimpleMaterialListEntry> constantEntries) {
            return new AndMaterialListEntry(subEntries, constantEntries);
        }
    };

    AndMaterialListEntry(ImmutableList<MaterialListEntry<?>> subEntries, ImmutableList<SimpleMaterialListEntry> simpleEntries, boolean simplified) {
        super(subEntries, simpleEntries, simplified);
    }

    AndMaterialListEntry(ImmutableList<MaterialListEntry<?>> subEntries, ImmutableList<SimpleMaterialListEntry> simpleEntries) {
        super(subEntries, simpleEntries);
    }

    AndMaterialListEntry(ImmutableList<MaterialListEntry<?>> subEntries) {
        super(subEntries);
    }

    @Override
    public PeekingIterator<ImmutableMultiset<IUniqueObject<?>>> iterator() {
        if (!this.getAllSubEntries().findFirst().isPresent()) {
            return Iterators.peekingIterator((Iterator)Iterators.singletonIterator((Object)ImmutableMultiset.of()));
        }
        final LinkedList list = this.getAllSubEntries().map(MaterialEntryWrapper::new).collect(Collectors.toCollection(LinkedList::new));
        return Iterators.peekingIterator((Iterator)new AbstractIterator<ImmutableMultiset<IUniqueObject<?>>>(){
            private Deque<MaterialEntryWrapper> dequeue;
            {
                this.dequeue = list;
            }

            protected ImmutableMultiset<IUniqueObject<?>> computeNext() {
                if (this.dequeue.isEmpty()) {
                    return (ImmutableMultiset)this.endOfData();
                }
                ImmutableMultiset.Builder builder = ImmutableMultiset.builder();
                for (MaterialEntryWrapper wrapper : this.dequeue) {
                    if (!wrapper.hasNext()) continue;
                    builder.addAll(wrapper.peek());
                }
                Iterator<MaterialEntryWrapper> revIt = this.dequeue.descendingIterator();
                MaterialEntryWrapper lastReset = null;
                while (revIt != null && revIt.hasNext()) {
                    MaterialEntryWrapper wrapper = revIt.next();
                    if (wrapper.hasNext()) {
                        wrapper.advance();
                        revIt = null;
                        continue;
                    }
                    wrapper.reset();
                    lastReset = wrapper;
                }
                if (lastReset == this.dequeue.getFirst()) {
                    this.dequeue.clear();
                }
                return builder.build();
            }
        });
    }

    @Override
    public MaterialListEntry.Serializer<SubMaterialListEntry> getSerializer() {
        return SERIALIZER;
    }

    @Override
    protected List<MaterialListEntry<?>> orderAndSimplifyEntries(List<OrMaterialListEntry> orEntries, List<AndMaterialListEntry> andEntries, List<SimpleMaterialListEntry> simpleEntries) {
        ArrayList remainder = new ArrayList();
        this.getSubEntries().forEach(entry -> {
            MaterialListEntry<?> simplified = entry.simplify();
            if (simplified instanceof AndMaterialListEntry) {
                simpleEntries.addAll((Collection<SimpleMaterialListEntry>)((SubMaterialListEntry)simplified).getConstantEntries());
                this.pullUpInnerEntries((AndMaterialListEntry)entry, orEntries, andEntries, simpleEntries, remainder);
            } else if (simplified instanceof OrMaterialListEntry) {
                simpleEntries.addAll((Collection<SimpleMaterialListEntry>)((SubMaterialListEntry)simplified).getConstantEntries());
                orEntries.add(new OrMaterialListEntry(((SubMaterialListEntry)simplified).getSubEntries(), (ImmutableList<SimpleMaterialListEntry>)ImmutableList.of()));
            } else if (simplified instanceof SimpleMaterialListEntry) {
                simpleEntries.add((SimpleMaterialListEntry)simplified);
            } else {
                remainder.add(simplified);
            }
        });
        return remainder;
    }

    @Override
    protected SubMaterialListEntry createFrom(ImmutableList<MaterialListEntry<?>> subEntries, ImmutableList<SimpleMaterialListEntry> constantEntry, boolean simplified) {
        return new AndMaterialListEntry(subEntries, constantEntry, simplified);
    }

    private static final class MaterialEntryWrapper {
        private PeekingIterator<ImmutableMultiset<IUniqueObject<?>>> curIterator;
        private final MaterialListEntry<?> entry;

        private MaterialEntryWrapper(MaterialListEntry<?> entry) {
            this.entry = entry;
            this.curIterator = entry.iterator();
        }

        private ImmutableMultiset<IUniqueObject<?>> peek() {
            return (ImmutableMultiset)this.curIterator.peek();
        }

        private boolean hasNext() {
            return this.curIterator.hasNext();
        }

        private void advance() {
            this.curIterator.next();
        }

        private void reset() {
            this.curIterator = this.entry.iterator();
        }
    }
}

