/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common;

import com.direwolf20.buildinggadgets.client.ClientProxy;
import com.direwolf20.buildinggadgets.client.OurSounds;
import com.direwolf20.buildinggadgets.common.blocks.OurBlocks;
import com.direwolf20.buildinggadgets.common.commands.ForceUnloadedCommand;
import com.direwolf20.buildinggadgets.common.commands.OverrideBuildSizeCommand;
import com.direwolf20.buildinggadgets.common.commands.OverrideCopySizeCommand;
import com.direwolf20.buildinggadgets.common.config.Config;
import com.direwolf20.buildinggadgets.common.config.RecipeConstructionPaste;
import com.direwolf20.buildinggadgets.common.containers.OurContainers;
import com.direwolf20.buildinggadgets.common.entities.OurEntities;
import com.direwolf20.buildinggadgets.common.items.OurItems;
import com.direwolf20.buildinggadgets.common.network.PacketHandler;
import com.direwolf20.buildinggadgets.common.tainted.inventory.InventoryHelper;
import com.direwolf20.buildinggadgets.common.tainted.registry.Registries;
import com.direwolf20.buildinggadgets.common.tainted.save.SaveManager;
import com.direwolf20.buildinggadgets.common.tainted.template.ITemplateKey;
import com.direwolf20.buildinggadgets.common.tainted.template.ITemplateProvider;
import com.direwolf20.buildinggadgets.common.tileentities.OurTileEntities;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import net.minecraft.commands.Commands;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Mod(value="buildinggadgets")
public final class BuildingGadgets {
    public static Logger LOG = LogManager.getLogger();
    private static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"buildinggadgets");
    public static RegistryObject<RecipeSerializer<?>> CONSTRUCTION_PASTE_RECIPE_SERIALIZER = RECIPE_SERIALIZER.register("construction_paste", () -> RecipeConstructionPaste.Serializer.INSTANCE);
    public static CreativeModeTab creativeTab = new CreativeModeTab("buildinggadgets"){

        @NotNull
        public ItemStack m_6976_() {
            ItemStack stack = new ItemStack((ItemLike)OurItems.BUILDING_GADGET_ITEM.get());
            stack.m_41784_().m_128344_("creative", (byte)0);
            return stack;
        }
    };

    public BuildingGadgets() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.SERVER_CONFIG);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Config.CLIENT_CONFIG);
        OurBlocks.BLOCKS.register(eventBus);
        OurItems.ITEMS.register(eventBus);
        OurTileEntities.TILE_ENTITIES.register(eventBus);
        OurContainers.CONTAINERS.register(eventBus);
        OurSounds.REGISTRY.register(eventBus);
        OurEntities.ENTITY_REGISTER.register(eventBus);
        RECIPE_SERIALIZER.register(eventBus);
        Registries.TILE_DATA_SERIALIZER_DEFERRED_REGISTER.register(eventBus);
        Registries.UNIQUE_OBJECT_SERIALIZER_DEFERRED_REGISTER.register(eventBus);
        MinecraftForge.EVENT_BUS.addListener(this::serverLoaded);
        MinecraftForge.EVENT_BUS.addListener(this::serverStopped);
        eventBus.addListener(this::setup);
        eventBus.addListener(this::clientSetup);
        eventBus.addListener(this::loadComplete);
        eventBus.addListener(this::handleIMC);
        eventBus.addListener(this::onEnqueueIMC);
        eventBus.addListener(this::registerCaps);
    }

    private void registerCaps(RegisterCapabilitiesEvent event) {
        event.register(ITemplateProvider.class);
        event.register(ITemplateKey.class);
    }

    private void clientSetup(FMLClientSetupEvent event) {
        ClientProxy.clientSetup();
    }

    private void setup(FMLCommonSetupEvent event) {
        PacketHandler.register();
    }

    private void loadComplete(FMLLoadCompleteEvent event) {
        Registries.createOrderedRegistries();
    }

    private void handleIMC(InterModProcessEvent event) {
        event.getIMCStream().forEach(this::handleIMCMessage);
    }

    private void handleIMCMessage(InterModComms.IMCMessage message) {
        if (Registries.handleIMC(message)) {
            LOG.trace("Successfully handled IMC-Message using Method {} from Mod {}.", (Object)message.getMethod(), (Object)message.getSenderModId());
        } else {
            LOG.warn("Failed to handle IMC-Message using Method {} from Mod {}!", (Object)message.getMethod(), (Object)message.getSenderModId());
        }
    }

    @SubscribeEvent
    public void commandRegister(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"buildinggadgets").then(OverrideBuildSizeCommand.registerToggle())).then(OverrideCopySizeCommand.registerToggle())).then(ForceUnloadedCommand.registerToggle())).then(OverrideBuildSizeCommand.registerList())).then(OverrideCopySizeCommand.registerList())).then(ForceUnloadedCommand.registerList()));
    }

    private void serverLoaded(ServerStartedEvent event) {
        SaveManager.INSTANCE.onServerStarted(event);
    }

    private void serverStopped(ServerStoppedEvent event) {
        SaveManager.INSTANCE.onServerStopped(event);
    }

    private void onEnqueueIMC(InterModEnqueueEvent event) {
        InventoryHelper.registerHandleProviders();
    }
}

