/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutilities.features.filters;

import java.util.function.Predicate;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class Filters {
    public static final Predicate<Entity> PLAYER = e -> e instanceof Player;
    public static final Predicate<Entity> UNDEAD = Filters.attributeFilter(MobType.f_21641_);
    public static final Predicate<Entity> ARTHROPOD = Filters.attributeFilter(MobType.f_21642_);
    public static final Predicate<Entity> ILLAGER = Filters.attributeFilter(MobType.f_21643_);
    public static final Predicate<Entity> RAIDER = Filters.tagFilter(EntityTypeTags.f_13121_);
    public static final Predicate<Entity> HOSTILE = e -> e instanceof Enemy;
    public static final Predicate<Entity> ANIMAL = e -> e instanceof Animal;
    public static final Predicate<Entity> BABY = e -> {
        AgeableMob ageable;
        return e instanceof AgeableMob && (ageable = (AgeableMob)e).m_6162_();
    };
    public static final Predicate<Entity> PET = e -> e instanceof TamableAnimal;
    public static final Predicate<Entity> SLIME = e -> e instanceof Slime;
    public static final Predicate<Entity> BOSS = null;
    public static final Predicate<Entity> VILLAGER = e -> e instanceof AbstractVillager;
    public static final Predicate<Entity> FIRE_IMMUNE = e -> {
        LivingEntity living;
        return e instanceof LivingEntity && ((living = (LivingEntity)e).m_5825_() || living.m_21023_(MobEffects.f_19607_));
    };
    public static final Predicate<Entity> GOLEM = e -> e instanceof AbstractGolem;
    public static final Predicate<Entity> WATER = e -> {
        LivingEntity living;
        return e instanceof WaterAnimal || e instanceof LivingEntity && (living = (LivingEntity)e).m_6336_() == MobType.f_21644_ || e instanceof Drowned || e instanceof Frog;
    };
    public static final Predicate<Entity> NAMED = Entity::m_8077_;
    public static final Predicate<Entity> FREEZE_IMMUNE = Filters.tagFilter(EntityTypeTags.f_144294_);
    public static final Predicate<Entity> EQUIPMENT = Filters.hasEquipment();
    public static final Predicate<Entity> PASSENGER = e -> e.m_20159_() || !e.m_20197_().isEmpty();

    private static Predicate<Entity> attributeFilter(MobType type) {
        return e -> {
            LivingEntity living;
            return e instanceof LivingEntity && (living = (LivingEntity)e).m_6336_() == type;
        };
    }

    private static Predicate<Entity> tagFilter(TagKey<EntityType<?>> tag) {
        return e -> e.m_6095_().m_204039_(tag);
    }

    private static Predicate<Entity> hasEquipment() {
        return e -> {
            for (ItemStack armor : e.m_6168_()) {
                if (armor.m_41619_()) continue;
                return true;
            }
            for (ItemStack held : e.m_6167_()) {
                if (held.m_41619_()) continue;
                return true;
            }
            return false;
        };
    }
}

