/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mekanism.api.Action;
import mekanism.api.inventory.IInventorySlot;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StackUtils {
    private StackUtils() {
    }

    public static ItemStack size(ItemStack stack, int size) {
        if (size <= 0 || stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size);
    }

    public static List<ItemStack> merge(@NotNull List<IInventorySlot> orig, @NotNull List<IInventorySlot> toAdd) {
        ArrayList<ItemStack> rejects = new ArrayList<ItemStack>();
        StackUtils.merge(orig, toAdd, rejects);
        return rejects;
    }

    public static void merge(@NotNull List<IInventorySlot> orig, @NotNull List<IInventorySlot> toAdd, List<ItemStack> rejects) {
        if (orig.size() != toAdd.size()) {
            throw new IllegalArgumentException("Mismatched slot count");
        }
        for (int i = 0; i < toAdd.size(); ++i) {
            IInventorySlot toAddSlot = toAdd.get(i);
            if (toAddSlot.isEmpty()) continue;
            IInventorySlot origSlot = orig.get(i);
            ItemStack toAddStack = toAddSlot.getStack();
            if (origSlot.isEmpty()) {
                int max = origSlot.getLimit(toAddStack);
                if (toAddStack.m_41613_() <= max) {
                    origSlot.setStack(toAddStack);
                    continue;
                }
                origSlot.setStack(StackUtils.size(toAddStack, max));
                StackUtils.addStack(rejects, StackUtils.size(toAddStack, toAddStack.m_41613_() - max));
                continue;
            }
            if (ItemHandlerHelper.canItemStacksStack((ItemStack)origSlot.getStack(), (ItemStack)toAddStack)) {
                int added = origSlot.growStack(toAddStack.m_41613_(), Action.EXECUTE);
                StackUtils.addStack(rejects, StackUtils.size(toAddStack, toAddStack.m_41613_() - added));
                continue;
            }
            StackUtils.addStack(rejects, toAddStack.m_41777_());
        }
    }

    private static void addStack(List<ItemStack> stacks, ItemStack stack) {
        if (!stack.m_41619_()) {
            for (ItemStack existingStack : stacks) {
                int needed = existingStack.m_41741_() - existingStack.m_41613_();
                if (needed <= 0 || !ItemHandlerHelper.canItemStacksStack((ItemStack)existingStack, (ItemStack)stack)) continue;
                int toAdd = Math.min(needed, stack.m_41613_());
                existingStack.m_41769_(toAdd);
                stack.m_41774_(toAdd);
                break;
            }
            if (!stack.m_41619_()) {
                int max;
                int count = stack.m_41613_();
                if (count > (max = stack.m_41741_())) {
                    int excess = count % max;
                    int stacksToAdd = count / max;
                    if (excess > 0) {
                        stacks.add(StackUtils.size(stack, excess));
                    }
                    ItemStack maxSize = StackUtils.size(stack, max);
                    stacks.add(maxSize);
                    for (int i = 1; i < stacksToAdd; ++i) {
                        stacks.add(maxSize.m_41777_());
                    }
                } else {
                    stacks.add(stack);
                }
            }
        }
    }

    private static List<ItemStack> flatten(List<ItemStack> stacks) {
        if (stacks.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ItemStack> compacted = new ArrayList<ItemStack>();
        for (ItemStack stack : stacks) {
            int max;
            if (stack.m_41619_()) continue;
            int count = stack.m_41613_();
            if (count > (max = stack.m_41741_())) {
                while (count > max) {
                    compacted.add(StackUtils.size(stack, max));
                    count -= max;
                }
                if (count <= 0) continue;
                compacted.add(StackUtils.size(stack, count));
                continue;
            }
            compacted.add(stack);
        }
        for (int i = 0; i < stacks.size(); ++i) {
            ItemStack s = stacks.get(i);
            if (s.m_41619_()) continue;
            for (int j = i + 1; j < stacks.size(); ++j) {
                ItemStack s1 = stacks.get(j);
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)s, (ItemStack)s1)) continue;
                s.m_41769_(s1.m_41613_());
                stacks.set(j, ItemStack.f_41583_);
            }
        }
        return compacted;
    }

    @Nullable
    public static BlockState getStateForPlacement(ItemStack stack, BlockPos pos, Player player) {
        return Block.m_49814_((Item)stack.m_41720_()).m_5573_(new BlockPlaceContext(new UseOnContext(player, InteractionHand.MAIN_HAND, new BlockHitResult(Vec3.f_82478_, Direction.UP, pos, false))));
    }
}

