/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.registration.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import mekanism.common.Mekanism;
import mekanism.common.base.IChemicalConstant;
import mekanism.common.registration.impl.FluidRegistryObject;
import mekanism.common.registration.impl.ItemDeferredRegister;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.DispensibleContainerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidDeferredRegister {
    private static final ResourceLocation OVERLAY = new ResourceLocation("block/water_overlay");
    private static final ResourceLocation RENDER_OVERLAY = new ResourceLocation("textures/misc/underwater.png");
    private static final ResourceLocation LIQUID = Mekanism.rl("liquid/liquid");
    private static final ResourceLocation LIQUID_FLOW = Mekanism.rl("liquid/liquid_flow");
    private static final DispenseItemBehavior BUCKET_DISPENSE_BEHAVIOR = new DefaultDispenseItemBehavior(){

        @NotNull
        public ItemStack m_7498_(@NotNull BlockSource source, @NotNull ItemStack stack) {
            BlockPos pos;
            ServerLevel world = source.m_7727_();
            DispensibleContainerItem bucket = (DispensibleContainerItem)stack.m_41720_();
            if (bucket.m_142073_(null, (Level)world, pos = source.m_7961_().m_121945_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_)), null)) {
                bucket.m_142131_(null, (Level)world, stack, pos);
                return new ItemStack((ItemLike)Items.f_42446_);
            }
            return super.m_7498_(source, stack);
        }
    };
    private final List<FluidRegistryObject<? extends MekanismFluidType, ?, ?, ?, ?>> allFluids = new ArrayList();
    private final DeferredRegister<FluidType> fluidTypeRegister;
    private final DeferredRegister<Fluid> fluidRegister;
    private final DeferredRegister<Block> blockRegister;
    private final DeferredRegister<Item> itemRegister;
    private final String modid;

    public static FluidType.Properties getMekBaseBuilder() {
        return FluidType.Properties.create().sound(SoundActions.BUCKET_FILL, SoundEvents.f_11781_).sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11778_);
    }

    public FluidDeferredRegister(String modid) {
        this.modid = modid;
        this.blockRegister = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)modid);
        this.fluidRegister = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FLUIDS, (String)modid);
        this.fluidTypeRegister = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.FLUID_TYPES, (String)modid);
        this.itemRegister = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)modid);
    }

    public FluidRegistryObject<MekanismFluidType, ForgeFlowingFluid.Source, ForgeFlowingFluid.Flowing, LiquidBlock, BucketItem> registerLiquidChemical(IChemicalConstant constants) {
        int density = Math.round(constants.getDensity());
        return this.register(constants.getName(), properties -> properties.temperature(Math.round(constants.getTemperature())).density(density).viscosity(density).lightLevel(constants.getLightLevel()), renderProperties -> renderProperties.tint(constants.getColor()));
    }

    public FluidRegistryObject<MekanismFluidType, ForgeFlowingFluid.Source, ForgeFlowingFluid.Flowing, LiquidBlock, BucketItem> register(String name, UnaryOperator<FluidTypeRenderProperties> renderProperties) {
        return this.register(name, UnaryOperator.identity(), renderProperties);
    }

    public FluidRegistryObject<MekanismFluidType, ForgeFlowingFluid.Source, ForgeFlowingFluid.Flowing, LiquidBlock, BucketItem> register(String name, UnaryOperator<FluidType.Properties> properties, UnaryOperator<FluidTypeRenderProperties> renderProperties) {
        return this.register(name, BucketItem::new, properties, renderProperties);
    }

    public <BUCKET extends BucketItem> FluidRegistryObject<MekanismFluidType, ForgeFlowingFluid.Source, ForgeFlowingFluid.Flowing, LiquidBlock, BUCKET> register(String name, BucketCreator<BUCKET> bucketCreator, UnaryOperator<FluidType.Properties> fluidProperties, UnaryOperator<FluidTypeRenderProperties> renderProperties) {
        return this.register(name, (FluidType.Properties)fluidProperties.apply(FluidDeferredRegister.getMekBaseBuilder()), (FluidTypeRenderProperties)renderProperties.apply(FluidTypeRenderProperties.builder()), bucketCreator, MekanismFluidType::new);
    }

    public <TYPE extends MekanismFluidType, BUCKET extends BucketItem> FluidRegistryObject<TYPE, ForgeFlowingFluid.Source, ForgeFlowingFluid.Flowing, LiquidBlock, BUCKET> register(String name, FluidType.Properties properties, FluidTypeRenderProperties renderProperties, BucketCreator<BUCKET> bucketCreator, BiFunction<FluidType.Properties, FluidTypeRenderProperties, TYPE> fluidTypeCreator) {
        String flowingName = "flowing_" + name;
        String bucketName = name + "_bucket";
        properties.descriptionId(Util.m_137492_((String)"block", (ResourceLocation)new ResourceLocation(this.modid, name)));
        FluidRegistryObject fluidRegistryObject = new FluidRegistryObject();
        ForgeFlowingFluid.Properties fluidProperties = new ForgeFlowingFluid.Properties(fluidRegistryObject::getFluidType, fluidRegistryObject::getStillFluid, fluidRegistryObject::getFlowingFluid).bucket(fluidRegistryObject::getBucket).block(fluidRegistryObject::getBlock);
        fluidRegistryObject.updateFluidType(this.fluidTypeRegister.register(name, () -> (MekanismFluidType)((Object)((Object)fluidTypeCreator.apply(properties, renderProperties)))));
        fluidRegistryObject.updateStill(this.fluidRegister.register(name, () -> new ForgeFlowingFluid.Source(fluidProperties)));
        fluidRegistryObject.updateFlowing(this.fluidRegister.register(flowingName, () -> new ForgeFlowingFluid.Flowing(fluidProperties)));
        fluidRegistryObject.updateBucket(this.itemRegister.register(bucketName, () -> bucketCreator.create(fluidRegistryObject::getStillFluid, ItemDeferredRegister.getMekBaseProperties().m_41487_(1).m_41495_(Items.f_42446_))));
        fluidRegistryObject.updateBlock(this.blockRegister.register(name, () -> new LiquidBlock(fluidRegistryObject::getStillFluid, BlockBehaviour.Properties.m_60939_((Material)Material.f_76305_).m_60910_().m_60978_(100.0f).m_222994_())));
        this.allFluids.add(fluidRegistryObject);
        return fluidRegistryObject;
    }

    public void register(IEventBus bus) {
        this.blockRegister.register(bus);
        this.fluidRegister.register(bus);
        this.fluidTypeRegister.register(bus);
        this.itemRegister.register(bus);
    }

    public List<FluidRegistryObject<? extends MekanismFluidType, ?, ?, ?, ?>> getAllFluids() {
        return Collections.unmodifiableList(this.allFluids);
    }

    public void registerBucketDispenserBehavior() {
        for (FluidRegistryObject<MekanismFluidType, ?, ?, ?, ?> fluidRO : this.getAllFluids()) {
            DispenserBlock.m_52672_(fluidRO.getBucket(), (DispenseItemBehavior)BUCKET_DISPENSE_BEHAVIOR);
        }
    }

    @FunctionalInterface
    public static interface BucketCreator<BUCKET extends BucketItem> {
        public BUCKET create(Supplier<? extends Fluid> var1, Item.Properties var2);
    }

    public static class FluidTypeRenderProperties {
        private ResourceLocation stillTexture = LIQUID;
        private ResourceLocation flowingTexture = LIQUID_FLOW;
        private ResourceLocation overlayTexture = OVERLAY;
        private ResourceLocation renderOverlayTexture = RENDER_OVERLAY;
        private int color = -1;

        private FluidTypeRenderProperties() {
        }

        public static FluidTypeRenderProperties builder() {
            return new FluidTypeRenderProperties();
        }

        public FluidTypeRenderProperties texture(ResourceLocation still, ResourceLocation flowing) {
            this.stillTexture = still;
            this.flowingTexture = flowing;
            return this;
        }

        public FluidTypeRenderProperties texture(ResourceLocation still, ResourceLocation flowing, ResourceLocation overlay) {
            this.stillTexture = still;
            this.flowingTexture = flowing;
            this.overlayTexture = overlay;
            return this;
        }

        public FluidTypeRenderProperties renderOverlay(ResourceLocation renderOverlay) {
            this.renderOverlayTexture = renderOverlay;
            return this;
        }

        public FluidTypeRenderProperties tint(int color) {
            this.color = color;
            return this;
        }
    }

    public static class MekanismFluidType
    extends FluidType {
        private final ResourceLocation stillTexture;
        private final ResourceLocation flowingTexture;
        private final ResourceLocation overlayTexture;
        private final ResourceLocation renderOverlayTexture;
        private final int color;

        public MekanismFluidType(FluidType.Properties properties, FluidTypeRenderProperties renderProperties) {
            super(properties);
            this.stillTexture = renderProperties.stillTexture;
            this.flowingTexture = renderProperties.flowingTexture;
            this.overlayTexture = renderProperties.overlayTexture;
            this.renderOverlayTexture = renderProperties.renderOverlayTexture;
            this.color = renderProperties.color;
        }

        public ResourceLocation getStillTexture() {
            return this.stillTexture;
        }

        public boolean isVaporizedOnPlacement(Level level, BlockPos pos, FluidStack stack) {
            return false;
        }

        public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
            consumer.accept(new IClientFluidTypeExtensions(){

                public ResourceLocation getStillTexture() {
                    return stillTexture;
                }

                public ResourceLocation getFlowingTexture() {
                    return flowingTexture;
                }

                public ResourceLocation getOverlayTexture() {
                    return overlayTexture;
                }

                @Nullable
                public ResourceLocation getRenderOverlayTexture(Minecraft mc) {
                    return renderOverlayTexture;
                }

                public int getTintColor() {
                    return color;
                }
            });
        }
    }
}

