/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_server;

import javax.annotation.Nullable;
import mekanism.common.content.filter.BaseFilter;
import mekanism.common.content.filter.IFilter;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.tile.interfaces.ITileFilterHolder;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class PacketEditFilter<FILTER extends IFilter<FILTER>>
implements IMekanismPacket {
    private static final PacketEditFilter<?> ERROR = new PacketEditFilter<Object>(BlockPos.f_121853_, null, null);
    private final FILTER filter;
    @Nullable
    private final FILTER edited;
    private final BlockPos pos;

    public PacketEditFilter(BlockPos pos, FILTER filter, @Nullable FILTER edited) {
        this.pos = pos;
        this.filter = filter;
        this.edited = edited;
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        ServerPlayer player = context.getSender();
        if (player == null || this.filter == null) {
            return;
        }
        BlockEntity tile = WorldUtils.getTileEntity((BlockGetter)player.f_19853_, this.pos);
        if (tile instanceof ITileFilterHolder) {
            ITileFilterHolder filterHolder = (ITileFilterHolder)tile;
            filterHolder.getFilterManager().tryEditFilter(this.filter, this.edited);
        }
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        this.filter.write(buffer);
        if (this.edited == null) {
            buffer.writeBoolean(false);
        } else {
            buffer.writeBoolean(true);
            this.edited.write(buffer);
        }
    }

    public static <FILTER extends IFilter<FILTER>> PacketEditFilter<?> decode(FriendlyByteBuf buffer) {
        BlockPos pos = buffer.m_130135_();
        IFilter<?> filter = BaseFilter.readFromPacket(buffer);
        IFilter<?> edited = null;
        if (buffer.readBoolean() && (edited = BaseFilter.readFromPacket(buffer)).getFilterType() != filter.getFilterType()) {
            return ERROR;
        }
        return new PacketEditFilter(pos, filter, edited);
    }
}

