/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.lookingat.jade;

import com.mojang.blaze3d.vertex.PoseStack;
import mekanism.common.integration.lookingat.LookingAtElement;
import mekanism.common.integration.lookingat.LookingAtUtils;
import mekanism.common.integration.lookingat.jade.JadeConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.Accessor;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.Element;

public class JadeTooltipRenderer
implements IBlockComponentProvider,
IEntityComponentProvider {
    static final JadeTooltipRenderer INSTANCE = new JadeTooltipRenderer();

    public ResourceLocation getUid() {
        return JadeConstants.TOOLTIP_RENDERER;
    }

    public void appendTooltip(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
        this.append(tooltip, (Accessor<?>)accessor, config);
    }

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        this.append(tooltip, (Accessor<?>)accessor, config);
    }

    private void append(ITooltip tooltip, Accessor<?> accessor, IPluginConfig config) {
        LookingAtUtils.appendHwylaTooltip(accessor.getServerData(), arg_0 -> ((ITooltip)tooltip).add(arg_0), (lastText, element, name) -> {
            if (config.get(name)) {
                tooltip.add(new MekElement((Component)lastText, (LookingAtElement)element).tag((ResourceLocation)name));
            }
        });
    }

    private static class MekElement
    extends Element {
        @Nullable
        private final Component text;
        private final LookingAtElement element;

        public MekElement(@Nullable Component text, LookingAtElement element) {
            this.element = element;
            this.text = text;
        }

        public Vec2 getSize() {
            int width = this.element.getWidth();
            int height = this.element.getHeight() + 2;
            if (this.text != null) {
                width = Math.max(width, 96);
                height += 14;
            }
            return new Vec2((float)width, (float)height);
        }

        public void render(PoseStack poseStack, float x, float y, float maxX, float maxY) {
            if (this.text != null) {
                LookingAtElement.renderScaledText(Minecraft.m_91087_(), poseStack, x + 4.0f, y + 3.0f, 0xFFFFFF, 92.0f, this.text);
                y += 13.0f;
            }
            poseStack.m_85836_();
            poseStack.m_85837_((double)x, (double)y, 0.0);
            this.element.render(poseStack, 0, 1);
            poseStack.m_85849_();
        }
    }
}

