/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.chemical.attribute.gas;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker_annotations.annotations.NativeTypeRegistration;
import java.util.function.Supplier;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.attribute.GasAttributes;
import mekanism.api.providers.IGasProvider;
import org.jetbrains.annotations.NotNull;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@NativeTypeRegistration(value=GasAttributes.Coolant.class, zenCodeName="mods.mekanism.attribute.gas.CoolantAttribute")
public class CrTCoolantAttribute {
    private CrTCoolantAttribute() {
    }

    @ZenCodeType.StaticExpansionMethod
    public static GasAttributes.CooledCoolant cooled(Supplier<Gas> heatedGas, double thermalEnthalpy, double conductivity) {
        CrTCoolantAttribute.validateEnthalpyAndConductivity(thermalEnthalpy, conductivity);
        return new GasAttributes.CooledCoolant(new CachingCrTGasProvider(heatedGas), thermalEnthalpy, conductivity);
    }

    @ZenCodeType.StaticExpansionMethod
    public static GasAttributes.HeatedCoolant heated(Supplier<Gas> cooledGas, double thermalEnthalpy, double conductivity) {
        CrTCoolantAttribute.validateEnthalpyAndConductivity(thermalEnthalpy, conductivity);
        return new GasAttributes.HeatedCoolant(new CachingCrTGasProvider(cooledGas), thermalEnthalpy, conductivity);
    }

    private static void validateEnthalpyAndConductivity(double thermalEnthalpy, double conductivity) {
        if (thermalEnthalpy <= 0.0) {
            throw new IllegalArgumentException("Coolant attributes must have a thermal enthalpy greater than zero! Thermal Enthalpy: " + thermalEnthalpy);
        }
        if (conductivity <= 0.0 || conductivity > 1.0) {
            throw new IllegalArgumentException("Coolant attributes must have a conductivity greater than zero and at most one! Conductivity: " + conductivity);
        }
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="thermalEnthalpy")
    public static double getThermalEnthalpy(GasAttributes.Coolant _this) {
        return _this.getThermalEnthalpy();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="conductivity")
    public static double getConductivity(GasAttributes.Coolant _this) {
        return _this.getConductivity();
    }

    private static class CachingCrTGasProvider
    implements IGasProvider {
        private Supplier<Gas> gasSupplier;
        private Gas gas = MekanismAPI.EMPTY_GAS;

        private CachingCrTGasProvider(Supplier<Gas> gasSupplier) {
            this.gasSupplier = gasSupplier;
        }

        @Override
        @NotNull
        public Gas getChemical() {
            if (this.gas.isEmptyType()) {
                this.gas = (Gas)this.gasSupplier.get().getChemical();
                if (this.gas.isEmptyType()) {
                    throw new IllegalStateException("Empty gas used for coolant attribute via a CraftTweaker Script.");
                }
                this.gasSupplier = null;
            }
            return this.gas;
        }
    }

    @ZenRegister
    @NativeTypeRegistration(value=GasAttributes.HeatedCoolant.class, zenCodeName="mods.mekanism.attribute.gas.HeatedCoolantAttribute")
    public static class CrTHeatedCoolantAttribute {
        private CrTHeatedCoolantAttribute() {
        }

        @ZenCodeType.Method
        public static Gas getCooledGas(GasAttributes.HeatedCoolant _this) {
            return _this.getCooledGas();
        }
    }

    @ZenRegister
    @NativeTypeRegistration(value=GasAttributes.CooledCoolant.class, zenCodeName="mods.mekanism.attribute.gas.CooledCoolantAttribute")
    public static class CrTCooledCoolantAttribute {
        private CrTCooledCoolantAttribute() {
        }

        @ZenCodeType.Method
        public static Gas getHeatedGas(GasAttributes.CooledCoolant _this) {
            return _this.getHeatedGas();
        }
    }
}

