/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.config;

import mekanism.common.config.BaseMekanismConfig;
import mekanism.common.config.IMekanismConfig;
import mekanism.common.config.value.CachedBooleanValue;
import mekanism.common.config.value.CachedEnumValue;
import mekanism.common.util.UnitDisplayUtils;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class CommonConfig
extends BaseMekanismConfig {
    private final ForgeConfigSpec configSpec;
    public final CachedEnumValue<UnitDisplayUtils.EnergyUnit> energyUnit;
    public final CachedEnumValue<UnitDisplayUtils.TemperatureUnit> tempUnit;
    public final CachedBooleanValue enableDecayTimers;

    CommonConfig() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment("Mekanism Common Config. This config is not synced between server and client.").push("common");
        this.energyUnit = CachedEnumValue.wrap((IMekanismConfig)this, builder.comment("Displayed energy type in Mekanism GUIs and network reader readings.").defineEnum("energyType", (Enum)UnitDisplayUtils.EnergyUnit.FORGE_ENERGY));
        this.tempUnit = CachedEnumValue.wrap((IMekanismConfig)this, builder.comment("Displayed temperature unit in Mekanism GUIs and network reader readings.").defineEnum("temperatureUnit", (Enum)UnitDisplayUtils.TemperatureUnit.KELVIN));
        this.enableDecayTimers = CachedBooleanValue.wrap(this, (ForgeConfigSpec.ConfigValue<Boolean>)builder.comment("Show time to decay radiation when readings are above safe levels. Set to false on the client side to disable MekaSuit Geiger and Dosimeter Unit timers. Set to false on the server side to disable handheld Geiger Counter and Dosimeter timers.").define("enableDecayTimers", true));
        builder.pop();
        this.configSpec = builder.build();
    }

    @Override
    public String getFileName() {
        return "common";
    }

    @Override
    public ForgeConfigSpec getConfigSpec() {
        return this.configSpec;
    }

    @Override
    public ModConfig.Type getConfigType() {
        return ModConfig.Type.COMMON;
    }
}

