/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block.attribute;

import java.util.Objects;
import java.util.UUID;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.lib.multiblock.IInternalMultiblock;
import mekanism.common.lib.multiblock.IMultiblock;
import mekanism.common.lib.multiblock.IStructuralMultiblock;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.lib.multiblock.Structure;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class AttributeMultiblock
implements Attribute {
    public static final Attribute EXTERNAL = new AttributeMultiblock(MultiblockType.EXTERNAL);
    public static final Attribute STRUCTURAL = new AttributeMultiblock(MultiblockType.STRUCTURAL);
    public static final Attribute INTERNAL = new AttributeMultiblock(MultiblockType.INTERNAL);
    private final MultiblockType type;

    private AttributeMultiblock(MultiblockType type) {
        this.type = type;
    }

    @Nullable
    public MultiblockData getMultiblock(Level level, BlockPos pos, UUID uuid) {
        BlockEntity tile = WorldUtils.getTileEntity((BlockGetter)level, pos);
        switch (this.type) {
            case EXTERNAL: {
                if (!(tile instanceof IMultiblock)) break;
                IMultiblock multiblockTile = (IMultiblock)tile;
                Object multiblock = multiblockTile.getMultiblock();
                if (!Objects.equals(((MultiblockData)multiblock).inventoryID, uuid)) break;
                return multiblock;
            }
            case STRUCTURAL: {
                IStructuralMultiblock structuralMultiblock;
                if (!(tile instanceof IStructuralMultiblock) || !(structuralMultiblock = (IStructuralMultiblock)tile).hasFormedMultiblock()) break;
                for (Structure structure : structuralMultiblock.getStructureMap().values()) {
                    MultiblockData data = structure.getMultiblockData();
                    if (data == null || !data.isFormed() || !Objects.equals(data.inventoryID, uuid)) continue;
                    return data;
                }
                break;
            }
            case INTERNAL: {
                IInternalMultiblock internal;
                if (!(tile instanceof IInternalMultiblock) || !Objects.equals((internal = (IInternalMultiblock)tile).getMultiblockUUID(), uuid)) break;
                return internal.getMultiblock();
            }
        }
        return null;
    }

    private static enum MultiblockType {
        EXTERNAL,
        STRUCTURAL,
        INTERNAL;

    }
}

