/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.model.robit;

import java.util.List;
import java.util.function.BiPredicate;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.robit.RobitSkin;
import mekanism.client.RobitSpriteUploader;
import mekanism.client.model.MekanismModelCache;
import mekanism.client.model.baked.ExtensionBakedModel;
import mekanism.client.model.baked.ExtensionOverrideBakedModel;
import mekanism.client.model.robit.RobitModelDataBakedModel;
import mekanism.client.render.lib.QuadTransformation;
import mekanism.client.render.lib.QuadUtils;
import mekanism.common.entity.EntityRobit;
import mekanism.common.item.ItemRobit;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class RobitBakedModel
extends ExtensionOverrideBakedModel<ResourceLocation> {
    private static final BiPredicate<ResourceLocation, ResourceLocation> DATA_EQUALITY_CHECK = ResourceLocation::equals;

    public RobitBakedModel(BakedModel original) {
        super(original, RobitItemOverrideList::new);
    }

    @Override
    public List<BakedQuad> createQuads(ExtensionBakedModel.QuadsKey<ResourceLocation> key) {
        List<BakedQuad> quads = key.getQuads();
        if (RobitSpriteUploader.UPLOADER != null) {
            ResourceLocation selectedTexture = key.getData();
            QuadTransformation transformation = QuadTransformation.texture(RobitSpriteUploader.UPLOADER.m_118901_(selectedTexture));
            transformation = QuadTransformation.TextureFilteredTransformation.of(transformation, rl -> rl.m_135815_().equals("missingno"));
            quads = QuadUtils.transformBakedQuads(quads, transformation);
        }
        return quads;
    }

    @Override
    @Nullable
    public ExtensionBakedModel.QuadsKey<ResourceLocation> createKey(ExtensionBakedModel.QuadsKey<ResourceLocation> key, ModelData data) {
        ResourceLocation skinTexture = (ResourceLocation)data.get(EntityRobit.SKIN_TEXTURE_PROPERTY);
        if (skinTexture == null) {
            return null;
        }
        return key.data(skinTexture, skinTexture.hashCode(), DATA_EQUALITY_CHECK);
    }

    protected RobitBakedModel wrapModel(BakedModel model) {
        return new RobitBakedModel(model);
    }

    private static class RobitItemOverrideList
    extends ExtensionOverrideBakedModel.ExtendedItemOverrides {
        RobitItemOverrideList(ItemOverrides original) {
            super(original);
        }

        @Override
        @Nullable
        public BakedModel m_173464_(BakedModel model, ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity entity, int seed) {
            Item item;
            if (!stack.m_41619_() && (item = stack.m_41720_()) instanceof ItemRobit) {
                BakedModel customModel;
                ItemRobit robit = (ItemRobit)item;
                RobitSkin skin = robit.getRobitSkin(stack).getSkin();
                if (skin.getCustomModel() != null && (customModel = MekanismModelCache.INSTANCE.getRobitSkin(skin)) != null && customModel != model) {
                    return customModel.m_7343_().m_173464_(customModel, stack, world, entity, seed);
                }
                List<ResourceLocation> textures = skin.getTextures();
                if (!textures.isEmpty()) {
                    ModelData modelData = ModelData.builder().with(EntityRobit.SKIN_TEXTURE_PROPERTY, (Object)textures.get(0)).build();
                    return this.wrap(model, stack, world, entity, seed, modelData, RobitModelDataBakedModel::new);
                }
            }
            return this.original.m_173464_(model, stack, world, entity, seed);
        }
    }
}

