/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.window;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.GuiUtils;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiElementHolder;
import mekanism.client.gui.element.button.TranslationButton;
import mekanism.client.gui.element.custom.GuiEntityPreview;
import mekanism.client.gui.element.text.BackgroundType;
import mekanism.client.gui.element.text.GuiTextField;
import mekanism.client.gui.element.window.GuiWindow;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.SelectedWindowData;
import mekanism.common.lib.Color;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.text.InputValidator;
import mekanism.common.util.text.TextUtils;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiColorWindow
extends GuiWindow {
    public static final ResourceLocation TRANSPARENCY_GRID = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "transparency_grid.png");
    private static final ResourceLocation HUE_PICKER = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "color_picker.png");
    private static final int S_TILES = 10;
    private static final int V_TILES = 10;
    private final GuiTextField textField;
    private final boolean handlesAlpha;
    @Nullable
    private final Consumer<Color> updatePreviewColor;
    @Nullable
    private final Runnable previewReset;
    private float hue;
    private float saturation = 0.5f;
    private float value = 0.5f;
    private float alpha = 1.0f;

    public GuiColorWindow(IGuiWrapper gui, int x, int y, boolean handlesAlpha, Consumer<Color> callback) {
        this(gui, x, y, handlesAlpha, callback, null, null, null);
    }

    public GuiColorWindow(IGuiWrapper gui, int x, int y, boolean handlesAlpha, Consumer<Color> callback, @Nullable Supplier<LivingEntity> armorPreview, @Nullable Consumer<Color> updatePreviewColor, @Nullable Runnable previewReset) {
        super(gui, x, y, (handlesAlpha ? 184 : 158) + (armorPreview == null ? 0 : 83), handlesAlpha ? 152 : 140, SelectedWindowData.WindowType.COLOR);
        this.interactionStrategy = GuiWindow.InteractionStrategy.NONE;
        this.handlesAlpha = handlesAlpha;
        this.updatePreviewColor = updatePreviewColor;
        this.previewReset = previewReset;
        int extraWidth = this.handlesAlpha ? 26 : 0;
        int extraShadeWidth = this.handlesAlpha ? 20 : 0;
        int extraViewWidth = extraWidth - extraShadeWidth;
        this.addChild(new GuiElementHolder(gui, this.relativeX + 6, this.relativeY + 17, 41 + extraViewWidth, 82));
        this.addChild(new GuiColorView(gui, this.relativeX + 7, this.relativeY + 18, 39 + extraViewWidth, 80));
        this.addChild(new GuiElementHolder(gui, this.relativeX + 50 + extraViewWidth, this.relativeY + 17, 102 + extraShadeWidth, 82));
        this.addChild(new GuiShadePicker(gui, this.relativeX + 51 + extraViewWidth, this.relativeY + 18, 100 + extraShadeWidth, 80));
        this.addChild(new GuiElementHolder(gui, this.relativeX + 6, this.relativeY + 103, 146 + extraWidth, 10));
        this.addChild(new GuiHuePicker(gui, this.relativeX + 7, this.relativeY + 104, 144 + extraWidth, 8));
        if (this.handlesAlpha) {
            this.addChild(new GuiElementHolder(gui, this.relativeX + 6, this.relativeY + 115, 146 + extraWidth, 10));
            this.addChild(new GuiAlphaPicker(gui, this.relativeX + 7, this.relativeY + 116, 144 + extraWidth, 8));
        }
        int textOffset = this.handlesAlpha ? 6 : 0;
        this.textField = this.addChild(new GuiTextField(gui, this.relativeX + 30 + textOffset, this.relativeY + this.getButtonHeight() - 20, 63 + extraWidth - textOffset, 12));
        this.textField.setInputValidator(InputValidator.DIGIT.or(c -> c == ',')).setPasteTransformer(text -> text.replace(" ", "")).setBackground(BackgroundType.ELEMENT_HOLDER).setMaxLength(this.handlesAlpha ? 15 : 11);
        this.addChild(new TranslationButton(gui, this.relativeX + 98 + extraWidth, this.relativeY + this.getButtonHeight() - 21, 54, 14, MekanismLang.BUTTON_CONFIRM, () -> {
            callback.accept(this.getColor());
            this.close();
        }));
        if (armorPreview != null) {
            this.addChild(new GuiEntityPreview(gui, this.relativeX + 155 + extraWidth, this.relativeY + 17, 80, this.getButtonHeight() - 24, 5, armorPreview));
        }
        this.setColor(Color.rgbi(128, 70, 70));
    }

    @Override
    public void close() {
        super.close();
        if (this.previewReset != null) {
            this.previewReset.run();
        }
    }

    public Color getColor() {
        Color color = Color.hsv(this.hue, this.saturation, this.value);
        if (this.handlesAlpha) {
            color = color.alpha(this.alpha);
        }
        return color;
    }

    public void setColor(Color color) {
        this.setFromColor(color);
        this.updateTextFromColor();
    }

    @Override
    public void renderForeground(PoseStack matrix, int mouseX, int mouseY) {
        super.renderForeground(matrix, mouseX, mouseY);
        this.drawTitleText(matrix, (Component)MekanismLang.COLOR_PICKER.translate(new Object[0]), 6.0f);
        MekanismLang entry = this.handlesAlpha ? MekanismLang.RGBA : MekanismLang.RGB;
        int textOffset = this.handlesAlpha ? 6 : 0;
        this.drawTextScaledBound(matrix, (Component)entry.translate(new Object[0]), this.relativeX + 7, (float)(this.relativeY + this.getButtonHeight()) - 18.0f, this.titleTextColor(), 20 + textOffset);
    }

    private void drawTiledGradient(PoseStack matrix, int x, int y, int width, int height) {
        int tileWidth = Math.round((float)width / 10.0f);
        int tileHeight = Math.round((float)height / 10.0f);
        for (int i = 0; i < 10; ++i) {
            float minV = (float)i / 10.0f;
            float maxV = (float)(i + 1) / 10.0f;
            for (int j = 0; j < 10; ++j) {
                float minS = (float)j / 10.0f;
                float maxS = (float)(j + 1) / 10.0f;
                Color tl = Color.hsv(this.hue, minS, maxV);
                Color tr = Color.hsv(this.hue, maxS, maxV);
                Color bl = Color.hsv(this.hue, minS, minV);
                Color br = Color.hsv(this.hue, maxS, minV);
                this.drawGradient(matrix, x + j * tileWidth, y + (10 - i - 1) * tileHeight, tileWidth, tileHeight, tl, tr, bl, br);
            }
        }
    }

    private void drawGradient(PoseStack matrix, int x, int y, int width, int height, Color tl, Color tr, Color bl, Color br) {
        RenderSystem.m_69472_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
        Matrix4f matrix4f = matrix.m_85850_().m_85861_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        buffer.m_85982_(matrix4f, (float)x, (float)(y + height), 0.0f).m_6122_(bl.r(), bl.g(), bl.b(), bl.a()).m_5752_();
        buffer.m_85982_(matrix4f, (float)(x + width), (float)(y + height), 0.0f).m_6122_(br.r(), br.g(), br.b(), br.a()).m_5752_();
        buffer.m_85982_(matrix4f, (float)(x + width), (float)y, 0.0f).m_6122_(tr.r(), tr.g(), tr.b(), tr.a()).m_5752_();
        buffer.m_85982_(matrix4f, (float)x, (float)y, 0.0f).m_6122_(tl.r(), tl.g(), tl.b(), tl.a()).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
        RenderSystem.m_69461_();
        RenderSystem.m_69493_();
    }

    private void updateTextFromColor() {
        Color color = this.getColor();
        String text = color.r() + "," + color.g() + "," + color.b();
        if (this.handlesAlpha) {
            text = text + "," + color.a();
        }
        this.textField.setText(text);
    }

    private void setFromColor(Color c) {
        double[] hsv = c.hsvArray();
        this.hue = (float)hsv[0];
        this.saturation = (float)hsv[1];
        this.value = (float)hsv[2];
        float f = this.alpha = this.handlesAlpha ? c.af() : 255.0f;
        if (this.updatePreviewColor != null) {
            this.updatePreviewColor.accept(c);
        }
    }

    private void updateArmorPreview() {
        if (this.updatePreviewColor != null) {
            this.updatePreviewColor.accept(this.getColor());
        }
    }

    private void updateColorFromText() {
        String[] split = this.textField.getText().split(",");
        if (split.length == (this.handlesAlpha ? 4 : 3)) {
            try {
                int a;
                int r = Integer.parseInt(split[0]);
                int g = Integer.parseInt(split[1]);
                int b = Integer.parseInt(split[2]);
                int n = a = this.handlesAlpha ? Integer.parseInt(split[3]) : 255;
                if (!(this.byteCheck(r) && this.byteCheck(g) && this.byteCheck(b) && this.byteCheck(a))) {
                    return;
                }
                this.setFromColor(Color.rgbai(r, g, b, a));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private boolean byteCheck(int val) {
        return val >= 0 && val <= 255;
    }

    private void drawColorBar(PoseStack matrix, int x, int y, int width, int height) {
        for (int i = 0; i < width; ++i) {
            GuiUtils.fill(matrix, x + i, y, 1, height, Color.hsv((float)i / (float)width * 360.0f, 1.0, 1.0).argb());
        }
    }

    private void drawAlphaBar(PoseStack matrix, int x, int y, int width, int height) {
        Color hsv = Color.hsv(this.hue, this.saturation, this.value);
        for (int i = 0; i < width; ++i) {
            GuiUtils.fill(matrix, x + i, y, 1, height, hsv.alpha((float)i / (float)width).argb());
        }
    }

    private void drawTransparencyGrid(PoseStack matrix, int x, int y, int width, int height) {
        if (this.handlesAlpha) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)TRANSPARENCY_GRID);
            this.m_93228_(matrix, x, y, 0, 0, width, height);
        }
    }

    @Override
    public boolean m_5534_(char c, int keyCode) {
        boolean ret = super.m_5534_(c, keyCode);
        if (this.textField.canWrite()) {
            this.updateColorFromText();
        }
        return ret;
    }

    @Override
    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        boolean ret = super.m_7933_(keyCode, scanCode, modifiers);
        if (this.textField.canWrite() && (Screen.m_96630_((int)keyCode) || Screen.m_96628_((int)keyCode) || keyCode == 259 || keyCode == 261)) {
            this.updateColorFromText();
        }
        return ret;
    }

    public class GuiColorView
    extends GuiElement {
        public GuiColorView(IGuiWrapper gui, int x, int y, int width, int height) {
            super(gui, x, y, width, height);
        }

        @Override
        public void m_7428_(@NotNull PoseStack matrix, int mouseX, int mouseY) {
            super.m_7428_(matrix, mouseX, mouseY);
            String hex = GuiColorWindow.this.handlesAlpha ? TextUtils.hex(false, 4, GuiColorWindow.this.getColor().argb()) : TextUtils.hex(false, 3, GuiColorWindow.this.getColor().rgb());
            this.displayTooltips(matrix, mouseX, mouseY, new Component[]{MekanismLang.GENERIC_HEX.translateColored(EnumColor.GRAY, hex)});
        }

        @Override
        public void drawBackground(@NotNull PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
            super.drawBackground(matrix, mouseX, mouseY, partialTicks);
            GuiColorWindow.this.drawTransparencyGrid(matrix, this.getButtonX(), this.getButtonY(), this.getButtonWidth(), this.getButtonHeight());
            Color c = GuiColorWindow.this.getColor();
            GuiUtils.fill(matrix, this.getButtonX(), this.getButtonY(), this.getButtonWidth(), this.getButtonHeight(), c.argb());
        }
    }

    public class GuiShadePicker
    extends GuiPicker {
        public GuiShadePicker(IGuiWrapper gui, int x, int y, int width, int height) {
            super(gui, x, y, width, height);
        }

        @Override
        public void renderBackgroundOverlay(PoseStack matrix, int mouseX, int mouseY) {
            super.renderBackgroundOverlay(matrix, mouseX, mouseY);
            GuiColorWindow.this.drawTiledGradient(matrix, this.getButtonX(), this.getButtonY(), this.getButtonWidth(), this.getButtonHeight());
            int posX = this.getButtonX() + Math.round(GuiColorWindow.this.saturation * (float)this.getButtonWidth()) - 2;
            int posY = this.getButtonY() + Math.round((1.0f - GuiColorWindow.this.value) * (float)this.getButtonHeight()) - 2;
            GuiUtils.drawOutline(matrix, posX, posY, 5, 5, -1);
            GuiUtils.fill(matrix, posX + 1, posY + 1, 3, 3, GuiColorWindow.this.getColor().alpha(1.0).argb());
        }

        @Override
        protected void set(double mouseX, double mouseY) {
            float newS = (float)(mouseX - (double)this.getButtonX()) / (float)this.getButtonWidth();
            GuiColorWindow.this.saturation = Mth.m_14036_((float)newS, (float)0.0f, (float)1.0f);
            float newV = (float)(mouseY - (double)this.getButtonY()) / (float)this.getButtonHeight();
            GuiColorWindow.this.value = 1.0f - Mth.m_14036_((float)newV, (float)0.0f, (float)1.0f);
            GuiColorWindow.this.updateTextFromColor();
            GuiColorWindow.this.updateArmorPreview();
        }
    }

    public class GuiHuePicker
    extends GuiPicker {
        public GuiHuePicker(IGuiWrapper gui, int x, int y, int width, int height) {
            super(gui, x, y, width, height);
        }

        @Override
        public void renderBackgroundOverlay(PoseStack matrix, int mouseX, int mouseY) {
            super.renderBackgroundOverlay(matrix, mouseX, mouseY);
            GuiColorWindow.this.drawColorBar(matrix, this.getButtonX(), this.getButtonY(), this.getButtonWidth(), this.getButtonHeight());
            RenderSystem.m_157456_((int)0, (ResourceLocation)HUE_PICKER);
            int posX = Math.round(GuiColorWindow.this.hue / 360.0f * (float)(this.getButtonWidth() - 3));
            GuiHuePicker.m_93133_((PoseStack)matrix, (int)(this.getButtonX() - 2 + posX), (int)(this.getButtonY() - 2), (float)0.0f, (float)0.0f, (int)7, (int)12, (int)12, (int)12);
            GuiUtils.fill(matrix, this.getButtonX() + posX, this.getButtonY(), 3, 8, Color.hsv(GuiColorWindow.this.hue, 1.0, 1.0).argb());
        }

        @Override
        protected void set(double mouseX, double mouseY) {
            float val = (float)(mouseX - (double)this.getButtonX()) / (float)this.getButtonWidth();
            GuiColorWindow.this.hue = Mth.m_14036_((float)val, (float)0.0f, (float)1.0f) * 360.0f;
            GuiColorWindow.this.updateTextFromColor();
            GuiColorWindow.this.updateArmorPreview();
        }
    }

    public class GuiAlphaPicker
    extends GuiPicker {
        public GuiAlphaPicker(IGuiWrapper gui, int x, int y, int width, int height) {
            super(gui, x, y, width, height);
        }

        @Override
        public void drawBackground(@NotNull PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
            super.drawBackground(matrix, mouseX, mouseY, partialTicks);
            GuiColorWindow.this.drawTransparencyGrid(matrix, this.getButtonX(), this.getButtonY(), this.getButtonWidth(), this.getButtonHeight());
        }

        @Override
        public void renderBackgroundOverlay(PoseStack matrix, int mouseX, int mouseY) {
            super.renderBackgroundOverlay(matrix, mouseX, mouseY);
            GuiColorWindow.this.drawAlphaBar(matrix, this.getButtonX(), this.getButtonY(), this.getButtonWidth(), this.getButtonHeight());
            RenderSystem.m_157456_((int)0, (ResourceLocation)HUE_PICKER);
            int posX = Math.round(GuiColorWindow.this.alpha * (float)(this.getButtonWidth() - 3));
            GuiAlphaPicker.m_93133_((PoseStack)matrix, (int)(this.getButtonX() - 2 + posX), (int)(this.getButtonY() - 2), (float)0.0f, (float)0.0f, (int)7, (int)12, (int)12, (int)12);
            GuiColorWindow.this.drawTransparencyGrid(matrix, this.getButtonX() + posX, this.getButtonY(), 3, 8);
            GuiUtils.fill(matrix, this.getButtonX() + posX, this.getButtonY(), 3, 8, GuiColorWindow.this.getColor().argb());
        }

        @Override
        protected void set(double mouseX, double mouseY) {
            float val = (float)(mouseX - (double)this.getButtonX()) / (float)this.getButtonWidth();
            GuiColorWindow.this.alpha = Mth.m_14036_((float)val, (float)0.0f, (float)1.0f);
            GuiColorWindow.this.updateTextFromColor();
            GuiColorWindow.this.updateArmorPreview();
        }
    }

    private static abstract class GuiPicker
    extends GuiElement {
        private boolean isDragging;

        public GuiPicker(IGuiWrapper gui, int x, int y, int width, int height) {
            super(gui, x, y, width, height);
        }

        protected abstract void set(double var1, double var3);

        public void m_5716_(double mouseX, double mouseY) {
            if (this.m_93680_(mouseX, mouseY)) {
                this.set(mouseX, mouseY);
                this.isDragging = true;
            }
        }

        @Override
        public void m_7212_(double mouseX, double mouseY, double deltaX, double deltaY) {
            super.m_7212_(mouseX, mouseY, deltaX, deltaY);
            if (this.isDragging) {
                this.set(mouseX, mouseY);
            }
        }

        @Override
        public void m_7691_(double mouseX, double mouseY) {
            super.m_7691_(mouseX, mouseY);
            this.isDragging = false;
        }
    }
}

