/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.scroll;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.List;
import java.util.function.Supplier;
import mekanism.api.math.MathUtils;
import mekanism.api.robit.RobitSkin;
import mekanism.client.RobitSpriteUploader;
import mekanism.client.gui.GuiUtils;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiElementHolder;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.scroll.GuiScrollBar;
import mekanism.client.model.MekanismModelCache;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.lib.QuadTransformation;
import mekanism.client.render.lib.QuadUtils;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.entity.EntityRobit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;

public class GuiRobitSkinSelectScroll
extends GuiElement {
    private static final int SLOT_DIMENSIONS = 48;
    private static final int SLOT_COUNT = 3;
    private static final int INNER_DIMENSIONS = 144;
    private final GuiScrollBar scrollBar;
    private final Supplier<List<RobitSkin>> unlockedSkins;
    private final EntityRobit robit;
    private RobitSkin selectedSkin;
    private float rotation;
    private int ticks;

    public GuiRobitSkinSelectScroll(IGuiWrapper gui, int x, int y, EntityRobit robit, Supplier<List<RobitSkin>> unlockedSkins) {
        super(gui, x, y, 156, 144);
        this.robit = robit;
        this.selectedSkin = this.robit.getSkin();
        this.unlockedSkins = unlockedSkins;
        this.scrollBar = this.addChild(new GuiScrollBar(gui, this.relativeX + 144, y, 144, () -> this.getUnlockedSkins() == null ? 0 : (int)Math.ceil((double)this.getUnlockedSkins().size() / 3.0), () -> 3));
    }

    private List<RobitSkin> getUnlockedSkins() {
        return this.unlockedSkins.get();
    }

    public RobitSkin getSelectedSkin() {
        return this.selectedSkin;
    }

    @Override
    public void drawBackground(@NotNull PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        super.drawBackground(matrix, mouseX, mouseY, partialTicks);
        List<RobitSkin> skins = this.getUnlockedSkins();
        if (skins != null) {
            Lighting.m_84930_();
            int index = this.ticks / 10;
            float oldRot = this.rotation;
            this.rotation = Mth.m_14177_((float)(this.rotation - 0.5f));
            float rot = Mth.m_14189_((float)partialTicks, (float)oldRot, (float)this.rotation);
            QuadTransformation rotation = QuadTransformation.rotateY(rot);
            int slotStart = this.scrollBar.getCurrentSelection() * 3;
            int max = 9;
            for (int i = 0; i < max; ++i) {
                int slotX = this.f_93620_ + i % 3 * 48;
                int slotY = this.f_93621_ + i / 3 * 48;
                int slot = slotStart + i;
                if (slot < skins.size()) {
                    RobitSkin skin = skins.get(slot);
                    if (skin == this.selectedSkin) {
                        GuiRobitSkinSelectScroll.renderSlotBackground(matrix, slotX, slotY, GuiInnerScreen.SCREEN, GuiInnerScreen.SCREEN_SIZE);
                    } else {
                        GuiRobitSkinSelectScroll.renderSlotBackground(matrix, slotX, slotY, GuiElementHolder.HOLDER, 32);
                    }
                    this.renderRobit(matrix, skins.get(slot), slotX, slotY, rotation, index);
                    continue;
                }
                GuiRobitSkinSelectScroll.renderSlotBackground(matrix, slotX, slotY, GuiElementHolder.HOLDER, 32);
            }
            Lighting.m_84931_();
        }
    }

    private static void renderSlotBackground(@NotNull PoseStack matrix, int slotX, int slotY, ResourceLocation resource, int size) {
        GuiUtils.renderBackgroundTexture(matrix, resource, size, size, slotX, slotY, 48, 48, 256, 256);
    }

    @Override
    public void renderForeground(PoseStack matrix, int mouseX, int mouseY) {
        super.renderForeground(matrix, mouseX, mouseY);
        List<RobitSkin> skins = this.getUnlockedSkins();
        if (skins != null) {
            int xAxis = mouseX - this.getGuiLeft();
            int yAxis = mouseY - this.getGuiTop();
            int slotX = (xAxis - this.relativeX) / 48;
            int slotY = (yAxis - this.relativeY) / 48;
            if (slotX >= 0 && slotY >= 0 && slotX < 3 && slotY < 3) {
                int slot;
                int slotStartX = this.relativeX + slotX * 48;
                int slotStartY = this.relativeY + slotY * 48;
                if (xAxis >= slotStartX && xAxis < slotStartX + 48 && yAxis >= slotStartY && yAxis < slotStartY + 48 && (slot = (slotY + this.scrollBar.getCurrentSelection()) * 3 + slotX) < skins.size()) {
                    GuiRobitSkinSelectScroll.m_93172_((PoseStack)matrix, (int)slotStartX, (int)slotStartY, (int)(slotStartX + 48), (int)(slotStartY + 48), (int)1895819776);
                    MekanismRenderer.resetColor();
                }
            }
        }
    }

    @Override
    public void tick() {
        super.tick();
        ++this.ticks;
    }

    @Override
    public void m_7428_(@NotNull PoseStack matrix, int mouseX, int mouseY) {
        super.m_7428_(matrix, mouseX, mouseY);
        RobitSkin skin = this.getSkin(mouseX, mouseY);
        if (skin != null) {
            this.displayTooltips(matrix, mouseX, mouseY, new Component[]{MekanismLang.ROBIT_SKIN.translate(skin)});
        }
    }

    @Override
    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        return this.scrollBar.adjustScroll(delta) || super.m_6050_(mouseX, mouseY, delta);
    }

    public void m_5716_(double mouseX, double mouseY) {
        super.m_5716_(mouseX, mouseY);
        RobitSkin skin = this.getSkin(mouseX, mouseY);
        if (skin != null) {
            this.selectedSkin = skin;
        }
    }

    private RobitSkin getSkin(double mouseX, double mouseY) {
        List<RobitSkin> skins = this.getUnlockedSkins();
        if (skins != null) {
            int slot;
            int slotX = (int)((mouseX - (double)this.f_93620_) / 48.0);
            int slotY = (int)((mouseY - (double)this.f_93621_) / 48.0);
            if (slotX >= 0 && slotY >= 0 && slotX < 3 && slotY < 3 && (slot = (slotY + this.scrollBar.getCurrentSelection()) * 3 + slotX) < skins.size()) {
                return skins.get(slot);
            }
        }
        return null;
    }

    private void renderRobit(PoseStack matrix, RobitSkin skin, int x, int y, QuadTransformation rotation, int index) {
        List<ResourceLocation> textures = skin.getTextures();
        if (textures.isEmpty()) {
            Mekanism.logger.error("Failed to render skin: {}, as it has no textures.", (Object)skin.getRegistryName());
            return;
        }
        BakedModel model = MekanismModelCache.INSTANCE.getRobitSkin(skin);
        if (model == null) {
            Mekanism.logger.warn("Failed to render skin: {} as it does not have a model.", (Object)skin.getRegistryName());
            return;
        }
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        VertexConsumer builder = buffer.m_6299_(RobitSpriteUploader.RENDER_TYPE);
        matrix.m_85836_();
        matrix.m_85837_((double)(x + 48), (double)(y + 38), 0.0);
        matrix.m_85841_(48.0f, 48.0f, 48.0f);
        matrix.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        PoseStack.Pose matrixEntry = matrix.m_85850_();
        ModelData modelData = ModelData.builder().with(EntityRobit.SKIN_TEXTURE_PROPERTY, (Object)MathUtils.getByIndexMod(textures, index)).build();
        List<BakedQuad> quads = model.getQuads(null, null, this.robit.f_19853_.f_46441_, modelData, null);
        quads = QuadUtils.transformBakedQuads(quads, rotation);
        for (BakedQuad quad : quads) {
            builder.m_85987_(matrixEntry, quad, 1.0f, 1.0f, 1.0f, 0xF000F0, OverlayTexture.f_118083_);
        }
        buffer.m_109912_(RobitSpriteUploader.RENDER_TYPE);
        matrix.m_85849_();
    }
}

