/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.custom.module;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Optional;
import java.util.function.Consumer;
import mekanism.api.gear.IModule;
import mekanism.api.gear.config.ModuleColorData;
import mekanism.api.providers.IModuleDataProvider;
import mekanism.client.gui.GuiModuleTweaker;
import mekanism.client.gui.GuiUtils;
import mekanism.client.gui.element.custom.module.GuiModuleScreen;
import mekanism.client.gui.element.custom.module.MiniElement;
import mekanism.client.gui.element.text.GuiTextField;
import mekanism.client.gui.element.window.GuiColorWindow;
import mekanism.common.MekanismLang;
import mekanism.common.content.gear.Module;
import mekanism.common.content.gear.ModuleConfigItem;
import mekanism.common.content.gear.ModuleHelper;
import mekanism.common.lib.Color;
import mekanism.common.registries.MekanismModules;
import mekanism.common.util.text.TextUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

class ColorSelection
extends MiniElement {
    private static final int OFFSET_Y = 1;
    private final int OFFSET_X;
    private final ModuleConfigItem<Integer> data;
    @Nullable
    private final GuiModuleTweaker.ArmorPreview armorPreview;
    private final boolean handlesAlpha;

    ColorSelection(GuiModuleScreen parent, ModuleConfigItem<Integer> data, int xPos, int yPos, int dataIndex, boolean handlesAlpha, @Nullable GuiModuleTweaker.ArmorPreview armorPreview) {
        super(parent, xPos, yPos, dataIndex);
        this.data = data;
        this.handlesAlpha = handlesAlpha;
        this.armorPreview = armorPreview;
        this.OFFSET_X = this.parent.getScreenWidth() - 26;
    }

    private Color getColor() {
        return Color.argb(this.data.get());
    }

    @Override
    protected int getNeededHeight() {
        return 20;
    }

    @Override
    protected void renderBackground(PoseStack matrix, int mouseX, int mouseY) {
        int xTarget = this.getX() + this.OFFSET_X;
        int yTarget = this.getY() + 1;
        GuiUtils.drawOutline(matrix, xTarget, yTarget, 18, 18, GuiTextField.SCREEN_COLOR.getAsInt());
        RenderSystem.m_157456_((int)0, (ResourceLocation)GuiColorWindow.TRANSPARENCY_GRID);
        this.parent.m_93228_(matrix, xTarget + 1, yTarget + 1, 0, 0, 16, 16);
        GuiUtils.fill(matrix, xTarget + 1, yTarget + 1, 16, 16, this.data.get());
    }

    @Override
    protected void renderForeground(PoseStack matrix, int mouseX, int mouseY) {
        int textColor = this.parent.screenTextColor();
        this.parent.drawTextWithScale(matrix, this.data.getDescription(), this.getRelativeX() + 3, this.getRelativeY(), textColor, 0.8f);
        String hex = this.handlesAlpha ? TextUtils.hex(false, 4, this.data.get().intValue()) : TextUtils.hex(false, 3, this.getColor().rgb());
        this.parent.drawTextExact(matrix, (Component)MekanismLang.GENERIC_HEX.translate(hex), this.getRelativeX() + 3, this.getRelativeY() + 11, textColor);
    }

    @Override
    protected void click(double mouseX, double mouseY) {
        if (this.mouseOver(mouseX, mouseY, this.OFFSET_X, 1, 18, 18)) {
            ItemStack stack;
            Item item;
            Consumer<Color> updatePreviewColor = null;
            Runnable previewReset = null;
            IModule<?> currentModule = this.parent.getCurrentModule();
            if (this.armorPreview != null && this.data.matches(MekanismModules.COLOR_MODULATION_UNIT, "color") && currentModule != null && (item = (stack = currentModule.getContainer().m_41777_()).m_41720_()) instanceof ArmorItem) {
                Optional<ModuleConfigItem> matchedData;
                ArmorItem armorItem = (ArmorItem)item;
                IModule colorModulation = ModuleHelper.INSTANCE.load(stack, (IModuleDataProvider)MekanismModules.COLOR_MODULATION_UNIT);
                if (colorModulation != null && (matchedData = ((Module)colorModulation).getConfigItems().stream().filter(e -> e.getName().equals("color") && e.getData() instanceof ModuleColorData).map(e -> e).findFirst()).isPresent()) {
                    this.armorPreview.get();
                    EquipmentSlot slot = armorItem.m_40402_();
                    this.armorPreview.updatePreview(slot, stack);
                    updatePreviewColor = c -> ((ModuleConfigItem)matchedData.get()).set(c.argb());
                    previewReset = () -> this.armorPreview.resetToDefault(slot);
                }
            }
            GuiColorWindow window = new GuiColorWindow(this.parent.gui(), this.parent.getGuiWidth() / 2 - 80, this.parent.getGuiHeight() / 2 - 60, this.handlesAlpha, color -> this.setData(this.data, color.argb()), this.armorPreview, updatePreviewColor, previewReset);
            window.setColor(this.getColor());
            this.parent.gui().addWindow(window);
        }
    }
}

