/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.util.List;
import java.util.function.Predicate;
import mekanism.client.gui.element.GuiElement;
import mekanism.common.Mekanism;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiUtils {
    private GuiUtils() {
    }

    public static void renderExtendedTexture(PoseStack matrix, ResourceLocation resource, int sideWidth, int sideHeight, int left, int top, int width, int height) {
        int textureWidth = 2 * sideWidth + 1;
        int textureHeight = 2 * sideHeight + 1;
        int centerWidth = width - 2 * sideWidth;
        int centerHeight = height - 2 * sideHeight;
        int leftEdgeEnd = left + sideWidth;
        int rightEdgeStart = leftEdgeEnd + centerWidth;
        int topEdgeEnd = top + sideHeight;
        int bottomEdgeStart = topEdgeEnd + centerHeight;
        RenderSystem.m_157456_((int)0, (ResourceLocation)resource);
        GuiComponent.m_93133_((PoseStack)matrix, (int)left, (int)top, (float)0.0f, (float)0.0f, (int)sideWidth, (int)sideHeight, (int)textureWidth, (int)textureHeight);
        if (centerHeight > 0) {
            GuiComponent.m_93160_((PoseStack)matrix, (int)left, (int)topEdgeEnd, (int)sideWidth, (int)centerHeight, (float)0.0f, (float)sideHeight, (int)sideWidth, (int)1, (int)textureWidth, (int)textureHeight);
        }
        GuiComponent.m_93133_((PoseStack)matrix, (int)left, (int)bottomEdgeStart, (float)0.0f, (float)(sideHeight + 1), (int)sideWidth, (int)sideHeight, (int)textureWidth, (int)textureHeight);
        if (centerWidth > 0) {
            GuiComponent.m_93160_((PoseStack)matrix, (int)leftEdgeEnd, (int)top, (int)centerWidth, (int)sideHeight, (float)sideWidth, (float)0.0f, (int)1, (int)sideHeight, (int)textureWidth, (int)textureHeight);
            if (centerHeight > 0) {
                GuiComponent.m_93160_((PoseStack)matrix, (int)leftEdgeEnd, (int)topEdgeEnd, (int)centerWidth, (int)centerHeight, (float)sideWidth, (float)sideHeight, (int)1, (int)1, (int)textureWidth, (int)textureHeight);
            }
            GuiComponent.m_93160_((PoseStack)matrix, (int)leftEdgeEnd, (int)bottomEdgeStart, (int)centerWidth, (int)sideHeight, (float)sideWidth, (float)(sideHeight + 1), (int)1, (int)sideHeight, (int)textureWidth, (int)textureHeight);
        }
        GuiComponent.m_93133_((PoseStack)matrix, (int)rightEdgeStart, (int)top, (float)(sideWidth + 1), (float)0.0f, (int)sideWidth, (int)sideHeight, (int)textureWidth, (int)textureHeight);
        if (centerHeight > 0) {
            GuiComponent.m_93160_((PoseStack)matrix, (int)rightEdgeStart, (int)topEdgeEnd, (int)sideWidth, (int)centerHeight, (float)(sideWidth + 1), (float)sideHeight, (int)sideWidth, (int)1, (int)textureWidth, (int)textureHeight);
        }
        GuiComponent.m_93133_((PoseStack)matrix, (int)rightEdgeStart, (int)bottomEdgeStart, (float)(sideWidth + 1), (float)(sideHeight + 1), (int)sideWidth, (int)sideHeight, (int)textureWidth, (int)textureHeight);
    }

    public static void renderBackgroundTexture(PoseStack matrix, ResourceLocation resource, int texSideWidth, int texSideHeight, int left, int top, int width, int height, int textureWidth, int textureHeight) {
        int sideWidth = Math.min(texSideWidth, width / 2);
        int sideHeight = Math.min(texSideHeight, height / 2);
        int leftWidth = sideWidth < texSideWidth ? sideWidth + width % 2 : sideWidth;
        int topHeight = sideHeight < texSideHeight ? sideHeight + height % 2 : sideHeight;
        int texCenterWidth = textureWidth - texSideWidth * 2;
        int texCenterHeight = textureHeight - texSideHeight * 2;
        int centerWidth = width - leftWidth - sideWidth;
        int centerHeight = height - topHeight - sideHeight;
        int leftEdgeEnd = left + leftWidth;
        int rightEdgeStart = leftEdgeEnd + centerWidth;
        int topEdgeEnd = top + topHeight;
        int bottomEdgeStart = topEdgeEnd + centerHeight;
        RenderSystem.m_157456_((int)0, (ResourceLocation)resource);
        GuiComponent.m_93133_((PoseStack)matrix, (int)left, (int)top, (float)0.0f, (float)0.0f, (int)leftWidth, (int)topHeight, (int)textureWidth, (int)textureHeight);
        GuiComponent.m_93133_((PoseStack)matrix, (int)left, (int)bottomEdgeStart, (float)0.0f, (float)(textureHeight - sideHeight), (int)leftWidth, (int)sideHeight, (int)textureWidth, (int)textureHeight);
        if (centerWidth > 0) {
            GuiUtils.blitTiled(matrix, leftEdgeEnd, top, centerWidth, topHeight, texSideWidth, 0, texCenterWidth, texSideHeight, textureWidth, textureHeight);
            if (centerHeight > 0) {
                GuiUtils.blitTiled(matrix, leftEdgeEnd, topEdgeEnd, centerWidth, centerHeight, texSideWidth, texSideHeight, texCenterWidth, texCenterHeight, textureWidth, textureHeight);
            }
            GuiUtils.blitTiled(matrix, leftEdgeEnd, bottomEdgeStart, centerWidth, sideHeight, texSideWidth, textureHeight - sideHeight, texCenterWidth, texSideHeight, textureWidth, textureHeight);
        }
        if (centerHeight > 0) {
            GuiUtils.blitTiled(matrix, left, topEdgeEnd, leftWidth, centerHeight, 0, texSideHeight, texSideWidth, texCenterHeight, textureWidth, textureHeight);
            GuiUtils.blitTiled(matrix, rightEdgeStart, topEdgeEnd, sideWidth, centerHeight, textureWidth - sideWidth, texSideHeight, texSideWidth, texCenterHeight, textureWidth, textureHeight);
        }
        GuiComponent.m_93133_((PoseStack)matrix, (int)rightEdgeStart, (int)top, (float)(textureWidth - sideWidth), (float)0.0f, (int)sideWidth, (int)topHeight, (int)textureWidth, (int)textureHeight);
        GuiComponent.m_93133_((PoseStack)matrix, (int)rightEdgeStart, (int)bottomEdgeStart, (float)(textureWidth - sideWidth), (float)(textureHeight - sideHeight), (int)sideWidth, (int)sideHeight, (int)textureWidth, (int)textureHeight);
    }

    public static void blitTiled(PoseStack matrix, int x, int y, int width, int height, int texX, int texY, int texDrawWidth, int texDrawHeight, int textureWidth, int textureHeight) {
        int xTiles = (int)Math.ceil((float)width / (float)texDrawWidth);
        int yTiles = (int)Math.ceil((float)height / (float)texDrawHeight);
        int drawWidth = width;
        int drawHeight = height;
        for (int tileX = 0; tileX < xTiles; ++tileX) {
            for (int tileY = 0; tileY < yTiles; ++tileY) {
                GuiComponent.m_93133_((PoseStack)matrix, (int)(x + texDrawWidth * tileX), (int)(y + texDrawHeight * tileY), (float)texX, (float)texY, (int)Math.min(drawWidth, texDrawWidth), (int)Math.min(drawHeight, texDrawHeight), (int)textureWidth, (int)textureHeight);
                drawHeight -= texDrawHeight;
            }
            drawWidth -= texDrawWidth;
            drawHeight = height;
        }
    }

    public static void drawOutline(PoseStack matrix, int x, int y, int width, int height, int color) {
        GuiUtils.fill(matrix, x, y, width, 1, color);
        GuiUtils.fill(matrix, x, y + height - 1, width, 1, color);
        if (height > 2) {
            GuiUtils.fill(matrix, x, y + 1, 1, height - 2, color);
            GuiUtils.fill(matrix, x + width - 1, y + 1, 1, height - 2, color);
        }
    }

    public static void fill(PoseStack matrix, int x, int y, int width, int height, int color) {
        if (width != 0 && height != 0) {
            GuiComponent.m_93172_((PoseStack)matrix, (int)x, (int)y, (int)(x + width), (int)(y + height), (int)color);
        }
    }

    public static void drawSprite(PoseStack matrix, int x, int y, int width, int height, int zLevel, TextureAtlasSprite sprite) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TextureAtlas.f_118259_);
        RenderSystem.m_69478_();
        BufferBuilder vertexBuffer = Tesselator.m_85913_().m_85915_();
        vertexBuffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        Matrix4f matrix4f = matrix.m_85850_().m_85861_();
        vertexBuffer.m_85982_(matrix4f, (float)x, (float)(y + height), (float)zLevel).m_7421_(sprite.m_118409_(), sprite.m_118412_()).m_5752_();
        vertexBuffer.m_85982_(matrix4f, (float)(x + width), (float)(y + height), (float)zLevel).m_7421_(sprite.m_118410_(), sprite.m_118412_()).m_5752_();
        vertexBuffer.m_85982_(matrix4f, (float)(x + width), (float)y, (float)zLevel).m_7421_(sprite.m_118410_(), sprite.m_118411_()).m_5752_();
        vertexBuffer.m_85982_(matrix4f, (float)x, (float)y, (float)zLevel).m_7421_(sprite.m_118409_(), sprite.m_118411_()).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)vertexBuffer.m_231175_());
        RenderSystem.m_69461_();
    }

    public static void drawTiledSprite(PoseStack matrix, int xPosition, int yPosition, int yOffset, int desiredWidth, int desiredHeight, TextureAtlasSprite sprite, int textureWidth, int textureHeight, int zLevel, TilingDirection tilingDirection) {
        GuiUtils.drawTiledSprite(matrix, xPosition, yPosition, yOffset, desiredWidth, desiredHeight, sprite, textureWidth, textureHeight, zLevel, tilingDirection, true);
    }

    public static void drawTiledSprite(PoseStack matrix, int xPosition, int yPosition, int yOffset, int desiredWidth, int desiredHeight, TextureAtlasSprite sprite, int textureWidth, int textureHeight, int zLevel, TilingDirection tilingDirection, boolean blend) {
        if (desiredWidth == 0 || desiredHeight == 0 || textureWidth == 0 || textureHeight == 0) {
            return;
        }
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TextureAtlas.f_118259_);
        int xTileCount = desiredWidth / textureWidth;
        int xRemainder = desiredWidth - xTileCount * textureWidth;
        int yTileCount = desiredHeight / textureHeight;
        int yRemainder = desiredHeight - yTileCount * textureHeight;
        int yStart = yPosition + yOffset;
        float uMin = sprite.m_118409_();
        float uMax = sprite.m_118410_();
        float vMin = sprite.m_118411_();
        float vMax = sprite.m_118412_();
        float uDif = uMax - uMin;
        float vDif = vMax - vMin;
        if (blend) {
            RenderSystem.m_69478_();
        }
        BufferBuilder vertexBuffer = Tesselator.m_85913_().m_85915_();
        vertexBuffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        Matrix4f matrix4f = matrix.m_85850_().m_85861_();
        block0: for (int xTile = 0; xTile <= xTileCount; ++xTile) {
            float uLocalMax;
            float uLocalMin;
            int width;
            int n = width = xTile == xTileCount ? xRemainder : textureWidth;
            if (width == 0) break;
            int x = xPosition + xTile * textureWidth;
            int maskRight = textureWidth - width;
            int shiftedX = x + textureWidth - maskRight;
            float uLocalDif = uDif * (float)maskRight / (float)textureWidth;
            if (tilingDirection.right) {
                uLocalMin = uMin;
                uLocalMax = uMax - uLocalDif;
            } else {
                uLocalMin = uMin + uLocalDif;
                uLocalMax = uMax;
            }
            for (int yTile = 0; yTile <= yTileCount; ++yTile) {
                float vLocalMax;
                float vLocalMin;
                int height;
                int n2 = height = yTile == yTileCount ? yRemainder : textureHeight;
                if (height == 0) continue block0;
                int y = yStart - (yTile + 1) * textureHeight;
                int maskTop = textureHeight - height;
                float vLocalDif = vDif * (float)maskTop / (float)textureHeight;
                if (tilingDirection.down) {
                    vLocalMin = vMin;
                    vLocalMax = vMax - vLocalDif;
                } else {
                    vLocalMin = vMin + vLocalDif;
                    vLocalMax = vMax;
                }
                vertexBuffer.m_85982_(matrix4f, (float)x, (float)(y + textureHeight), (float)zLevel).m_7421_(uLocalMin, vLocalMax).m_5752_();
                vertexBuffer.m_85982_(matrix4f, (float)shiftedX, (float)(y + textureHeight), (float)zLevel).m_7421_(uLocalMax, vLocalMax).m_5752_();
                vertexBuffer.m_85982_(matrix4f, (float)shiftedX, (float)(y + maskTop), (float)zLevel).m_7421_(uLocalMax, vLocalMin).m_5752_();
                vertexBuffer.m_85982_(matrix4f, (float)x, (float)(y + maskTop), (float)zLevel).m_7421_(uLocalMin, vLocalMin).m_5752_();
            }
        }
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)vertexBuffer.m_231175_());
        if (blend) {
            RenderSystem.m_69461_();
        }
    }

    public static boolean checkChildren(List<? extends GuiEventListener> children, Predicate<GuiElement> checker) {
        for (int i = children.size() - 1; i >= 0; --i) {
            GuiElement element;
            GuiEventListener obj = children.get(i);
            if (!(obj instanceof GuiElement) || !checker.test(element = (GuiElement)obj)) continue;
            return true;
        }
        return false;
    }

    public static void renderItem(PoseStack matrix, ItemRenderer renderer, @NotNull ItemStack stack, int xAxis, int yAxis, float scale, Font font, @Nullable String text, boolean overlay) {
        if (!stack.m_41619_()) {
            try {
                matrix.m_85836_();
                RenderSystem.m_69482_();
                if (scale != 1.0f) {
                    matrix.m_85837_((double)xAxis, (double)yAxis, 0.0);
                    matrix.m_85841_(scale, scale, scale);
                    xAxis = 0;
                    yAxis = 0;
                }
                int finalXAxis = xAxis;
                int finalYAxis = yAxis;
                GuiUtils.renderWithPose(matrix, () -> {
                    renderer.m_115203_(stack, finalXAxis, finalYAxis);
                    if (overlay) {
                        float previousOffset = renderer.f_115093_;
                        renderer.f_115093_ -= 25.0f;
                        renderer.m_115174_(font, stack, finalXAxis, finalYAxis, text);
                        renderer.f_115093_ = previousOffset;
                    }
                });
                RenderSystem.m_69465_();
                matrix.m_85849_();
            }
            catch (Exception e) {
                Mekanism.logger.error("Failed to render stack into gui: {}", (Object)stack, (Object)e);
            }
        }
    }

    public static void renderWithPose(PoseStack poseStack, Runnable toRender) {
        PoseStack modelViewStack = RenderSystem.m_157191_();
        modelViewStack.m_85836_();
        modelViewStack.m_166854_(poseStack.m_85850_().m_85861_());
        RenderSystem.m_157182_();
        toRender.run();
        modelViewStack.m_85849_();
        RenderSystem.m_157182_();
    }

    public static enum TilingDirection {
        DOWN_RIGHT(true, true),
        DOWN_LEFT(true, false),
        UP_RIGHT(false, true),
        UP_LEFT(false, false);

        private final boolean down;
        private final boolean right;

        private TilingDirection(boolean down, boolean right) {
            this.down = down;
            this.right = right;
        }
    }
}

