/*
 * Decompiled with CFR 0.152.
 */
package com.prunoideae.recipe;

import com.google.gson.JsonElement;
import com.prunoideae.recipe.BotaniaRecipeJS;
import dev.latvian.mods.kubejs.recipe.IngredientMatch;
import dev.latvian.mods.kubejs.recipe.ItemInputTransformer;
import dev.latvian.mods.kubejs.recipe.ItemOutputTransformer;
import dev.latvian.mods.kubejs.recipe.RecipeArguments;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class TerraPlateRecipeJS
extends BotaniaRecipeJS {
    public int mana = 500000;
    private ItemStack output = null;
    private final List<Ingredient> inputs = new ArrayList<Ingredient>();

    public void create(RecipeArguments args) {
        this.output = this.parseItemOutput(args.get(0));
        this.inputs.addAll(this.parseItemInputList(args.get(1)));
        if (args.size() > 2) {
            this.mana = (int)((Double)args.get(2)).doubleValue();
        }
    }

    public void deserialize() {
        this.output = this.parseItemOutput(this.json.get("result"));
        this.inputs.addAll(this.parseItemInputList(this.json.get("ingredients")));
        this.mana = this.json.get("mana").getAsInt();
    }

    public void serialize() {
        if (this.serializeOutputs) {
            this.json.add("result", this.itemToJson(this.output));
        }
        if (this.serializeInputs) {
            this.json.add("ingredients", (JsonElement)this.serializeIngredientList(this.inputs));
        }
        this.json.addProperty("mana", (Number)this.mana);
    }

    public boolean hasInput(IngredientMatch match) {
        return this.inputs.stream().anyMatch(arg_0 -> ((IngredientMatch)match).contains(arg_0));
    }

    public boolean replaceInput(IngredientMatch match, Ingredient with, ItemInputTransformer transformer) {
        boolean anyReplaced = false;
        for (int i = 0; i < this.inputs.size(); ++i) {
            if (!match.contains(this.inputs.get(i))) continue;
            this.inputs.set(i, transformer.transform((RecipeJS)this, match, this.inputs.get(i), with));
            anyReplaced = true;
        }
        return anyReplaced;
    }

    public boolean hasOutput(IngredientMatch match) {
        return match.contains(this.output);
    }

    public boolean replaceOutput(IngredientMatch match, ItemStack with, ItemOutputTransformer transformer) {
        if (match.contains(this.output)) {
            this.output = transformer.transform((RecipeJS)this, match, this.output, with);
            return true;
        }
        return false;
    }
}

