/*
 * Decompiled with CFR 0.152.
 */
package com.prunoideae.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.prunoideae.recipe.BotaniaRecipeJS;
import dev.latvian.mods.kubejs.block.state.BlockStatePredicate;
import dev.latvian.mods.kubejs.recipe.IngredientMatch;
import dev.latvian.mods.kubejs.recipe.ItemInputTransformer;
import dev.latvian.mods.kubejs.recipe.ItemOutputTransformer;
import dev.latvian.mods.kubejs.recipe.RecipeArguments;
import dev.latvian.mods.kubejs.recipe.RecipeExceptionJS;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import net.minecraft.core.Registry;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public abstract class BlockRecipeJS
extends BotaniaRecipeJS {
    protected BlockStatePredicate input;
    protected BlockStatePredicate output;

    public void create(RecipeArguments args) {
        this.output = BlockStatePredicate.fromString((String)args.getString(0, ""));
        this.input = BlockStatePredicate.fromString((String)args.getString(1, ""));
    }

    public void deserialize() {
        this.input = BlockStatePredicate.fromString((String)this.deserializeBlock(this.json.get("input").getAsJsonObject()));
        this.output = BlockStatePredicate.fromString((String)this.deserializeBlock(this.json.get("output").getAsJsonObject()));
    }

    public void serialize() {
        if (this.serializeOutputs) {
            this.json.add("output", (JsonElement)this.serializeBlock(this.output));
        }
        if (this.serializeInputs) {
            this.json.add("input", (JsonElement)this.serializeBlock(this.input));
        }
    }

    protected String deserializeBlock(JsonObject input) {
        return switch (input.get("type").getAsString()) {
            case "tag" -> "#" + input.get("tag").getAsString();
            case "block" -> input.get("block").getAsString();
            default -> null;
        };
    }

    protected JsonObject serializeBlock(BlockStatePredicate input) {
        JsonObject output = new JsonObject();
        if (input instanceof BlockStatePredicate.TagMatch) {
            BlockStatePredicate.TagMatch tagMatch = (BlockStatePredicate.TagMatch)input;
            output.addProperty("type", "tag");
            output.addProperty("tag", tagMatch.tag().f_203868_().toString());
        } else if (input instanceof BlockStatePredicate.BlockMatch) {
            BlockStatePredicate.BlockMatch blockMatch = (BlockStatePredicate.BlockMatch)input;
            output.addProperty("type", "block");
            output.addProperty("block", Registry.f_122824_.m_7981_((Object)blockMatch.block()).toString());
        } else {
            throw new RecipeExceptionJS("Can't decide what block to use for recipe %s! Can only use Block or Tag!".formatted(this.id));
        }
        return output;
    }

    protected boolean matchBlock(IngredientMatch match, BlockStatePredicate block) {
        if (block instanceof BlockStatePredicate.BlockMatch) {
            BlockStatePredicate.BlockMatch blockMatch = (BlockStatePredicate.BlockMatch)block;
            return match.contains(Ingredient.m_43929_((ItemLike[])new ItemLike[]{blockMatch.block().m_5456_()}));
        }
        return false;
    }

    protected ItemStack toItemStack(BlockStatePredicate block) {
        if (block instanceof BlockStatePredicate.BlockMatch) {
            BlockStatePredicate.BlockMatch blockMatch = (BlockStatePredicate.BlockMatch)block;
            return new ItemStack((ItemLike)blockMatch.block());
        }
        return ItemStack.f_41583_;
    }

    protected BlockStatePredicate toBlock(Ingredient ingredient) {
        BlockItem blockItem = ingredient.kjs$getItemTypes().stream().filter(item -> item instanceof BlockItem).map(item -> (BlockItem)item).findFirst().orElse(null);
        if (blockItem == null) {
            return null;
        }
        return new BlockStatePredicate.BlockMatch(blockItem.m_40614_());
    }

    public boolean hasInput(IngredientMatch match) {
        return match.contains(this.toItemStack(this.input));
    }

    public boolean hasOutput(IngredientMatch match) {
        return match.contains(this.toItemStack(this.output));
    }

    public boolean replaceInput(IngredientMatch match, Ingredient with, ItemInputTransformer transformer) {
        if (this.matchBlock(match, this.input)) {
            ItemStack itemStack = this.toItemStack(this.input);
            if (itemStack.m_41619_()) {
                return false;
            }
            BlockStatePredicate transformed = this.toBlock(transformer.transform((RecipeJS)this, match, Ingredient.m_43927_((ItemStack[])new ItemStack[]{itemStack}), with));
            if (transformed == null) {
                return false;
            }
            this.input = transformed;
        }
        return false;
    }

    public boolean replaceOutput(IngredientMatch match, ItemStack with, ItemOutputTransformer transformer) {
        if (this.matchBlock(match, this.output)) {
            ItemStack itemStack = this.toItemStack(this.output);
            if (itemStack.m_41619_()) {
                return false;
            }
            BlockStatePredicate transformed = this.toBlock(Ingredient.m_43927_((ItemStack[])new ItemStack[]{transformer.transform((RecipeJS)this, match, itemStack, with)}));
            if (transformed == null) {
                return false;
            }
            this.input = transformed;
        }
        return false;
    }
}

