/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.util;

import com.lothrazar.cyclic.ModCyclic;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockUtil {
    public static boolean rotateBlockValidState(Level world, BlockPos pos, Direction side) {
        BlockState clicked = world.m_8055_(pos);
        if (clicked.m_60734_() == null) {
            return false;
        }
        Block clickedBlock = clicked.m_60734_();
        BlockState newState = null;
        if (clicked.m_204336_(BlockTags.f_13031_)) {
            String key = "type";
            String valueDupe = "double";
            for (Property prop : clicked.m_61147_()) {
                if (!prop.m_61708_().equals("type") || !(newState = (BlockState)clicked.m_61122_(prop)).m_61143_(prop).toString().equals("double")) continue;
                newState = (BlockState)newState.m_61122_(prop);
            }
        } else if (clicked.m_61138_((Property)RotatedPillarBlock.f_55923_)) {
            Direction.Axis current = (Direction.Axis)clicked.m_61143_((Property)RotatedPillarBlock.f_55923_);
            switch (current) {
                case X: {
                    newState = (BlockState)clicked.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Y);
                    break;
                }
                case Y: {
                    newState = (BlockState)clicked.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Z);
                    break;
                }
                case Z: {
                    newState = (BlockState)clicked.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.X);
                    break;
                }
            }
        } else {
            switch (side) {
                case DOWN: {
                    newState = clicked.rotate((LevelAccessor)world, pos, Rotation.CLOCKWISE_180);
                    break;
                }
                case UP: {
                    newState = clicked.rotate((LevelAccessor)world, pos, Rotation.CLOCKWISE_180);
                    break;
                }
                case EAST: {
                    newState = clicked.rotate((LevelAccessor)world, pos, Rotation.CLOCKWISE_90);
                    break;
                }
                case NORTH: {
                    newState = clicked.rotate((LevelAccessor)world, pos, Rotation.COUNTERCLOCKWISE_90);
                    break;
                }
                case SOUTH: {
                    newState = clicked.rotate((LevelAccessor)world, pos, Rotation.CLOCKWISE_90);
                    break;
                }
                case WEST: {
                    newState = clicked.rotate((LevelAccessor)world, pos, Rotation.COUNTERCLOCKWISE_90);
                    break;
                }
            }
        }
        boolean win = false;
        if (newState != null) {
            win = world.m_46597_(pos, newState);
        }
        if (!win) {
            ModCyclic.LOGGER.error("Could not rotate " + clickedBlock);
        }
        return win;
    }

    public static boolean placeStateSafe(Level world, Player player, BlockPos placePos, BlockState placeState) {
        return BlockUtil.placeStateSafe(world, player, placePos, placeState, false);
    }

    public static boolean placeStateSafe(Level world, Player player, BlockPos placePos, BlockState placeState, boolean playSound) {
        if (placePos == null) {
            return false;
        }
        BlockState stateHere = null;
        if (!world.m_46859_(placePos) && (stateHere = world.m_8055_(placePos)) != null && !stateHere.m_60767_().m_76332_()) {
            boolean dropBlock = true;
            if (!world.f_46443_) {
                world.m_46961_(placePos, dropBlock);
            }
        }
        boolean success = false;
        try {
            if (!world.f_46443_) {
                success = world.m_7731_(placePos, placeState, 3);
            }
        }
        catch (Exception e) {
            ModCyclic.LOGGER.error("Error attempting to place block ", e);
        }
        if (!success || playSound) {
            // empty if block
        }
        return success;
    }

    public static boolean destroyBlock(Level world, BlockPos pos) {
        world.m_46747_(pos);
        return world.m_46597_(pos, Blocks.f_50016_.m_49966_());
    }

    public static boolean placeTorchSafely(Level world, BlockPos blockPos, Direction solidBlockDirection) {
        BlockItem torch = (BlockItem)Items.f_42000_;
        DirectionalPlaceContext context = new DirectionalPlaceContext(world, blockPos, solidBlockDirection, Items.f_42000_.m_7968_(), solidBlockDirection);
        return torch.m_40576_((BlockPlaceContext)context).m_19077_();
    }
}

