/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.item.transporter;

import com.lothrazar.cyclic.item.ItemBaseCyclic;
import com.lothrazar.cyclic.item.transporter.PacketChestSack;
import com.lothrazar.cyclic.registry.ItemRegistry;
import com.lothrazar.cyclic.registry.PacketRegistry;
import com.lothrazar.cyclic.registry.SoundRegistry;
import com.lothrazar.cyclic.util.BlockUtil;
import com.lothrazar.cyclic.util.ChatUtil;
import com.lothrazar.cyclic.util.ItemStackUtil;
import com.lothrazar.cyclic.util.SoundUtil;
import com.lothrazar.cyclic.util.StringParseUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.registries.ForgeRegistries;

public class TileTransporterEmptyItem
extends ItemBaseCyclic {
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> IGNORELIST;

    public TileTransporterEmptyItem(Item.Properties prop) {
        super(prop);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        BlockPos pos = context.m_8083_();
        Level world = context.m_43725_();
        BlockEntity tile = world.m_7702_(pos);
        BlockState state = world.m_8055_(pos);
        if (state == null || tile == null || state.m_60734_() == null) {
            ChatUtil.sendStatusMessage(player, "chest_sack.error.null");
            return InteractionResult.FAIL;
        }
        ResourceLocation blockId = ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_());
        if (StringParseUtil.isInList((List)IGNORELIST.get(), blockId)) {
            ChatUtil.sendStatusMessage(player, "chest_sack.error.config");
            return InteractionResult.FAIL;
        }
        SoundUtil.playSound((Entity)player, (SoundEvent)SoundRegistry.THUNK.get());
        if (world.f_46443_) {
            PacketRegistry.INSTANCE.sendToServer((Object)new PacketChestSack(pos));
        }
        return InteractionResult.SUCCESS;
    }

    public static void gatherTileEntity(BlockPos pos, Player player, Level world, BlockEntity tile) {
        if (tile == null) {
            return;
        }
        BlockState state = world.m_8055_(pos);
        if (state.m_60625_(player, (BlockGetter)world, pos) <= 0.0f) {
            return;
        }
        CompoundTag tileData = tile.m_187482_();
        CompoundTag itemData = new CompoundTag();
        itemData.m_128359_("blockname", state.m_60734_().m_7705_());
        itemData.m_128365_("tile", (Tag)tileData);
        itemData.m_128359_("block", ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_()).toString());
        itemData.m_128365_("blockstate", (Tag)NbtUtils.m_129202_((BlockState)state));
        InteractionHand hand = InteractionHand.MAIN_HAND;
        ItemStack held = player.m_21120_(hand);
        if (held == null || !(held.m_41720_() instanceof TileTransporterEmptyItem)) {
            hand = InteractionHand.OFF_HAND;
            held = player.m_21120_(hand);
        }
        if (held != null && held.m_41613_() > 0 && held.m_41720_() instanceof TileTransporterEmptyItem) {
            if (!BlockUtil.destroyBlock(world, pos)) {
                ChatUtil.sendStatusMessage(player, "chest_sack.error.pickup");
                world.m_46597_(pos, state);
                return;
            }
            ItemStack drop = new ItemStack((ItemLike)ItemRegistry.TILE_TRANSPORTER.get());
            drop.m_41751_(itemData);
            ItemStackUtil.drop(world, player.m_20183_(), drop);
            if (!player.m_7500_() && held.m_41613_() > 0) {
                held.m_41774_(1);
                if (held.m_41613_() == 0) {
                    held = ItemStack.f_41583_;
                    player.m_21008_(hand, ItemStack.f_41583_);
                }
            }
        }
    }
}

