/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.gui;

import com.lothrazar.cyclic.registry.TextureRegistry;
import com.lothrazar.cyclic.render.FluidRenderMap;
import com.lothrazar.cyclic.render.RenderUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;

public class FluidBar {
    public String emtpyTooltip = "0";
    private Screen parent;
    private int x;
    private int y;
    private int capacity;
    private int width = 18;
    private int height = 62;
    public int guiLeft;
    public int guiTop;

    public FluidBar(Screen p, int cap) {
        this(p, 132, 8, cap);
    }

    public FluidBar(Screen p, int x, int y, int cap) {
        this.parent = p;
        this.x = x;
        this.y = y;
        this.capacity = cap;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void draw(PoseStack ms, FluidStack fluid) {
        boolean u = false;
        boolean v = false;
        int x = this.guiLeft + this.getX();
        int y = this.guiTop + this.getY();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TextureRegistry.FLUID_WIDGET);
        Screen.m_93133_((PoseStack)ms, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)this.width, (int)this.height, (int)this.width, (int)this.height);
        if (fluid == null || this.getCapacity() == 0 || fluid.getAmount() == 0) {
            return;
        }
        float capacity = this.getCapacity();
        float amount = fluid.getAmount();
        float scale = amount / capacity;
        int fluidAmount = (int)(scale * (float)this.height);
        TextureAtlasSprite icon = FluidRenderMap.getFluidTexture(fluid, FluidRenderMap.FluidFlow.STILL);
        if (fluid.getFluid() == Fluids.f_76193_) {
            RenderSystem.m_157429_((float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
        }
        this.drawTiledSprite(ms, x + 1, y + 1, this.height - 2, this.width - 2, fluidAmount - 2, icon);
        if (fluid.getFluid() == Fluids.f_76193_) {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    protected void drawTiledSprite(PoseStack stack, int xPosition, int yPosition, int yOffset, int desiredWidth, int desiredHeight, TextureAtlasSprite sprite) {
        RenderUtils.drawTiledSprite(stack.m_85850_().m_85861_(), xPosition, yPosition, yOffset, desiredWidth, desiredHeight, sprite, this.width - 2, this.width - 2, this.parent.m_93252_());
    }

    public boolean isMouseover(int mouseX, int mouseY) {
        return this.guiLeft + this.x <= mouseX && mouseX <= this.guiLeft + this.x + this.width && this.guiTop + this.y <= mouseY && mouseY <= this.guiTop + this.y + this.height;
    }

    public void renderHoveredToolTip(PoseStack ms, int mouseX, int mouseY, FluidStack current) {
        if (this.isMouseover(mouseX, mouseY)) {
            this.renderTooltip(ms, mouseX, mouseY, current);
        }
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void renderTooltip(PoseStack ms, int mouseX, int mouseY, FluidStack current) {
        Object tt = this.emtpyTooltip;
        if (current != null && !current.isEmpty()) {
            tt = current.getAmount() + "/" + this.getCapacity() + " " + current.getDisplayName().getString();
        }
        ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
        list.add(Component.m_237115_((String)tt));
        this.parent.m_96597_(ms, list, mouseX, mouseY);
    }
}

