/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.tankcask;

import com.lothrazar.cyclic.block.TileBlockEntityCyclic;
import com.lothrazar.cyclic.capabilities.block.FluidTankBase;
import com.lothrazar.cyclic.registry.TileRegistry;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileCask
extends TileBlockEntityCyclic {
    private Map<Direction, Boolean> poweredSides;
    public static final int CAPACITY = 8000;
    public static final int TRANSFER_FLUID_PER_TICK = 4000;
    public FluidTankBase tank = new FluidTankBase(this, 8000, this.isFluidValid());
    LazyOptional<FluidTankBase> fluidCap = LazyOptional.of(() -> this.tank);
    private List<Integer> rawList = IntStream.rangeClosed(0, 5).boxed().collect(Collectors.toList());

    public TileCask(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileRegistry.CASK.get(), pos, state);
        this.flowing = 0;
        this.poweredSides = new HashMap<Direction, Boolean>();
        for (Direction f : Direction.values()) {
            this.poweredSides.put(f, false);
        }
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, TileCask e) {
        e.tick();
    }

    public static <E extends BlockEntity> void clientTick(Level level, BlockPos blockPos, BlockState blockState, TileCask e) {
        e.tick();
    }

    public Predicate<FluidStack> isFluidValid() {
        return p -> true;
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        for (Direction f : Direction.values()) {
            this.poweredSides.put(f, tag.m_128471_("flow_" + f.m_122433_()));
        }
        this.flowing = tag.m_128451_("flowing");
        this.tank.readFromNBT(tag.m_128469_("fluid"));
        super.m_142466_(tag);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        for (Direction f : Direction.values()) {
            tag.m_128379_("flow_" + f.m_122433_(), this.poweredSides.get(f).booleanValue());
        }
        tag.m_128405_("flowing", this.flowing);
        CompoundTag fluid = new CompoundTag();
        this.tank.writeToNBT(fluid);
        tag.m_128365_("fluid", (Tag)fluid);
        super.m_183515_(tag);
    }

    public void invalidateCaps() {
        this.fluidCap.invalidate();
        super.invalidateCaps();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public int getField(int id) {
        switch (Fields.values()[id]) {
            case D: {
                return this.getSideField(Direction.DOWN);
            }
            case E: {
                return this.getSideField(Direction.EAST);
            }
            case N: {
                return this.getSideField(Direction.NORTH);
            }
            case S: {
                return this.getSideField(Direction.SOUTH);
            }
            case U: {
                return this.getSideField(Direction.UP);
            }
            case W: {
                return this.getSideField(Direction.WEST);
            }
            case FLOWING: {
                return this.flowing;
            }
        }
        return -1;
    }

    @Override
    public void setField(int field, int value) {
        switch (Fields.values()[field]) {
            case FLOWING: {
                this.flowing = value;
                break;
            }
            case D: {
                this.setSideField(Direction.DOWN, value % 2);
                break;
            }
            case E: {
                this.setSideField(Direction.EAST, value % 2);
                break;
            }
            case N: {
                this.setSideField(Direction.NORTH, value % 2);
                break;
            }
            case S: {
                this.setSideField(Direction.SOUTH, value % 2);
                break;
            }
            case U: {
                this.setSideField(Direction.UP, value % 2);
                break;
            }
            case W: {
                this.setSideField(Direction.WEST, value % 2);
            }
        }
    }

    public boolean getSideHasPower(Direction side) {
        return this.poweredSides.get(side);
    }

    public int getSideField(Direction side) {
        return this.getSideHasPower(side) ? 1 : 0;
    }

    public void setSideField(Direction side, int pow) {
        this.poweredSides.put(side, pow == 1);
    }

    @Override
    public void setFluid(FluidStack fluid) {
        this.tank.setFluid(fluid);
    }

    public void tick() {
        if (this.flowing > 0) {
            this.tickCableFlow();
        }
    }

    private void tickCableFlow() {
        Collections.shuffle(this.rawList);
        for (Integer i : this.rawList) {
            Direction exportToSide = Direction.values()[i];
            if (!this.poweredSides.get(exportToSide).booleanValue()) continue;
            this.moveFluids(exportToSide, this.f_58858_.m_121945_(exportToSide), 1000, (IFluidHandler)this.tank);
        }
    }

    static enum Fields {
        FLOWING,
        N,
        E,
        S,
        W,
        U,
        D;

    }
}

