/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.expcollect;

import com.lothrazar.cyclic.block.TileBlockEntityCyclic;
import com.lothrazar.cyclic.block.expcollect.ContainerExpPylon;
import com.lothrazar.cyclic.capabilities.block.FluidTankBase;
import com.lothrazar.cyclic.data.DataTags;
import com.lothrazar.cyclic.fluid.FluidXpJuiceHolder;
import com.lothrazar.cyclic.registry.BlockRegistry;
import com.lothrazar.cyclic.registry.TileRegistry;
import com.lothrazar.cyclic.util.FluidHelpers;
import com.lothrazar.cyclic.util.PlayerUtil;
import com.lothrazar.cyclic.util.SoundUtil;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileExpPylon
extends TileBlockEntityCyclic
implements MenuProvider {
    public static final int FLUID_PER_EXP = 20;
    public static final int EXP_PER_BOTTLE = 11;
    public static final int CAPACITY = 64000000;
    public static ForgeConfigSpec.IntValue RADIUS;
    public FluidTankBase tank = new FluidTankBase(this, 64000000, this.isFluidValid());
    LazyOptional<FluidTankBase> fluidCap = LazyOptional.of(() -> this.tank);

    public TileExpPylon(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileRegistry.EXPERIENCE_PYLON.get(), pos, state);
        this.needsRedstone = 0;
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, TileExpPylon e) {
        e.tick();
    }

    public static <E extends BlockEntity> void clientTick(Level level, BlockPos blockPos, BlockState blockState, TileExpPylon e) {
        e.tick();
    }

    public void tick() {
        if (!this.f_58857_.f_46443_) {
            this.collectPlayerExperience();
        }
        if (this.requiresRedstone() && !this.isPowered()) {
            return;
        }
        this.collectLocalExperience();
    }

    public Predicate<FluidStack> isFluidValid() {
        return p -> FluidHelpers.matches(p.getFluid(), DataTags.EXPERIENCE);
    }

    public void invalidateCaps() {
        this.fluidCap.invalidate();
        super.invalidateCaps();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        this.tank.readFromNBT(tag.m_128469_("fluid"));
        int legacy = tag.m_128451_("storedXp");
        if (legacy > 0) {
            this.tank.setFluid(new FluidStack((Fluid)FluidXpJuiceHolder.STILL.get(), legacy * 20));
        }
        super.m_142466_(tag);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        CompoundTag fluid = new CompoundTag();
        this.tank.writeToNBT(fluid);
        tag.m_128365_("fluid", (Tag)fluid);
        tag.m_128405_("storedXp", this.getStoredXp());
        super.m_183515_(tag);
    }

    private void collectPlayerExperience() {
        List players = this.f_58857_.m_45976_(Player.class, new AABB(this.m_58899_().m_7494_()));
        for (Player p : players) {
            double myTotal = PlayerUtil.getExpTotal(p);
            if (!p.m_6047_() || !(myTotal > 0.0)) continue;
            int addMeXp = 1;
            if (p.f_36078_ > 300) {
                addMeXp = 1800;
            }
            addMeXp = p.f_36078_ > 100 ? 900 : (p.f_36078_ > 50 ? 200 : (p.f_36078_ > 30 ? 50 : (p.f_36078_ > 5 ? 10 : 1)));
            int addMeFluid = addMeXp * 20;
            if (this.tank.getFluidAmount() + addMeFluid > this.tank.getCapacity()) continue;
            p.m_6756_(-1 * addMeXp);
            this.tank.fill(new FluidStack((Fluid)FluidXpJuiceHolder.STILL.get(), addMeFluid), IFluidHandler.FluidAction.EXECUTE);
            SoundUtil.playSound((Entity)p, SoundEvents.f_11871_);
            this.m_6596_();
        }
    }

    private void collectLocalExperience() {
        int radius = (Integer)RADIUS.get();
        List list = this.f_58857_.m_6443_(ExperienceOrb.class, new AABB((double)(this.f_58858_.m_123341_() - radius), (double)(this.f_58858_.m_123342_() - 1), (double)(this.f_58858_.m_123343_() - radius), (double)(this.f_58858_.m_123341_() + radius), (double)(this.f_58858_.m_123342_() + 2), (double)(this.f_58858_.m_123343_() + radius)), entity -> entity.m_6084_() && entity.m_20801_() > 0);
        if (list.size() > 0) {
            ExperienceOrb myOrb = (ExperienceOrb)list.get(this.f_58857_.f_46441_.m_188503_(list.size()));
            int addMeXp = myOrb.m_20801_();
            if (this.getStoredXp() + addMeXp <= this.tank.getCapacity()) {
                myOrb.f_20770_ = 0;
                myOrb.m_142687_(Entity.RemovalReason.DISCARDED);
                int addMeFluid = addMeXp * 20;
                this.tank.fill(new FluidStack((Fluid)FluidXpJuiceHolder.STILL.get(), addMeFluid), IFluidHandler.FluidAction.EXECUTE);
            }
        }
    }

    @Override
    public void setFluid(FluidStack fluid) {
        this.tank.setFluid(fluid);
    }

    @Override
    public FluidStack getFluid() {
        return this.tank == null ? FluidStack.EMPTY : this.tank.getFluid();
    }

    public int getStoredXp() {
        return this.tank.getFluidAmount() / 20;
    }

    @Override
    public void setField(int field, int value) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                this.needsRedstone = value % 2;
            }
        }
    }

    @Override
    public int getField(int field) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                return this.needsRedstone;
            }
        }
        return 0;
    }

    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new ContainerExpPylon(i, this.f_58857_, this.f_58858_, playerInventory, playerEntity);
    }

    public Component m_5446_() {
        return ((Block)BlockRegistry.EXPERIENCE_PYLON.get()).m_49954_();
    }

    static enum Fields {
        REDSTONE;

    }
}

