/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.cable.energy;

import com.google.common.collect.Maps;
import com.lothrazar.cyclic.block.TileBlockEntityCyclic;
import com.lothrazar.cyclic.block.cable.CableBase;
import com.lothrazar.cyclic.block.cable.EnumConnectType;
import com.lothrazar.cyclic.capabilities.block.CustomEnergyStorage;
import com.lothrazar.cyclic.registry.TileRegistry;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

public class TileCableEnergy
extends TileBlockEntityCyclic {
    public static ForgeConfigSpec.IntValue BUFFERSIZE;
    public static ForgeConfigSpec.IntValue TRANSFER_RATE;
    CustomEnergyStorage energy;
    private LazyOptional<IEnergyStorage> energyCap;
    private Map<Direction, Integer> mapIncomingEnergy = Maps.newHashMap();
    private static final int TIMER_SIDE_INPUT = 15;

    public TileCableEnergy(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileRegistry.ENERGY_PIPE.get(), pos, state);
        for (Direction f : Direction.values()) {
            this.mapIncomingEnergy.put(f, 0);
        }
        this.energy = new CustomEnergyStorage((Integer)BUFFERSIZE.get(), (Integer)BUFFERSIZE.get());
        this.energyCap = LazyOptional.of(() -> this.energy);
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, TileCableEnergy e) {
        e.tick();
    }

    public static <E extends BlockEntity> void clientTick(Level level, BlockPos blockPos, BlockState blockState, TileCableEnergy e) {
        e.tick();
    }

    public void tick() {
        this.syncEnergy();
        this.tickDownIncomingPowerFaces();
        this.tickCableFlow();
        for (Direction side : Direction.values()) {
            EnumConnectType connection = (EnumConnectType)((Object)this.m_58900_().m_61143_((Property)CableBase.FACING_TO_PROPERTY_MAP.get(side)));
            if (!connection.isExtraction()) continue;
            this.tryExtract(side);
        }
    }

    private void tryExtract(Direction extractSide) {
        int extractSim;
        IEnergyStorage itemHandlerFrom;
        if (extractSide == null) {
            return;
        }
        BlockPos posTarget = this.f_58858_.m_121945_(extractSide);
        BlockEntity tile = this.f_58857_.m_7702_(posTarget);
        if (tile != null && (itemHandlerFrom = (IEnergyStorage)tile.getCapability(ForgeCapabilities.ENERGY, extractSide.m_122424_()).orElse(null)) != null && (extractSim = itemHandlerFrom.extractEnergy(((Integer)TRANSFER_RATE.get()).intValue(), true)) > 0 && this.energy.receiveEnergy(extractSim, true) > 0) {
            int n = itemHandlerFrom.extractEnergy(this.energy.receiveEnergy(extractSim, false), false);
        }
    }

    private void tickCableFlow() {
        List rawList = IntStream.rangeClosed(0, 5).boxed().collect(Collectors.toList());
        Collections.shuffle(rawList);
        for (Integer i : rawList) {
            Direction outgoingSide = Direction.values()[i];
            EnumConnectType connection = (EnumConnectType)((Object)this.m_58900_().m_61143_((Property)CableBase.FACING_TO_PROPERTY_MAP.get(outgoingSide)));
            if (connection.isExtraction() || connection.isBlocked() || this.isEnergyIncomingFromFace(outgoingSide)) continue;
            this.moveEnergy(outgoingSide, (Integer)TRANSFER_RATE.get());
        }
    }

    public void tickDownIncomingPowerFaces() {
        for (Direction f : Direction.values()) {
            if (this.mapIncomingEnergy.get(f) <= 0) continue;
            this.mapIncomingEnergy.put(f, this.mapIncomingEnergy.get(f) - 1);
        }
    }

    public void invalidateCaps() {
        this.energyCap.invalidate();
        super.invalidateCaps();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ENERGY && !CableBase.isCableBlocked(this.m_58900_(), side)) {
            return this.energyCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        for (Direction f : Direction.values()) {
            this.mapIncomingEnergy.put(f, tag.m_128451_(f.m_7912_() + "_incenergy"));
        }
        this.energy.deserializeNBT((Tag)tag.m_128469_("energy"));
        super.m_142466_(tag);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        for (Direction f : Direction.values()) {
            tag.m_128405_(f.m_7912_() + "_incenergy", this.mapIncomingEnergy.get(f).intValue());
        }
        tag.m_128365_("energy", (Tag)this.energy.serializeNBT());
        super.m_183515_(tag);
    }

    private boolean isEnergyIncomingFromFace(Direction face) {
        return this.mapIncomingEnergy.get(face) > 0;
    }

    public void updateIncomingEnergyFace(Direction inputFrom) {
        this.mapIncomingEnergy.put(inputFrom, 15);
    }

    @Override
    public void setField(int field, int value) {
    }

    @Override
    public int getField(int field) {
        return 0;
    }
}

